/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.dto.v2_0.util;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinitionField;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeTracker;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataLayoutUtil;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidation;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldValidationExpression;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.dynamic.data.mapping.util.SettingsDDMFormFieldsUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataDefinitionUtil {
    private static final String[] _PREDEFINED_PROPERTIES = new String[]{"indexType", "label", "localizable", "name", "predefinedValue", "readOnly", "repeatable", "required", "showLabel", "tip", "type"};
    private static final Log _log = LogFactoryUtil.getLog(DataDefinitionUtil.class);

    public static DataDefinition toDataDefinition(DataDefinitionContentTypeTracker dataDefinitionContentTypeTracker, final DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker, final DDMStructure ddmStructure, final DDMStructureLayoutLocalService ddmStructureLayoutLocalService, final SPIDDMFormRuleConverter spiDDMFormRuleConverter) throws Exception {
        final DDMForm ddmForm = ddmStructure.getDDMForm();
        final DataDefinitionContentType dataDefinitionContentType = dataDefinitionContentTypeTracker.getDataDefinitionContentType(ddmStructure.getClassNameId());
        return new DataDefinition(){
            {
                this.availableLanguageIds = DataDefinitionUtil._toLanguageIds(ddmForm.getAvailableLocales());
                this.contentType = dataDefinitionContentType.getContentType();
                this.dataDefinitionFields = DataDefinitionUtil._toDataDefinitionFields(ddmForm.getDDMFormFields(), ddmFormFieldTypeServicesTracker, ddmStructureLayoutLocalService);
                this.dataDefinitionKey = ddmStructure.getStructureKey();
                this.dateCreated = ddmStructure.getCreateDate();
                this.dateModified = ddmStructure.getModifiedDate();
                this.defaultDataLayout = DataLayoutUtil.toDataLayout(ddmFormFieldTypeServicesTracker, ddmStructure.fetchDDMStructureLayout(), spiDDMFormRuleConverter);
                this.defaultLanguageId = LanguageUtil.getLanguageId((Locale)ddmForm.getDefaultLocale());
                this.description = LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getDescriptionMap());
                this.id = ddmStructure.getStructureId();
                this.name = LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getNameMap());
                this.siteId = ddmStructure.getGroupId();
                this.storageType = ddmStructure.getStorageType();
                this.userId = ddmStructure.getUserId();
            }
        };
    }

    private static Map<String, Object> _getCustomProperties(DDMFormField ddmFormField, DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker, DDMStructureLayoutLocalService ddmStructureLayoutLocalService) {
        Map settingsDDMFormFieldsMap = SettingsDDMFormFieldsUtil.getSettingsDDMFormFields((DDMFormFieldTypeServicesTracker)ddmFormFieldTypeServicesTracker, (String)ddmFormField.getType());
        Map properties = ddmFormField.getProperties();
        HashMap<String, Object> customProperties = new HashMap<String, Object>();
        for (Map.Entry entry : properties.entrySet()) {
            DDMFormField settingsDDMFormField;
            if (ArrayUtil.contains((Object[])_PREDEFINED_PROPERTIES, entry.getKey()) || (settingsDDMFormField = (DDMFormField)settingsDDMFormFieldsMap.get(entry.getKey())) == null) continue;
            if (settingsDDMFormField.isLocalizable()) {
                customProperties.put((String)entry.getKey(), LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)((LocalizedValue)entry.getValue())));
                continue;
            }
            if (Objects.equals(settingsDDMFormField.getDataType(), "boolean")) {
                customProperties.put((String)entry.getKey(), GetterUtil.getBoolean(entry.getValue()));
                continue;
            }
            if (Objects.equals(settingsDDMFormField.getDataType(), "ddm-options")) {
                customProperties.put((String)entry.getKey(), DataDefinitionUtil._toMap((DDMFormFieldOptions)entry.getValue()));
                continue;
            }
            if (Objects.equals(settingsDDMFormField.getType(), "validation")) {
                customProperties.put((String)entry.getKey(), DataDefinitionUtil._toMap((DDMFormFieldValidation)entry.getValue()));
                continue;
            }
            customProperties.put((String)entry.getKey(), entry.getValue());
        }
        if (Validator.isNotNull((Object)ddmFormField.getProperty("ddmStructureLayoutId"))) {
            customProperties.put("rows", DataDefinitionUtil._getRows(GetterUtil.getLong((Object)ddmFormField.getProperty("ddmStructureLayoutId")), ddmStructureLayoutLocalService));
        }
        return customProperties;
    }

    private static String _getRows(long ddmStructureLayoutId, DDMStructureLayoutLocalService ddmStructureLayoutLocalService) {
        try {
            DDMStructureLayout ddmStructureLayout = ddmStructureLayoutLocalService.getStructureLayout(ddmStructureLayoutId);
            JSONArray jsonArray = JSONUtil.getValueAsJSONArray((Object)JSONFactoryUtil.createJSONObject((String)StringUtil.replace((String)ddmStructureLayout.getDefinition(), (String)"fieldNames", (String)"fields")), (String[])new String[]{"JSONArray/pages", "Object/0", "JSONArray/rows"});
            return jsonArray.toString();
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)portalException, (Throwable)portalException);
            }
            return "";
        }
    }

    private static DataDefinitionField _toDataDefinitionField(final DDMFormField ddmFormField, final DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker, final DDMStructureLayoutLocalService ddmStructureLayoutLocalService) {
        return new DataDefinitionField(){
            {
                this.customProperties = DataDefinitionUtil._getCustomProperties(ddmFormField, ddmFormFieldTypeServicesTracker, ddmStructureLayoutLocalService);
                this.defaultValue = LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormField.getPredefinedValue());
                this.fieldType = ddmFormField.getType();
                this.indexable = Validator.isNotNull((String)ddmFormField.getIndexType());
                this.indexType = DataDefinitionField.IndexType.create((String)ddmFormField.getIndexType());
                this.label = LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormField.getLabel());
                this.localizable = ddmFormField.isLocalizable();
                this.name = ddmFormField.getName();
                this.nestedDataDefinitionFields = DataDefinitionUtil._toDataDefinitionFields(ddmFormField.getNestedDDMFormFields(), ddmFormFieldTypeServicesTracker, ddmStructureLayoutLocalService);
                this.readOnly = ddmFormField.isReadOnly();
                this.repeatable = ddmFormField.isRepeatable();
                this.required = ddmFormField.isRequired();
                this.showLabel = ddmFormField.isShowLabel();
                this.tip = LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormField.getTip());
            }
        };
    }

    private static DataDefinitionField[] _toDataDefinitionFields(List<DDMFormField> ddmFormFields, DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker, DDMStructureLayoutLocalService ddmStructureLayoutLocalService) {
        if (ListUtil.isEmpty(ddmFormFields)) {
            return new DataDefinitionField[0];
        }
        Stream stream = ddmFormFields.stream();
        return stream.map(ddmFormField -> DataDefinitionUtil._toDataDefinitionField(ddmFormField, ddmFormFieldTypeServicesTracker, ddmStructureLayoutLocalService)).collect(Collectors.toList()).toArray(new DataDefinitionField[0]);
    }

    private static String[] _toLanguageIds(Set<Locale> locales) {
        Stream stream = locales.stream();
        return stream.map(LanguageUtil::getLanguageId).collect(Collectors.toList()).toArray(new String[0]);
    }

    private static Map<String, List<Map<String, String>>> _toMap(DDMFormFieldOptions ddmFormFieldOptions) {
        Set optionsValues = ddmFormFieldOptions.getOptionsValues();
        if (optionsValues.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, List<Map<String, String>>> options = new HashMap<String, List<Map<String, String>>>();
        for (String optionValue : optionsValues) {
            LocalizedValue localizedValue = ddmFormFieldOptions.getOptionLabels(optionValue);
            for (Locale locale : localizedValue.getAvailableLocales()) {
                String languageId = LanguageUtil.getLanguageId((Locale)locale);
                if (options.containsKey(languageId)) {
                    List values = (List)options.get(languageId);
                    values.add(HashMapBuilder.put((Object)"label", (Object)localizedValue.getString(locale)).put((Object)"reference", (Object)ddmFormFieldOptions.getOptionReference(optionValue)).put((Object)"value", (Object)optionValue).build());
                    continue;
                }
                options.put(languageId, ListUtil.toList((Object)HashMapBuilder.put((Object)"label", (Object)localizedValue.getString(locale)).put((Object)"reference", (Object)ddmFormFieldOptions.getOptionReference(optionValue)).put((Object)"value", (Object)optionValue).build()));
            }
        }
        return options;
    }

    private static Map<String, Object> _toMap(DDMFormFieldValidation ddmFormFieldValidation) {
        if (ddmFormFieldValidation == null) {
            return Collections.emptyMap();
        }
        return HashMapBuilder.put((Object)"errorMessage", (Object)LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormFieldValidation.getErrorMessageLocalizedValue())).put((Object)"expression", DataDefinitionUtil._toMap(ddmFormFieldValidation.getDDMFormFieldValidationExpression())).put((Object)"parameter", (Object)LocalizedValueUtil.toLocalizedValuesMap((LocalizedValue)ddmFormFieldValidation.getParameterLocalizedValue())).build();
    }

    private static Map<String, Object> _toMap(DDMFormFieldValidationExpression ddmFormFieldValidationExpression) {
        if (ddmFormFieldValidationExpression == null) {
            return Collections.emptyMap();
        }
        return HashMapBuilder.put((Object)"name", (Object)ddmFormFieldValidationExpression.getName()).put((Object)"value", (Object)ddmFormFieldValidationExpression.getValue()).build();
    }
}

