/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v2_0;

import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.model.DEDataDefinitionFieldLink;
import com.liferay.data.engine.model.DEDataListView;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinitionFieldLink;
import com.liferay.data.engine.rest.dto.v2_0.DataLayout;
import com.liferay.data.engine.rest.dto.v2_0.DataListView;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeTracker;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataDefinitionUtil;
import com.liferay.data.engine.rest.internal.resource.v2_0.BaseDataDefinitionFieldLinkResourceImpl;
import com.liferay.data.engine.rest.resource.v2_0.DataDefinitionFieldLinkResource;
import com.liferay.data.engine.service.DEDataDefinitionFieldLinkLocalService;
import com.liferay.data.engine.service.DEDataListViewLocalService;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v2_0/data-definition-field-link.properties"}, scope=ServiceScope.PROTOTYPE, service={DataDefinitionFieldLinkResource.class})
public class DataDefinitionFieldLinkResourceImpl
extends BaseDataDefinitionFieldLinkResourceImpl {
    @Reference
    private DataDefinitionContentTypeTracker _dataDefinitionContentTypeTracker;
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DEDataDefinitionFieldLinkLocalService _deDataDefinitionFieldLinkLocalService;
    @Reference
    private DEDataListViewLocalService _deDataListViewLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private SPIDDMFormRuleConverter _spiDDMFormRuleConverter;

    @Override
    public Page<DataDefinitionFieldLink> getDataDefinitionDataDefinitionFieldLinkPage(Long dataDefinitionId, String fieldName) throws Exception {
        List deDataDefinitionFieldLinks = null;
        deDataDefinitionFieldLinks = Validator.isNotNull((String)fieldName) ? this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(dataDefinitionId.longValue(), new String[]{fieldName}) : this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(dataDefinitionId.longValue());
        HashMap<Long, DataDefinitionFieldLink> dataDefinitionFieldLinksMap = new HashMap<Long, DataDefinitionFieldLink>();
        for (DEDataDefinitionFieldLink deDataDefinitionFieldLink : deDataDefinitionFieldLinks) {
            this._addDataDefinitionFieldLink(dataDefinitionFieldLinksMap, dataDefinitionId, deDataDefinitionFieldLink, fieldName);
        }
        return Page.of(dataDefinitionFieldLinksMap.values());
    }

    private void _addDataDefinitionFieldLink(Map<Long, DataDefinitionFieldLink> dataDefinitionFieldLinks, Long dataDefinitionId, final DEDataDefinitionFieldLink deDataDefinitionFieldLink, String fieldName) throws Exception {
        if (this._portal.getClassNameId(DDMStructure.class) == deDataDefinitionFieldLink.getClassNameId()) {
            dataDefinitionFieldLinks.putIfAbsent(deDataDefinitionFieldLink.getClassPK(), this._createDataDefinitionFieldLink(deDataDefinitionFieldLink.getClassPK()));
        } else if (this._portal.getClassNameId(DDMStructureLayout.class) == deDataDefinitionFieldLink.getClassNameId()) {
            final DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(deDataDefinitionFieldLink.getClassPK());
            if (Validator.isNull((String)fieldName) && dataDefinitionId.longValue() == ddmStructureLayout.getDDMStructureId()) {
                return;
            }
            DataDefinitionFieldLink dataDefinitionFieldLink = dataDefinitionFieldLinks.getOrDefault(ddmStructureLayout.getDDMStructureId(), this._createDataDefinitionFieldLink(ddmStructureLayout.getDDMStructureId()));
            dataDefinitionFieldLink.setDataLayouts((DataLayout[])ArrayUtil.append((Object[])dataDefinitionFieldLink.getDataLayouts(), (Object)new DataLayout(){
                {
                    this.id = ddmStructureLayout.getStructureLayoutId();
                    this.name = LocalizedValueUtil.toStringObjectMap((Map)ddmStructureLayout.getNameMap());
                }
            }));
            dataDefinitionFieldLinks.put(ddmStructureLayout.getDDMStructureId(), dataDefinitionFieldLink);
        } else if (this._portal.getClassNameId(DEDataListView.class) == deDataDefinitionFieldLink.getClassNameId()) {
            final DEDataListView deDataListView = this._deDataListViewLocalService.getDEDataListView(deDataDefinitionFieldLink.getClassPK());
            DataDefinitionFieldLink dataDefinitionFieldLink = dataDefinitionFieldLinks.getOrDefault(deDataListView.getDdmStructureId(), this._createDataDefinitionFieldLink(deDataListView.getDdmStructureId()));
            dataDefinitionFieldLink.setDataListViews((DataListView[])ArrayUtil.append((Object[])dataDefinitionFieldLink.getDataListViews(), (Object)new DataListView(){
                {
                    this.id = deDataDefinitionFieldLink.getDeDataDefinitionFieldLinkId();
                    this.name = LocalizedValueUtil.toStringObjectMap((Map)deDataListView.getNameMap());
                }
            }));
            dataDefinitionFieldLinks.put(deDataListView.getDdmStructureId(), dataDefinitionFieldLink);
        }
    }

    private DataDefinitionFieldLink _createDataDefinitionFieldLink(final long dataDefinitionId) throws Exception {
        return new DataDefinitionFieldLink(){
            {
                this.dataDefinition = DataDefinitionUtil.toDataDefinition(DataDefinitionFieldLinkResourceImpl.this._dataDefinitionContentTypeTracker, DataDefinitionFieldLinkResourceImpl.this._ddmFormFieldTypeServicesTracker, DataDefinitionFieldLinkResourceImpl.this._ddmStructureLocalService.getDDMStructure(dataDefinitionId), DataDefinitionFieldLinkResourceImpl.this._ddmStructureLayoutLocalService, DataDefinitionFieldLinkResourceImpl.this._spiDDMFormRuleConverter);
                this.dataLayouts = new DataLayout[0];
                this.dataListViews = new DataListView[0];
            }
        };
    }
}

