/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.storage;

import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v2_0.DataRecord;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeTracker;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataDefinitionUtil;
import com.liferay.data.engine.rest.internal.storage.util.DataStorageUtil;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ListUtil;
import java.util.List;
import java.util.stream.Stream;

public class DataRecordExporter {
    private static final Log _log = LogFactoryUtil.getLog(DataRecordExporter.class);
    private final DataDefinitionContentTypeTracker _dataDefinitionContentTypeTracker;
    private final DDLRecordSetLocalService _ddlRecordSetLocalService;
    private final DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    private final DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    private final SPIDDMFormRuleConverter _spiDDMFormRuleConverter;

    public DataRecordExporter(DataDefinitionContentTypeTracker dataDefinitionContentTypeTracker, DDLRecordSetLocalService ddlRecordSetLocalService, DDMFormFieldTypeServicesTracker ddmFormFieldTypeServicesTracker, DDMStructureLayoutLocalService ddmStructureLayoutLocalService, SPIDDMFormRuleConverter spiDDMFormRuleConverter) {
        this._dataDefinitionContentTypeTracker = dataDefinitionContentTypeTracker;
        this._ddlRecordSetLocalService = ddlRecordSetLocalService;
        this._ddmFormFieldTypeServicesTracker = ddmFormFieldTypeServicesTracker;
        this._ddmStructureLayoutLocalService = ddmStructureLayoutLocalService;
        this._spiDDMFormRuleConverter = spiDDMFormRuleConverter;
    }

    public String export(List<DataRecord> dataRecords) throws Exception {
        if (ListUtil.isEmpty(dataRecords)) {
            return "";
        }
        DataRecord dataRecord = dataRecords.get(0);
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(dataRecord.getDataRecordCollectionId().longValue());
        DataDefinition dataDefinition = DataDefinitionUtil.toDataDefinition(this._dataDefinitionContentTypeTracker, this._ddmFormFieldTypeServicesTracker, ddlRecordSet.getDDMStructure(), this._ddmStructureLayoutLocalService, this._spiDDMFormRuleConverter);
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray();
        Stream stream = dataRecords.parallelStream();
        stream.map(record -> this._toJSON(dataDefinition, (DataRecord)record)).forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
        return jsonArray.toString();
    }

    private String _toJSON(DataDefinition dataDefinition, DataRecord dataRecord) {
        try {
            return DataStorageUtil.toJSON(dataDefinition, dataRecord.getDataRecordValues());
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            return "";
        }
    }
}

