/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.storage.util;

import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinitionField;
import com.liferay.data.engine.rest.strategy.util.DataRecordValueKeyUtil;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DataStorageUtil {
    public static Map<String, Object> toDataRecordValues(DDMFormValues ddmFormValues, DDMStructure ddmStructure) throws PortalException {
        if (ddmFormValues == null) {
            return Collections.emptyMap();
        }
        DataStorageUtil._addMissingDDMFormFieldValues(ddmStructure.getFullHierarchyDDMFormFieldsMap(false), ddmFormValues);
        HashMap<String, Object> values = new HashMap<String, Object>();
        String previousDDMFormFieldValueName = "";
        Integer repeatableIndex = 0;
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormValues.getDDMFormFieldValues()) {
            String ddmFormFieldValueName = ddmFormFieldValue.getName();
            repeatableIndex = DataStorageUtil._updateRepeatableIndex(ddmFormFieldValueName, previousDDMFormFieldValueName, repeatableIndex);
            previousDDMFormFieldValueName = ddmFormFieldValueName;
            DataStorageUtil._addValues(ddmStructure.getFullHierarchyDDMFormFieldsMap(true), ddmFormFieldValue, "", repeatableIndex, values);
        }
        return values;
    }

    public static String toJSON(DataDefinition dataDefinition, Map<String, ?> dataRecordValues) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        Map dataDefinitionFields = Stream.of(dataDefinition.getDataDefinitionFields()).collect(Collectors.toMap(dataDefinitionField -> dataDefinitionField.getName(), Function.identity()));
        for (Map.Entry entry : dataDefinitionFields.entrySet()) {
            if (!dataRecordValues.containsKey(entry.getKey())) continue;
            DataDefinitionField dataDefinitionField2 = (DataDefinitionField)entry.getValue();
            if (dataDefinitionField2.getRepeatable().booleanValue()) {
                jsonObject.put(entry.getKey(), JSONFactoryUtil.createJSONArray((Collection)((List)dataRecordValues.get(entry.getKey()))));
                continue;
            }
            jsonObject.put(entry.getKey(), dataRecordValues.get(entry.getKey()));
        }
        return jsonObject.toString();
    }

    private static void _addMissingDDMFormFieldValues(Map<String, DDMFormField> ddmFormFields, DDMFormValues ddmFormValues) {
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap(false);
        ArrayList<DDMFormFieldValue> ddmFormFieldValues = new ArrayList<DDMFormFieldValue>();
        for (DDMFormField ddmFormField : ddmFormFields.values()) {
            ddmFormFieldValues.addAll(DataStorageUtil._getDDMFormFieldValues(ddmFormField, (List)ddmFormFieldValuesMap.get(ddmFormField.getName()), ddmFormValues.getDefaultLocale()));
        }
        ddmFormValues.setDDMFormFieldValues(ddmFormFieldValues);
    }

    private static void _addValues(Map<String, DDMFormField> ddmFormFields, DDMFormFieldValue ddmFormFieldValue, String parentDataRecordValueKey, Integer repeatableIndex, Map<String, Object> values) {
        DDMFormField ddmFormField = ddmFormFields.get(ddmFormFieldValue.getName());
        if (ddmFormField == null) {
            return;
        }
        String dataRecordValueKey = DataRecordValueKeyUtil.createDataRecordValueKey((String)ddmFormField.getName(), (String)ddmFormFieldValue.getInstanceId(), (String)parentDataRecordValueKey, (int)repeatableIndex);
        if (StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")) {
            values.put(dataRecordValueKey, "");
            String previousNestedDDMFormFieldValueName = "";
            Integer nestedRepeatableIndex = 0;
            for (DDMFormFieldValue nestedDDMFormFieldValue : ddmFormFieldValue.getNestedDDMFormFieldValues()) {
                String nestedDDMFormFieldValueName = nestedDDMFormFieldValue.getName();
                nestedRepeatableIndex = DataStorageUtil._updateRepeatableIndex(nestedDDMFormFieldValueName, previousNestedDDMFormFieldValueName, nestedRepeatableIndex);
                previousNestedDDMFormFieldValueName = nestedDDMFormFieldValueName;
                DataStorageUtil._addValues(ddmFormFields, nestedDDMFormFieldValue, dataRecordValueKey, nestedRepeatableIndex, values);
            }
        } else {
            Value value = ddmFormFieldValue.getValue();
            if (value == null) {
                values.put(dataRecordValueKey, null);
            } else if (ddmFormField.isLocalizable() && !ddmFormField.isTransient()) {
                values.put(dataRecordValueKey, DataStorageUtil._toLocalizedMap(ddmFormField.getType(), (LocalizedValue)value));
            } else {
                values.put(dataRecordValueKey, GetterUtil.getString((String)value.getString(value.getDefaultLocale())));
            }
        }
    }

    private static DDMFormFieldValue _createDDMFormFieldValue(final DDMFormField ddmFormField, Locale locale) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue(){
            {
                this.setInstanceId(StringUtil.randomString());
                this.setName(ddmFormField.getName());
            }
        };
        if (ddmFormField.isLocalizable() && !ddmFormField.isTransient()) {
            LocalizedValue value = new LocalizedValue(locale);
            value.addString(locale, "");
            ddmFormFieldValue.setValue((Value)value);
        } else {
            ddmFormFieldValue.setValue((Value)new UnlocalizedValue(""));
        }
        return ddmFormFieldValue;
    }

    private static List<DDMFormFieldValue> _getDDMFormFieldValues(DDMFormField ddmFormField, List<DDMFormFieldValue> ddmFormFieldValues, Locale locale) {
        if (ListUtil.isEmpty(ddmFormFieldValues)) {
            ddmFormFieldValues = Arrays.asList(DataStorageUtil._createDDMFormFieldValue(ddmFormField, locale));
        }
        for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
            if (!StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")) continue;
            ArrayList<DDMFormFieldValue> nestedDDMFormFieldValues = new ArrayList<DDMFormFieldValue>();
            for (DDMFormField nestedDDMFormField : ddmFormField.getNestedDDMFormFields()) {
                Map nestedDDMFormFieldValuesMap = ddmFormFieldValue.getNestedDDMFormFieldValuesMap();
                nestedDDMFormFieldValues.addAll(DataStorageUtil._getDDMFormFieldValues(nestedDDMFormField, (List)nestedDDMFormFieldValuesMap.get(nestedDDMFormField.getName()), locale));
            }
            ddmFormFieldValue.setNestedDDMFormFields(nestedDDMFormFieldValues);
        }
        return ddmFormFieldValues;
    }

    private static Map<String, Object> _toLocalizedMap(String fieldType, LocalizedValue localizedValue) {
        Set availableLocales = localizedValue.getAvailableLocales();
        Stream stream = availableLocales.stream();
        if (fieldType.equals("checkbox_multiple") || fieldType.equals("select")) {
            return stream.collect(Collectors.toMap(LanguageUtil::getLanguageId, locale -> DataStorageUtil._toStringList(locale, localizedValue)));
        }
        return stream.collect(Collectors.toMap(LanguageUtil::getLanguageId, arg_0 -> ((LocalizedValue)localizedValue).getString(arg_0)));
    }

    private static List<String> _toStringList(Locale locale, LocalizedValue localizedValue) {
        try {
            return JSONUtil.toStringList((JSONArray)JSONFactoryUtil.createJSONArray((String)localizedValue.getString(locale)));
        }
        catch (JSONException jsonException) {
            return Collections.emptyList();
        }
    }

    private static Integer _updateRepeatableIndex(String ddmFormFieldValueName, String previousDDMFormFieldValueName, Integer repeatableIndex) {
        if (!StringUtil.equals((String)ddmFormFieldValueName, (String)previousDDMFormFieldValueName)) {
            return 0;
        }
        repeatableIndex = repeatableIndex + 1;
        return repeatableIndex;
    }
}

