/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v2_0;

import com.google.gson.Gson;
import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.field.type.util.LocalizedValueUtil;
import com.liferay.data.engine.model.DEDataDefinitionFieldLink;
import com.liferay.data.engine.model.DEDataDefinitionFieldLinkModel;
import com.liferay.data.engine.model.DEDataListView;
import com.liferay.data.engine.nativeobject.tracker.DataEngineNativeObjectTracker;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinition;
import com.liferay.data.engine.rest.dto.v2_0.DataDefinitionField;
import com.liferay.data.engine.rest.dto.v2_0.DataLayout;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutColumn;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutPage;
import com.liferay.data.engine.rest.dto.v2_0.DataLayoutRow;
import com.liferay.data.engine.rest.dto.v2_0.DataListView;
import com.liferay.data.engine.rest.dto.v2_0.DataRecordCollection;
import com.liferay.data.engine.rest.dto.v2_0.util.DataDefinitionDDMFormUtil;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeTracker;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataDefinitionUtil;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataLayoutUtil;
import com.liferay.data.engine.rest.internal.odata.entity.v2_0.DataDefinitionEntityModel;
import com.liferay.data.engine.rest.internal.resource.v2_0.BaseDataDefinitionResourceImpl;
import com.liferay.data.engine.rest.internal.security.permission.resource.DataDefinitionModelResourcePermission;
import com.liferay.data.engine.rest.resource.exception.DataDefinitionValidationException;
import com.liferay.data.engine.rest.resource.v2_0.DataDefinitionResource;
import com.liferay.data.engine.rest.resource.v2_0.DataLayoutResource;
import com.liferay.data.engine.rest.resource.v2_0.DataListViewResource;
import com.liferay.data.engine.rest.resource.v2_0.DataRecordCollectionResource;
import com.liferay.data.engine.service.DEDataDefinitionFieldLinkLocalService;
import com.liferay.data.engine.service.DEDataListViewLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.exception.RequiredStructureException;
import com.liferay.dynamic.data.mapping.form.builder.rule.DDMFormRuleDeserializer;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormRenderingContext;
import com.liferay.dynamic.data.mapping.form.renderer.DDMFormTemplateContextFactory;
import com.liferay.dynamic.data.mapping.form.values.factory.DDMFormValuesFactory;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormLayoutSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureLayout;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDMFormFactory;
import com.liferay.dynamic.data.mapping.util.DDMFormLayoutFactory;
import com.liferay.dynamic.data.mapping.util.comparator.StructureCreateDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureModifiedDateComparator;
import com.liferay.dynamic.data.mapping.util.comparator.StructureNameComparator;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidationException;
import com.liferay.dynamic.data.mapping.validator.DDMFormValidator;
import com.liferay.frontend.js.loader.modules.extender.npm.NPMResolver;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.editor.configuration.EditorConfiguration;
import com.liferay.portal.kernel.editor.configuration.EditorConfigurationFactory;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.permission.Permission;
import com.liferay.portal.vulcan.permission.PermissionUtil;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ValidationException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v2_0/data-definition.properties"}, scope=ServiceScope.PROTOTYPE, service={DataDefinitionResource.class})
public class DataDefinitionResourceImpl
extends BaseDataDefinitionResourceImpl {
    private static final Log _log = LogFactoryUtil.getLog(DataDefinitionResourceImpl.class);
    private static final EntityModel _entityModel = new DataDefinitionEntityModel();
    @Reference
    private DataDefinitionContentTypeTracker _dataDefinitionContentTypeTracker;
    @Reference
    private DataDefinitionModelResourcePermission _dataDefinitionModelResourcePermission;
    @Reference
    private DataEngineNativeObjectTracker _dataEngineNativeObjectTracker;
    @Reference
    private DataLayoutResource.Factory _dataLayoutResourceFactory;
    @Reference
    private DataListViewResource.Factory _dataListViewResourceFactory;
    @Reference
    private DataRecordCollectionResource.Factory _dataRecordCollectionResourceFactory;
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference(target="(ddm.form.layout.serializer.type=json)")
    private DDMFormLayoutSerializer _ddmFormLayoutSerializer;
    @Reference
    private DDMFormRuleDeserializer _ddmFormRuleDeserializer;
    @Reference(target="(ddm.form.serializer.type=json)")
    private DDMFormSerializer _ddmFormSerializer;
    @Reference
    private DDMFormTemplateContextFactory _ddmFormTemplateContextFactory;
    @Reference
    private DDMFormValidator _ddmFormValidator;
    @Reference
    private DDMFormValuesFactory _ddmFormValuesFactory;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureLinkLocalService _ddmStructureLinkLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DEDataDefinitionFieldLinkLocalService _deDataDefinitionFieldLinkLocalService;
    @Reference
    private DEDataListViewLocalService _deDataListViewLocalService;
    @Reference
    private EditorConfigurationFactory _editorConfigurationFactory;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private NPMResolver _npmResolver;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private SPIDDMFormRuleConverter _spiDDMFormRuleConverter;

    @Override
    public void deleteDataDefinition(Long dataDefinitionId) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "DELETE");
        List ddmStructureLinks = this._ddmStructureLinkLocalService.getStructureLinks(dataDefinitionId.longValue());
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(dataDefinitionId.longValue());
        DataDefinitionContentType dataDefinitionContentType = this._dataDefinitionContentTypeTracker.getDataDefinitionContentType(ddmStructure.getClassNameId());
        List deDataDefinitionFieldLinks = this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(dataDefinitionId.longValue());
        Stream stream = deDataDefinitionFieldLinks.stream();
        if (ddmStructureLinks.size() > 1 || !dataDefinitionContentType.allowReferencedDataDefinitionDeletion() && stream.filter(deDataDefinitionFieldLink -> StringUtil.equals((String)deDataDefinitionFieldLink.getClassName(), (String)DDMStructure.class.getName())).count() > 0L) {
            throw new RequiredStructureException.MustNotDeleteStructureReferencedByStructureLinks(dataDefinitionId.longValue());
        }
        DataLayoutResource dataLayoutResource = this._getDataLayoutResource(false);
        dataLayoutResource.deleteDataDefinitionDataLayout(dataDefinitionId);
        DataListViewResource.Builder dataListViewResourceBuilder = this._dataListViewResourceFactory.create();
        DataListViewResource dataListViewResource = dataListViewResourceBuilder.checkPermissions(false).user(this.contextUser).build();
        dataListViewResource.deleteDataDefinitionDataListView(dataDefinitionId);
        this._ddlRecordSetLocalService.deleteDDMStructureRecordSets(dataDefinitionId.longValue());
        this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructure.class), dataDefinitionId.longValue());
        for (DEDataDefinitionFieldLink deDataDefinitionFieldLink2 : deDataDefinitionFieldLinks) {
            this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLink(deDataDefinitionFieldLink2);
            if (deDataDefinitionFieldLink2.getClassNameId() != this._portal.getClassNameId(DDMStructure.class)) continue;
            DataDefinition dataDefinition = this._toDataDefinition(this._ddmStructureLocalService.getStructure(deDataDefinitionFieldLink2.getClassPK()));
            dataDefinition.setDataDefinitionFields((DataDefinitionField[])ArrayUtil.filter((Object[])dataDefinition.getDataDefinitionFields(), dataDefinitionField -> !StringUtil.equals((String)dataDefinitionField.getName(), (String)deDataDefinitionFieldLink2.getFieldName())));
            this._removeFieldsFromDataLayoutsAndDataListViews(deDataDefinitionFieldLink2.getClassPK(), this._getRemovedFieldNames(dataDefinition, dataDefinition.getId()));
            this._updateDataDefinition(dataDefinition, dataDefinition.getId(), DataDefinitionDDMFormUtil.toDDMForm((DataDefinition)dataDefinition, (DDMFormFieldTypeServicesTracker)this._ddmFormFieldTypeServicesTracker));
        }
        this._ddmStructureLocalService.deleteStructure(dataDefinitionId.longValue());
    }

    @Override
    public DataDefinition getDataDefinition(Long dataDefinitionId) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "VIEW");
        return DataDefinitionUtil.toDataDefinition(this._dataDefinitionContentTypeTracker, this._ddmFormFieldTypeServicesTracker, this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue()), this._ddmStructureLayoutLocalService, this._spiDDMFormRuleConverter);
    }

    @Override
    public Page<DataDefinition> getDataDefinitionByContentTypeContentTypePage(String contentType, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        return this.getSiteDataDefinitionByContentTypeContentTypePage(this._portal.getSiteGroupId(this.contextCompany.getGroupId()), contentType, keywords, pagination, sorts);
    }

    @Override
    public String getDataDefinitionDataDefinitionFieldFieldTypes() throws Exception {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        Set ddmFormFieldTypeNames = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldTypeNames();
        Stream stream = ddmFormFieldTypeNames.stream();
        stream.map(ddmFormFieldTypeName -> this._getFieldTypeMetadataJSONObject((String)ddmFormFieldTypeName, this._getResourceBundle((String)ddmFormFieldTypeName, this.contextAcceptLanguage.getPreferredLocale()))).forEach(arg_0 -> ((JSONArray)jsonArray).put(arg_0));
        return jsonArray.toString();
    }

    @Override
    public Page<Permission> getDataDefinitionPermissionsPage(Long dataDefinitionId, String roleNames) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "PERMISSIONS");
        String resourceName = this.getPermissionCheckerResourceName(dataDefinitionId);
        return Page.of(this.transform(PermissionUtil.getRoles((Company)this.contextCompany, (RoleLocalService)this.roleLocalService, (String[])StringUtil.split((String)roleNames)), role -> PermissionUtil.toPermission((Long)this.contextCompany.getCompanyId(), (Long)dataDefinitionId, (List)this.resourceActionLocalService.getResourceActions(resourceName), (String)resourceName, (ResourcePermissionLocalService)this.resourcePermissionLocalService, (Role)role)));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws Exception {
        return _entityModel;
    }

    @Override
    public DataDefinition getSiteDataDefinitionByContentTypeByDataDefinitionKey(Long siteId, String contentType, String dataDefinitionKey) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(siteId.longValue(), this._dataDefinitionContentTypeTracker.getClassNameId(contentType).longValue(), dataDefinitionKey);
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), ddmStructure.getStructureId(), "VIEW");
        return DataDefinitionUtil.toDataDefinition(this._dataDefinitionContentTypeTracker, this._ddmFormFieldTypeServicesTracker, ddmStructure, this._ddmStructureLayoutLocalService, this._spiDDMFormRuleConverter);
    }

    @Override
    public Page<DataDefinition> getSiteDataDefinitionByContentTypeContentTypePage(Long siteId, String contentType, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new ValidationException(LanguageUtil.format((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        if (ArrayUtil.isEmpty((Object[])sorts)) {
            sorts = new Sort[]{new Sort(Field.getSortableFieldName((String)"modified"), 3, true)};
        }
        if (Validator.isNull((String)keywords)) {
            return Page.of(this.transform(this._ddmStructureLocalService.getStructures(siteId.longValue(), this._dataDefinitionContentTypeTracker.getClassNameId(contentType).longValue(), pagination.getStartPosition(), pagination.getEndPosition(), this._toOrderByComparator((Sort)ArrayUtil.getValue((Object[])sorts, (int)0))), this::_toDataDefinition), (Pagination)pagination, (long)this._ddmStructureLocalService.getStructuresCount(siteId.longValue(), this._dataDefinitionContentTypeTracker.getClassNameId(contentType).longValue()));
        }
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> {}, null, (String)DDMStructure.class.getName(), (String)keywords, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"classNameId", "entryClassPK"}), searchContext -> {
            searchContext.setAttribute("classNameId", (Serializable)this._dataDefinitionContentTypeTracker.getClassNameId(contentType));
            searchContext.setAttribute("description", (Serializable)((Object)keywords));
            searchContext.setAttribute("name", (Serializable)((Object)keywords));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setGroupIds(new long[]{siteId});
        }, (Sort[])sorts, document -> DataDefinitionUtil.toDataDefinition(this._dataDefinitionContentTypeTracker, this._ddmFormFieldTypeServicesTracker, this._ddmStructureLocalService.getStructure(GetterUtil.getLong((String)document.get("entryClassPK"))), this._ddmStructureLayoutLocalService, this._spiDDMFormRuleConverter));
    }

    @Override
    public DataDefinition postDataDefinitionByContentType(String contentType, DataDefinition dataDefinition) throws Exception {
        return this.postSiteDataDefinitionByContentType(this._portal.getSiteGroupId(this.contextCompany.getGroupId()), contentType, dataDefinition);
    }

    @Override
    public DataDefinition postSiteDataDefinitionByContentType(Long siteId, String contentType, DataDefinition dataDefinition) throws Exception {
        this._dataDefinitionModelResourcePermission.checkPortletPermission(PermissionThreadLocal.getPermissionChecker(), contentType, (long)siteId, "ADD_DATA_DEFINITION");
        DDMForm ddmForm = DataDefinitionDDMFormUtil.toDDMForm((DataDefinition)dataDefinition, (DDMFormFieldTypeServicesTracker)this._ddmFormFieldTypeServicesTracker);
        DataDefinitionContentType dataDefinitionContentType = this._dataDefinitionContentTypeTracker.getDataDefinitionContentType(contentType);
        ddmForm.setAllowInvalidAvailableLocalesForProperty(dataDefinitionContentType.allowInvalidAvailableLocalesForProperty());
        ddmForm.setDefinitionSchemaVersion("2.0");
        this._validate(dataDefinition, dataDefinitionContentType, ddmForm);
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._ddmFormSerializer.serialize(builder.build());
        final DDMStructure ddmStructure = this._ddmStructureLocalService.addStructure(PrincipalThreadLocal.getUserId(), siteId.longValue(), 0L, this._dataDefinitionContentTypeTracker.getClassNameId(contentType).longValue(), dataDefinition.getDataDefinitionKey(), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getDescription()), ddmFormSerializerSerializeResponse.getContent(), GetterUtil.getString((String)dataDefinition.getStorageType(), (String)StorageType.DEFAULT.getValue()), new ServiceContext());
        DataLayout dataLayout = dataDefinition.getDefaultDataLayout();
        if (dataLayout != null) {
            dataLayout.setDataLayoutKey(ddmStructure.getStructureKey());
            if (Validator.isNull((Object)dataLayout.getName())) {
                dataLayout.setName(dataDefinition.getName());
            }
            DataLayoutResource dataLayoutResource = this._getDataLayoutResource(false);
            try {
                dataDefinition.setDefaultDataLayout(dataLayoutResource.postDataDefinitionDataLayout(Long.valueOf(ddmStructure.getStructureId()), dataLayout));
            }
            catch (Exception exception) {
                this._ddmStructureLocalService.deleteStructure(ddmStructure);
                throw exception;
            }
        }
        this._addDataDefinitionFieldLinks(ddmStructure.getStructureId(), ddmForm.getDDMFormFields(), ddmStructure.getGroupId());
        dataDefinition = DataDefinitionUtil.toDataDefinition(this._dataDefinitionContentTypeTracker, this._ddmFormFieldTypeServicesTracker, ddmStructure, this._ddmStructureLayoutLocalService, this._spiDDMFormRuleConverter);
        this._resourceLocalService.addResources(this.contextCompany.getCompanyId(), siteId.longValue(), PrincipalThreadLocal.getUserId(), ResourceActionsUtil.getCompositeModelName((String[])new String[]{this._portal.getClassName(this._dataDefinitionContentTypeTracker.getClassNameId(contentType).longValue()), DDMStructure.class.getName()}), dataDefinition.getId().longValue(), false, false, false);
        DataRecordCollectionResource dataRecordCollectionResource = this._getDataRecordCollectionResource(false);
        dataRecordCollectionResource.postDataDefinitionDataRecordCollection(dataDefinition.getId(), new DataRecordCollection(){
            {
                this.setDataDefinitionId(ddmStructure.getStructureId());
                this.setDataRecordCollectionKey(ddmStructure.getStructureKey());
                this.setDescription(LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getDescriptionMap()));
                this.setName(LocalizedValueUtil.toStringObjectMap((Map)ddmStructure.getNameMap()));
            }
        });
        return dataDefinition;
    }

    @Override
    public DataDefinition putDataDefinition(Long dataDefinitionId, DataDefinition dataDefinition) throws Exception {
        this._dataDefinitionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataDefinitionId, "UPDATE");
        DataLayout dataLayout = dataDefinition.getDefaultDataLayout();
        if (dataLayout != null) {
            DataLayoutResource dataLayoutResource = this._getDataLayoutResource(false);
            dataDefinition.setDefaultDataLayout(dataLayoutResource.putDataLayout(Optional.ofNullable(dataLayout.getId()).orElseGet(() -> this._getDefaultDataLayoutId(dataDefinitionId)), dataLayout));
        }
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(dataDefinitionId.longValue());
        JSONObject definitionJSONObject = this._jsonFactory.createJSONObject(ddmStructure.getDefinition());
        DDMForm ddmForm = DataDefinitionDDMFormUtil.toDDMForm((DataDefinition)dataDefinition, (DDMFormFieldTypeServicesTracker)this._ddmFormFieldTypeServicesTracker);
        DataDefinitionContentType dataDefinitionContentType = this._dataDefinitionContentTypeTracker.getDataDefinitionContentType(ddmStructure.getClassNameId());
        ddmForm.setAllowInvalidAvailableLocalesForProperty(dataDefinitionContentType.allowInvalidAvailableLocalesForProperty());
        ddmForm.setDefinitionSchemaVersion(definitionJSONObject.getString("definitionSchemaVersion"));
        this._validate(dataDefinition, dataDefinitionContentType, ddmForm);
        List deDataDefinitionFieldLinks = this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructure.class), dataDefinitionId.longValue());
        for (DEDataDefinitionFieldLink deDataDefinitionFieldLink : deDataDefinitionFieldLinks) {
            DataDefinition existingDataDefinition = DataDefinitionUtil.toDataDefinition(this._dataDefinitionContentTypeTracker, this._ddmFormFieldTypeServicesTracker, this._ddmStructureLocalService.getStructure(deDataDefinitionFieldLink.getClassPK()), this._ddmStructureLayoutLocalService, this._spiDDMFormRuleConverter);
            for (DataDefinitionField dataDefinitionField : existingDataDefinition.getDataDefinitionFields()) {
                long ddmStructureId = MapUtil.getLong((Map)dataDefinitionField.getCustomProperties(), (String)"ddmStructureId");
                if (ddmStructureId != dataDefinitionId) continue;
                Map customProperties = dataDefinitionField.getCustomProperties();
                DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(Optional.ofNullable(dataLayout.getId()).orElseGet(() -> this._getDefaultDataLayoutId(dataDefinitionId)).longValue());
                JSONArray jsonArray = JSONUtil.getValueAsJSONArray((Object)this._jsonFactory.createJSONObject(StringUtil.replace((String)ddmStructureLayout.getDefinition(), (String[])new String[]{"fieldNames"}, (String[])new String[]{"fields"})), (String[])new String[]{"JSONArray/pages", "Object/0", "JSONArray/rows"});
                customProperties.put("rows", jsonArray.toString());
                Object[] nestedDataDefinitionFields = new DataDefinitionField[]{};
                for (DataDefinitionField dataDefinitionField1 : dataDefinition.getDataDefinitionFields()) {
                    Gson gson = new Gson();
                    nestedDataDefinitionFields = (DataDefinitionField[])ArrayUtil.append((Object[])nestedDataDefinitionFields, (Object)gson.fromJson(JSONFactoryUtil.looseSerializeDeep((Object)dataDefinitionField1), DataDefinitionField.class));
                }
                dataDefinitionField.setNestedDataDefinitionFields((DataDefinitionField[])nestedDataDefinitionFields);
            }
            this.putDataDefinition(existingDataDefinition.getId(), existingDataDefinition);
        }
        this._removeFieldsFromDataLayoutsAndDataListViews(dataDefinitionId, this._getRemovedFieldNames(dataDefinition, dataDefinitionId));
        this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructure.class), dataDefinitionId.longValue());
        this._addDataDefinitionFieldLinks(dataDefinitionId, ddmForm.getDDMFormFields(), Optional.ofNullable(dataDefinition.getSiteId()).orElse(this.getPermissionCheckerGroupId(dataDefinitionId)));
        return this._updateDataDefinition(dataDefinition, dataDefinitionId, ddmForm);
    }

    @Override
    protected Long getPermissionCheckerGroupId(Object id) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(((Long)id).longValue());
        return ddmStructure.getGroupId();
    }

    @Override
    protected String getPermissionCheckerResourceName(Object id) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(((Long)id).longValue());
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{this._portal.getClassName(ddmStructure.getClassNameId()), DDMStructure.class.getName()});
    }

    private void _addDataDefinitionFieldLinks(long dataDefinitionId, List<DDMFormField> ddmFormFields, long groupId) throws Exception {
        for (DDMFormField ddmFormField : ddmFormFields) {
            long fieldSetDDMStructureId = GetterUtil.getLong((Object)ddmFormField.getProperty("ddmStructureId"));
            if (fieldSetDDMStructureId == 0L) continue;
            this._deDataDefinitionFieldLinkLocalService.addDEDataDefinitionFieldLink(groupId, this._portal.getClassNameId(DDMStructure.class), dataDefinitionId, fieldSetDDMStructureId, ddmFormField.getName());
            this._addDataDefinitionFieldLinks(dataDefinitionId, ddmFormField.getNestedDDMFormFields(), groupId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject _createFieldContextJSONObject(DDMFormFieldType ddmFormFieldType, Locale locale, String type) {
        Locale originalThemeDisplayLocale = LocaleThreadLocal.getThemeDisplayLocale();
        LocaleThreadLocal.setThemeDisplayLocale((Locale)locale);
        try {
            DDMForm ddmFormFieldTypeSettingsDDMForm = DDMFormFactory.create((Class)ddmFormFieldType.getDDMFormFieldTypeSettings());
            Set<Locale> availableLocales = null;
            DDMForm ddmForm = this._getDDMForm();
            availableLocales = ddmForm != null ? ddmForm.getAvailableLocales() : Collections.singleton(Optional.ofNullable(LocaleThreadLocal.getSiteDefaultLocale()).orElse(LocaleThreadLocal.getDefaultLocale()));
            ddmFormFieldTypeSettingsDDMForm.setAvailableLocales(availableLocales);
            ddmFormFieldTypeSettingsDDMForm.setDefaultLocale(this._getDefaultLocale());
            DDMFormRenderingContext ddmFormRenderingContext = new DDMFormRenderingContext();
            ddmFormRenderingContext.setContainerId("settings");
            DDMFormValues ddmFormValues = this._ddmFormValuesFactory.create(this.contextHttpServletRequest, ddmFormFieldTypeSettingsDDMForm);
            this._setTypeDDMFormFieldValue(ddmFormValues, type);
            ddmFormRenderingContext.setDDMFormValues(ddmFormValues);
            ddmFormRenderingContext.setHttpServletRequest(this.contextHttpServletRequest);
            ddmFormRenderingContext.setLocale(this._getDefaultLocale());
            ddmFormRenderingContext.setPortletNamespace(this._portal.getPortletNamespace(this._portal.getPortletId(this.contextHttpServletRequest)));
            ddmFormRenderingContext.setReturnFullContext(true);
            JSONObject jSONObject = JSONFactoryUtil.createJSONObject((String)JSONFactoryUtil.looseSerializeDeep((Object)this._ddmFormTemplateContextFactory.create(ddmFormFieldTypeSettingsDDMForm, DDMFormLayoutFactory.create((Class)ddmFormFieldType.getDDMFormFieldTypeSettings()), ddmFormRenderingContext)));
            return jSONObject;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
        }
        finally {
            LocaleThreadLocal.setThemeDisplayLocale((Locale)originalThemeDisplayLocale);
        }
        return null;
    }

    private DataLayoutResource _getDataLayoutResource(boolean checkPermission) {
        DataLayoutResource.Builder dataLayoutResourceBuilder = this._dataLayoutResourceFactory.create();
        return dataLayoutResourceBuilder.checkPermissions(checkPermission).user(this.contextUser).build();
    }

    private DataRecordCollectionResource _getDataRecordCollectionResource(boolean checkPermission) {
        DataRecordCollectionResource.Builder dataRecordCollectionResourceBuilder = this._dataRecordCollectionResourceFactory.create();
        return dataRecordCollectionResourceBuilder.checkPermissions(checkPermission).user(this.contextUser).build();
    }

    private DDMForm _getDDMForm() {
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchDDMStructure(ParamUtil.getLong((HttpServletRequest)this.contextHttpServletRequest, (String)"ddmStructureId"));
        if (ddmStructure == null) {
            return null;
        }
        return ddmStructure.getDDMForm();
    }

    private long _getDefaultDataLayoutId(long dataDefinitionId) {
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchDDMStructure(dataDefinitionId);
        if (ddmStructure == null) {
            return 0L;
        }
        return ddmStructure.getDefaultDDMStructureLayoutId();
    }

    private Locale _getDefaultLocale() {
        DDMForm ddmForm = this._getDDMForm();
        if (ddmForm != null) {
            return ddmForm.getDefaultLocale();
        }
        String i18nLanguageId = (String)this.contextHttpServletRequest.getAttribute("I18N_LANGUAGE_ID");
        if (Validator.isNotNull((String)i18nLanguageId)) {
            return LocaleUtil.fromLanguageId((String)i18nLanguageId);
        }
        return Optional.ofNullable(LocaleThreadLocal.getSiteDefaultLocale()).orElse(LocaleThreadLocal.getDefaultLocale());
    }

    private JSONObject _getFieldTypeMetadataJSONObject(String ddmFormFieldName, ResourceBundle resourceBundle) {
        Map ddmFormFieldTypeProperties = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldTypeProperties(ddmFormFieldName);
        DDMFormFieldType ddmFormFieldType = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldType(ddmFormFieldName);
        JSONObject jsonObject = JSONUtil.put((String)"description", (Object)this._translate(MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.description"), resourceBundle)).put("displayOrder", MapUtil.getInteger((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.display.order", (int)Integer.MAX_VALUE)).put("group", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.group")).put("icon", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.icon")).put("javaScriptModule", this._resolveModuleName(ddmFormFieldType)).put("label", this._translate(MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.label"), resourceBundle)).put("name", ddmFormFieldName).put("scope", MapUtil.getString((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.scope")).put("settingsContext", this._createFieldContextJSONObject(ddmFormFieldType, this.contextAcceptLanguage.getPreferredLocale(), ddmFormFieldName)).put("system", MapUtil.getBoolean((Map)ddmFormFieldTypeProperties, (String)"ddm.form.field.type.system"));
        ThemeDisplay themeDisplay = this._getThemeDisplay();
        if (themeDisplay != null && StringUtil.equals((String)ddmFormFieldType.getName(), (String)"rich_text")) {
            EditorConfiguration editorConfiguration = this._editorConfigurationFactory.getEditorConfiguration("", ddmFormFieldType.getName(), "ckeditor_classic", new HashMap(), themeDisplay, RequestBackedPortletURLFactoryUtil.create((HttpServletRequest)this.contextHttpServletRequest));
            Map data = editorConfiguration.getData();
            jsonObject.put("editorConfig", data.get("editorConfig"));
        }
        return jsonObject;
    }

    private String[] _getRemovedFieldNames(DataDefinition dataDefinition, long dataDefinitionId) throws Exception {
        ArrayList removedFieldNames = new ArrayList();
        DDMForm ddmForm = DataDefinitionDDMFormUtil.toDDMForm((DataDefinition)dataDefinition, (DDMFormFieldTypeServicesTracker)this._ddmFormFieldTypeServicesTracker);
        Map ddmFormFieldsMap = ddmForm.getDDMFormFieldsMap(true);
        Object[] fieldNames = ArrayUtil.toStringArray(ddmFormFieldsMap.keySet());
        DataDefinition existingDataDefinition = DataDefinitionUtil.toDataDefinition(this._dataDefinitionContentTypeTracker, this._ddmFormFieldTypeServicesTracker, this._ddmStructureLocalService.getStructure(dataDefinitionId), this._ddmStructureLayoutLocalService, this._spiDDMFormRuleConverter);
        DDMForm existingDDMForm = DataDefinitionDDMFormUtil.toDDMForm((DataDefinition)existingDataDefinition, (DDMFormFieldTypeServicesTracker)this._ddmFormFieldTypeServicesTracker);
        Map existingDDMFormFieldsMap = existingDDMForm.getDDMFormFieldsMap(true);
        for (Map.Entry entry : existingDDMFormFieldsMap.entrySet()) {
            long ddmStructureId;
            DDMStructure fieldSetDDMStructure;
            if (ArrayUtil.contains((Object[])fieldNames, entry.getKey())) continue;
            removedFieldNames.add(entry.getKey());
            DDMFormField ddmFormField = (DDMFormField)entry.getValue();
            if (!Objects.equals(ddmFormField.getType(), "fieldset") || (fieldSetDDMStructure = this._ddmStructureLocalService.fetchDDMStructure(ddmStructureId = MapUtil.getLong((Map)ddmFormField.getProperties(), (String)"ddmStructureId"))) == null) continue;
            Map map = fieldSetDDMStructure.getFullHierarchyDDMFormFieldsMap(false);
            removedFieldNames.addAll(map.keySet());
        }
        return removedFieldNames.toArray(new String[0]);
    }

    private ResourceBundle _getResourceBundle(String ddmFormFieldTypeName, Locale locale) {
        DDMFormFieldType ddmFormFieldType = this._ddmFormFieldTypeServicesTracker.getDDMFormFieldType(ddmFormFieldTypeName);
        return new AggregateResourceBundle(new ResourceBundle[]{ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, this.getClass()), ResourceBundleUtil.getBundle((String)"content.Language", (Locale)locale, ddmFormFieldType.getClass()), this._portal.getResourceBundle(locale)});
    }

    private ThemeDisplay _getThemeDisplay() {
        if (this.contextHttpServletRequest == null) {
            return null;
        }
        return (ThemeDisplay)this.contextHttpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    private void _removeFieldsFromDataLayout(DataLayout dataLayout, String[] fieldNames) {
        Map dataLayoutFields = dataLayout.getDataLayoutFields();
        Set dataLayoutFieldNames = dataLayoutFields.keySet();
        dataLayoutFieldNames.removeIf(dataLayoutFieldName -> ArrayUtil.contains((Object[])fieldNames, (Object)dataLayoutFieldName));
        Stream<DataLayoutPage> dataLayoutPages = Arrays.stream(dataLayout.getDataLayoutPages());
        dataLayoutPages.forEach(dataLayoutPage -> {
            Stream<DataLayoutRow> dataLayoutRows = Arrays.stream(dataLayoutPage.getDataLayoutRows());
            dataLayoutRows.forEach(dataLayoutRow -> {
                Stream<DataLayoutColumn> dataLayoutColumns = Arrays.stream(dataLayoutRow.getDataLayoutColumns());
                dataLayoutColumns.forEach(dataLayoutColumn -> dataLayoutColumn.setFieldNames((String[])ArrayUtil.filter((Object[])dataLayoutColumn.getFieldNames(), fieldName -> !ArrayUtil.contains((Object[])fieldNames, (Object)fieldName))));
                dataLayoutRow.setDataLayoutColumns((DataLayoutColumn[])ArrayUtil.filter((Object[])dataLayoutRow.getDataLayoutColumns(), column -> !ArrayUtil.isEmpty((Object[])column.getFieldNames()) || column.getColumnSize() != 12));
            });
            dataLayoutPage.setDataLayoutRows((DataLayoutRow[])ArrayUtil.filter((Object[])dataLayoutPage.getDataLayoutRows(), row -> !ArrayUtil.isEmpty((Object[])row.getDataLayoutColumns())));
        });
    }

    private void _removeFieldsFromDataLayouts(Set<Long> ddmStructureLayoutIds, String[] fieldNames) throws Exception {
        for (Long ddmStructureLayoutId : ddmStructureLayoutIds) {
            DDMStructureLayout ddmStructureLayout = this._ddmStructureLayoutLocalService.getStructureLayout(ddmStructureLayoutId.longValue());
            DataLayout dataLayout = DataLayoutUtil.toDataLayout(this._ddmFormFieldTypeServicesTracker, ddmStructureLayout.getDDMFormLayout(), this._spiDDMFormRuleConverter);
            this._removeFieldsFromDataLayout(dataLayout, fieldNames);
            DDMStructure ddmStructure = ddmStructureLayout.getDDMStructure();
            DDMFormLayout ddmFormLayout = ddmStructureLayout.getDDMFormLayout();
            String definitionSchemaVersion = ddmFormLayout.getDefinitionSchemaVersion();
            ddmFormLayout = DataLayoutUtil.toDDMFormLayout(dataLayout, ddmStructure.getDDMForm(), this._ddmFormFieldTypeServicesTracker, this._ddmFormRuleDeserializer);
            ddmFormLayout.setDefinitionSchemaVersion(definitionSchemaVersion);
            DDMFormLayoutSerializerSerializeRequest.Builder builder = DDMFormLayoutSerializerSerializeRequest.Builder.newBuilder((DDMFormLayout)ddmFormLayout);
            DDMFormLayoutSerializerSerializeResponse ddmFormLayoutSerializerSerializeResponse = this._ddmFormLayoutSerializer.serialize(builder.build());
            ddmStructureLayout.setDefinition(ddmFormLayoutSerializerSerializeResponse.getContent());
            this._ddmStructureLayoutLocalService.updateDDMStructureLayout(ddmStructureLayout);
        }
    }

    private void _removeFieldsFromDataLayoutsAndDataListViews(long dataDefinitionId, String[] fieldNames) throws Exception {
        HashSet<Long> ddmStructureLayoutIds = new HashSet<Long>();
        HashSet<Long> deDataListViewIds = new HashSet<Long>();
        ddmStructureLayoutIds.addAll(this.transform(this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructureLayout.class), dataDefinitionId, fieldNames), DEDataDefinitionFieldLinkModel::getClassPK));
        deDataListViewIds.addAll(this.transform(this._deDataDefinitionFieldLinkLocalService.getDEDataDefinitionFieldLinks(this._portal.getClassNameId(DEDataListView.class), dataDefinitionId, fieldNames), DEDataDefinitionFieldLinkModel::getClassPK));
        this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DDMStructureLayout.class), dataDefinitionId, fieldNames);
        this._deDataDefinitionFieldLinkLocalService.deleteDEDataDefinitionFieldLinks(this._portal.getClassNameId(DEDataListView.class), dataDefinitionId, fieldNames);
        this._removeFieldsFromDataLayouts(ddmStructureLayoutIds, fieldNames);
        this._removeFieldsFromDataListViews(deDataListViewIds, fieldNames);
    }

    private void _removeFieldsFromDataListViews(Set<Long> deDataListViewIds, String[] removedFieldNames) throws Exception {
        DataListViewResource.Builder dataListViewResourceBuilder = this._dataListViewResourceFactory.create();
        DataListViewResource dataListViewResource = dataListViewResourceBuilder.checkPermissions(false).user(this.contextUser).build();
        for (Long deDataListViewId : deDataListViewIds) {
            DataListView dataListView = dataListViewResource.getDataListView(deDataListViewId);
            dataListView.setFieldNames((String[])ArrayUtil.filter((Object[])JSONUtil.toStringArray((JSONArray)this._jsonFactory.createJSONArray((Object[])dataListView.getFieldNames())), fieldName -> !ArrayUtil.contains((Object[])removedFieldNames, (Object)fieldName)));
            dataListViewResource.putDataListView(dataListView.getId(), dataListView);
        }
    }

    private String _resolveModuleName(DDMFormFieldType ddmFormFieldType) {
        if (Validator.isNull((String)ddmFormFieldType.getModuleName())) {
            return "";
        }
        if (ddmFormFieldType.isCustomDDMFormFieldType()) {
            return ddmFormFieldType.getModuleName();
        }
        return this._npmResolver.resolveModuleName(ddmFormFieldType.getModuleName());
    }

    private void _setTypeDDMFormFieldValue(DDMFormValues ddmFormValues, String type) {
        Map ddmFormFieldValuesMap = ddmFormValues.getDDMFormFieldValuesMap();
        List ddmFormFieldValues = (List)ddmFormFieldValuesMap.get("type");
        DDMFormFieldValue ddmFormFieldValue = (DDMFormFieldValue)ddmFormFieldValues.get(0);
        ddmFormFieldValue.setValue((Value)new UnlocalizedValue(type));
    }

    private DataDefinition _toDataDefinition(DDMStructure ddmStructure) throws Exception {
        return DataDefinitionUtil.toDataDefinition(this._dataDefinitionContentTypeTracker, this._ddmFormFieldTypeServicesTracker, ddmStructure, this._ddmStructureLayoutLocalService, this._spiDDMFormRuleConverter);
    }

    private DataDefinitionValidationException _toDataDefinitionValidationException(DDMFormValidationException ddmFormValidationException) {
        if (ddmFormValidationException instanceof DDMFormValidationException.MustNotDuplicateFieldName) {
            DDMFormValidationException.MustNotDuplicateFieldName mustNotDuplicateFieldName = (DDMFormValidationException.MustNotDuplicateFieldName)ddmFormValidationException;
            return new DataDefinitionValidationException.MustNotDuplicateFieldName(mustNotDuplicateFieldName.getDuplicatedFieldNames());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetAvailableLocales) {
            return new DataDefinitionValidationException.MustSetAvailableLocales();
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetDefaultLocale) {
            return new DataDefinitionValidationException.MustSetDefaultLocale();
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetDefaultLocaleAsAvailableLocale) {
            DDMFormValidationException.MustSetDefaultLocaleAsAvailableLocale mustSetDefaultLocaleAsAvailableLocale = (DDMFormValidationException.MustSetDefaultLocaleAsAvailableLocale)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetDefaultLocaleAsAvailableLocale(mustSetDefaultLocaleAsAvailableLocale.getDefaultLocale());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetFieldsForForm) {
            return new DataDefinitionValidationException.MustSetFields();
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetFieldType) {
            DDMFormValidationException.MustSetFieldType mustSetFieldType = (DDMFormValidationException.MustSetFieldType)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetFieldType(mustSetFieldType.getFieldName());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetOptionsForField) {
            DDMFormValidationException.MustSetOptionsForField mustSetOptionsForField = (DDMFormValidationException.MustSetOptionsForField)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetOptionsForField(mustSetOptionsForField.getFieldLabel(), mustSetOptionsForField.getFieldName());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidAvailableLocalesForProperty) {
            DDMFormValidationException.MustSetValidAvailableLocalesForProperty mustSetValidAvailableLocalesForProperty = (DDMFormValidationException.MustSetValidAvailableLocalesForProperty)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidAvailableLocalesForProperty(mustSetValidAvailableLocalesForProperty.getFieldName(), mustSetValidAvailableLocalesForProperty.getProperty());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidCharactersForFieldName) {
            DDMFormValidationException.MustSetValidCharactersForFieldName mustSetValidCharactersForFieldName = (DDMFormValidationException.MustSetValidCharactersForFieldName)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidCharactersForFieldName(mustSetValidCharactersForFieldName.getFieldName());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidCharactersForFieldType) {
            DDMFormValidationException.MustSetValidCharactersForFieldType mustSetValidCharactersForFieldType = (DDMFormValidationException.MustSetValidCharactersForFieldType)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidCharactersForFieldType(mustSetValidCharactersForFieldType.getFieldType());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidDefaultLocaleForProperty) {
            DDMFormValidationException.MustSetValidDefaultLocaleForProperty mustSetValidDefaultLocaleForProperty = (DDMFormValidationException.MustSetValidDefaultLocaleForProperty)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidDefaultLocaleForProperty(mustSetValidDefaultLocaleForProperty.getFieldName(), mustSetValidDefaultLocaleForProperty.getProperty());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidFormRuleExpression) {
            DDMFormValidationException.MustSetValidFormRuleExpression mustSetValidFormRuleExpression = (DDMFormValidationException.MustSetValidFormRuleExpression)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidRuleExpression(mustSetValidFormRuleExpression.getExpression(), mustSetValidFormRuleExpression.getMessage());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidIndexType) {
            DDMFormValidationException.MustSetValidIndexType mustSetValidIndexType = (DDMFormValidationException.MustSetValidIndexType)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidIndexType(mustSetValidIndexType.getFieldName());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidType) {
            DDMFormValidationException.MustSetValidType mustSetValidType = (DDMFormValidationException.MustSetValidType)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidType(mustSetValidType.getFieldType());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidValidationExpression) {
            DDMFormValidationException.MustSetValidValidationExpression mustSetValidValidationExpression = (DDMFormValidationException.MustSetValidValidationExpression)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidValidationExpression(mustSetValidValidationExpression.getFieldName(), mustSetValidValidationExpression.getExpression());
        }
        if (ddmFormValidationException instanceof DDMFormValidationException.MustSetValidVisibilityExpression) {
            DDMFormValidationException.MustSetValidVisibilityExpression mustSetValidVisibilityExpression = (DDMFormValidationException.MustSetValidVisibilityExpression)ddmFormValidationException;
            return new DataDefinitionValidationException.MustSetValidVisibilityExpression(mustSetValidVisibilityExpression.getFieldName(), mustSetValidVisibilityExpression.getExpression());
        }
        return new DataDefinitionValidationException(ddmFormValidationException.getCause());
    }

    private OrderByComparator<DDMStructure> _toOrderByComparator(Sort sort) {
        boolean ascending = !sort.isReverse();
        String sortFieldName = sort.getFieldName();
        if (StringUtil.startsWith((String)sortFieldName, (String)"createDate")) {
            return new StructureCreateDateComparator(ascending);
        }
        if (StringUtil.startsWith((String)sortFieldName, (String)"localized_name")) {
            return new StructureNameComparator(ascending);
        }
        return new StructureModifiedDateComparator(ascending);
    }

    private String _translate(String key, ResourceBundle resourceBundle) {
        if (Validator.isNull((String)key)) {
            return "";
        }
        return GetterUtil.getString((String)ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)key), (String)key);
    }

    private DataDefinition _updateDataDefinition(DataDefinition dataDefinition, Long dataDefinitionId, DDMForm ddmForm) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(dataDefinitionId.longValue());
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._ddmFormSerializer.serialize(builder.build());
        return DataDefinitionUtil.toDataDefinition(this._dataDefinitionContentTypeTracker, this._ddmFormFieldTypeServicesTracker, this._ddmStructureLocalService.updateStructure(PrincipalThreadLocal.getUserId(), dataDefinitionId.longValue(), GetterUtil.getLong((Object)ddmStructure.getParentStructureId(), (long)0L), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getName()), LocalizedValueUtil.toLocaleStringMap((Map)dataDefinition.getDescription()), ddmFormSerializerSerializeResponse.getContent(), new ServiceContext()), this._ddmStructureLayoutLocalService, this._spiDDMFormRuleConverter);
    }

    private void _validate(DataDefinition dataDefinition, DataDefinitionContentType dataDefinitionContentType, DDMForm ddmForm) {
        try {
            Map name = dataDefinition.getName();
            Locale defaultLocale = ddmForm.getDefaultLocale();
            if (name == null || Validator.isNull(name.get(LocaleUtil.toLanguageId((Locale)defaultLocale)))) {
                throw new DataDefinitionValidationException.MustSetValidName("Name is null for locale " + defaultLocale.getDisplayName());
            }
            this._ddmFormValidator.validate(ddmForm);
        }
        catch (DDMFormValidationException ddmFormValidationException) {
            if (ddmFormValidationException instanceof DDMFormValidationException.MustSetFieldsForForm && dataDefinitionContentType.allowEmptyDataDefinition()) {
                return;
            }
            throw this._toDataDefinitionValidationException(ddmFormValidationException);
        }
        catch (DataDefinitionValidationException dataDefinitionValidationException) {
            throw dataDefinitionValidationException;
        }
        catch (Exception exception) {
            throw new DataDefinitionValidationException((Throwable)exception);
        }
    }
}

