/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.resource.v2_0;

import com.liferay.data.engine.model.DEDataListView;
import com.liferay.data.engine.rest.dto.v2_0.DataRecord;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeTracker;
import com.liferay.data.engine.rest.internal.odata.entity.v2_0.DataRecordEntityModel;
import com.liferay.data.engine.rest.internal.resource.v2_0.BaseDataRecordResourceImpl;
import com.liferay.data.engine.rest.internal.security.permission.resource.DataRecordCollectionModelResourcePermission;
import com.liferay.data.engine.rest.internal.security.permission.resource.DataRecordModelResourcePermission;
import com.liferay.data.engine.rest.internal.storage.DataRecordExporter;
import com.liferay.data.engine.rest.internal.storage.DataStorageTracker;
import com.liferay.data.engine.rest.resource.v2_0.DataRecordResource;
import com.liferay.data.engine.service.DEDataListViewLocalService;
import com.liferay.data.engine.storage.DataStorage;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.model.DDLRecordSetVersion;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeServicesTracker;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.DDMStructureVersion;
import com.liferay.dynamic.data.mapping.service.DDMStorageLinkLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLayoutLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.spi.converter.SPIDDMFormRuleConverter;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.odata.entity.EntityField;
import com.liferay.portal.odata.entity.EntityModel;
import com.liferay.portal.odata.entity.StringEntityField;
import com.liferay.portal.search.legacy.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.query.Queries;
import com.liferay.portal.search.sort.FieldSort;
import com.liferay.portal.search.sort.SortOrder;
import com.liferay.portal.search.sort.Sorts;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import com.liferay.portal.vulcan.util.SearchUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.validation.ValidationException;
import javax.ws.rs.core.MultivaluedMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ServiceScope;

@CTAware
@Component(properties={"OSGI-INF/liferay/rest/v2_0/data-record.properties"}, scope=ServiceScope.PROTOTYPE, service={DataRecordResource.class})
public class DataRecordResourceImpl
extends BaseDataRecordResourceImpl {
    @Reference
    private DataDefinitionContentTypeTracker _dataDefinitionContentTypeTracker;
    @Reference
    private DataRecordCollectionModelResourcePermission _dataRecordCollectionModelResourcePermission;
    @Reference
    private DataRecordModelResourcePermission _dataRecordModelResourcePermission;
    @Reference
    private DataStorageTracker _dataStorageTracker;
    @Reference
    private DDLRecordLocalService _ddlRecordLocalService;
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMFormFieldTypeServicesTracker _ddmFormFieldTypeServicesTracker;
    @Reference
    private DDMIndexer _ddmIndexer;
    @Reference
    private DDMStorageLinkLocalService _ddmStorageLinkLocalService;
    @Reference
    private DDMStructureLayoutLocalService _ddmStructureLayoutLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DEDataListViewLocalService _deDataListViewLocalService;
    @Reference
    private Language _language;
    @Reference
    private Portal _portal;
    @Reference
    private Queries _queries;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;
    @Reference
    private Sorts _sorts;
    @Reference
    private SPIDDMFormRuleConverter _spiDDMFormRuleConverter;

    @Override
    public void deleteDataRecord(Long dataRecordId) throws Exception {
        this._dataRecordModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordId, "DELETE_DATA_RECORD");
        DDLRecord ddlRecord = this._ddlRecordLocalService.getDDLRecord(dataRecordId.longValue());
        DDLRecordSet ddlRecordSet = ddlRecord.getRecordSet();
        DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
        DataStorage dataStorage = this._getDataStorage(ddmStructure.getStorageType());
        dataStorage.delete(ddlRecord.getDDMStorageId());
        this._ddmStorageLinkLocalService.deleteClassStorageLink(ddlRecord.getDDMStorageId());
        this._ddlRecordLocalService.deleteDDLRecord(dataRecordId.longValue());
    }

    @Override
    public Page<DataRecord> getDataDefinitionDataRecordsPage(Long dataDefinitionId, Long dataListViewId, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        return this.getDataRecordCollectionDataRecordsPage(this._getDefaultDataRecordCollectionId(dataDefinitionId), dataListViewId, keywords, pagination, sorts);
    }

    @Override
    public DataRecord getDataRecord(Long dataRecordId) throws Exception {
        this._dataRecordModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordId, "VIEW_DATA_RECORD");
        return this._toDataRecord(this._ddlRecordLocalService.getDDLRecord(dataRecordId.longValue()));
    }

    @Override
    public String getDataRecordCollectionDataRecordExport(Long dataRecordCollectionId, Pagination pagination) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new ValidationException(LanguageUtil.format((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        this._dataRecordCollectionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId, "EXPORT_DATA_RECORDS");
        DataRecordExporter dataRecordExporter = new DataRecordExporter(this._dataDefinitionContentTypeTracker, this._ddlRecordSetLocalService, this._ddmFormFieldTypeServicesTracker, this._ddmStructureLayoutLocalService, this._spiDDMFormRuleConverter);
        return dataRecordExporter.export(this.transform(this._ddlRecordLocalService.getRecords(dataRecordCollectionId.longValue(), pagination.getStartPosition(), pagination.getEndPosition(), null), this::_toDataRecord));
    }

    @Override
    public Page<DataRecord> getDataRecordCollectionDataRecordsPage(Long dataRecordCollectionId, Long dataListViewId, String keywords, Pagination pagination, Sort[] sorts) throws Exception {
        if (pagination.getPageSize() > 250) {
            throw new ValidationException(LanguageUtil.format((Locale)this.contextAcceptLanguage.getPreferredLocale(), (String)"page-size-is-greater-than-x", (Object)250));
        }
        this._dataRecordCollectionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId, "VIEW_DATA_RECORD");
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getDDLRecordSet(dataRecordCollectionId.longValue());
        return SearchUtil.search(Collections.emptyMap(), booleanQuery -> {
            if (Validator.isNull((String)keywords)) {
                return;
            }
            BooleanQueryImpl ddmContentBooleanQuery = new BooleanQueryImpl();
            for (Locale locale : this._language.getCompanyAvailableLocales(this.contextCompany.getCompanyId())) {
                ddmContentBooleanQuery.addTerm(Field.getLocalizedName((Locale)locale, (String)"ddmContent"), StringBundler.concat((String[])new String[]{"\"*", keywords, "*\""}));
            }
            BooleanFilter booleanFilter = booleanQuery.getPreBooleanFilter();
            booleanFilter.add((Filter)new QueryFilter((Query)ddmContentBooleanQuery), BooleanClauseOccur.MUST);
        }, (Filter)this._getBooleanFilter(dataListViewId, ddlRecordSet), (String)DDLRecord.class.getName(), null, (Pagination)pagination, queryConfig -> queryConfig.setSelectedFieldNames(new String[]{"entryClassPK"}), searchContext -> {
            if (sorts != null) {
                this._searchRequestBuilderFactory.builder((SearchContext)searchContext).sorts(this._getSearchSorts(ddlRecordSet.getDDMStructure(), sorts));
            }
            searchContext.setAttribute("status", (Serializable)Integer.valueOf(-1));
            searchContext.setAttribute("recordSetId", (Serializable)dataRecordCollectionId);
            searchContext.setAttribute("recordSetScope", (Serializable)Integer.valueOf(ddlRecordSet.getScope()));
            searchContext.setCompanyId(this.contextCompany.getCompanyId());
            searchContext.setUserId(0L);
        }, null, document -> this._toDataRecord(this._ddlRecordLocalService.fetchRecord(GetterUtil.getLong((String)document.get("entryClassPK")))));
    }

    @Override
    public EntityModel getEntityModel(MultivaluedMap multivaluedMap) throws PortalException {
        long dataRecordCollectionId;
        long dataDefinitionId = GetterUtil.getLong((String)((String)multivaluedMap.getFirst((Object)"dataDefinitionId")));
        if (dataDefinitionId <= 0L && (dataRecordCollectionId = GetterUtil.getLong((String)((String)multivaluedMap.getFirst((Object)"dataRecordCollectionId")))) > 0L) {
            DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getDDLRecordSet(dataRecordCollectionId);
            DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
            dataDefinitionId = ddmStructure.getStructureId();
        }
        ArrayList<EntityField> entityFields = new ArrayList<EntityField>();
        if (dataDefinitionId > 0L) {
            DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(dataDefinitionId);
            for (String fieldName : ddmStructure.getFieldNames()) {
                entityFields.add((EntityField)new StringEntityField(fieldName, locale -> fieldName));
            }
        }
        return new DataRecordEntityModel(entityFields);
    }

    @Override
    public DataRecord postDataDefinitionDataRecord(Long dataDefinitionId, DataRecord dataRecord) throws Exception {
        return this.postDataRecordCollectionDataRecord(this._getDefaultDataRecordCollectionId(dataDefinitionId), dataRecord);
    }

    @Override
    public DataRecord postDataRecordCollectionDataRecord(Long dataRecordCollectionId, DataRecord dataRecord) throws Exception {
        this._dataRecordCollectionModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordCollectionId, "ADD_DATA_RECORD");
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(dataRecordCollectionId.longValue());
        dataRecord.setDataRecordCollectionId(dataRecordCollectionId);
        DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
        DataStorage dataStorage = this._getDataStorage(ddmStructure.getStorageType());
        long ddmStorageId = dataStorage.save(ddlRecordSet.getRecordSetId(), dataRecord.getDataRecordValues(), ddlRecordSet.getGroupId());
        DDLRecordSetVersion ddlRecordSetVersion = ddlRecordSet.getRecordSetVersion();
        DDMStructureVersion ddmStructureVersion = ddlRecordSetVersion.getDDMStructureVersion();
        this._ddmStorageLinkLocalService.addStorageLink(this._portal.getClassNameId(DataRecord.class.getName()), ddmStorageId, ddmStructureVersion.getStructureVersionId(), new ServiceContext());
        return this._toDataRecord(this._ddlRecordLocalService.addRecord(PrincipalThreadLocal.getUserId(), ddlRecordSet.getGroupId(), ddmStorageId, dataRecord.getDataRecordCollectionId().longValue(), "", 0L, new ServiceContext()));
    }

    @Override
    public DataRecord putDataRecord(Long dataRecordId, DataRecord dataRecord) throws Exception {
        this._dataRecordModelResourcePermission.check(PermissionThreadLocal.getPermissionChecker(), dataRecordId, "UPDATE_DATA_RECORD");
        final DDLRecord ddlRecord = this._ddlRecordLocalService.getRecord(dataRecordId.longValue());
        DDLRecordSet ddlRecordSet = ddlRecord.getRecordSet();
        dataRecord.setDataRecordCollectionId(Long.valueOf(ddlRecordSet.getRecordSetId()));
        dataRecord.setId(dataRecordId);
        DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
        DataStorage dataStorage = this._getDataStorage(ddmStructure.getStorageType());
        long ddmStorageId = dataStorage.save(ddlRecordSet.getRecordSetId(), dataRecord.getDataRecordValues(), ddlRecord.getGroupId());
        DDLRecordSetVersion ddlRecordSetVersion = ddlRecordSet.getRecordSetVersion();
        DDMStructureVersion ddmStructureVersion = ddlRecordSetVersion.getDDMStructureVersion();
        this._ddmStorageLinkLocalService.addStorageLink(this._portal.getClassNameId(DataRecord.class.getName()), ddmStorageId, ddmStructureVersion.getStructureVersionId(), new ServiceContext());
        this._ddlRecordLocalService.updateRecord(PrincipalThreadLocal.getUserId(), dataRecordId.longValue(), ddmStorageId, new ServiceContext(){
            {
                this.setAttribute("status", Integer.valueOf(ddlRecord.getStatus()));
            }
        });
        return dataRecord;
    }

    @Override
    protected void preparePatch(DataRecord dataRecord, DataRecord existingDataRecord) {
        if (dataRecord.getDataRecordValues() != null) {
            existingDataRecord.setDataRecordValues(() -> {
                DataRecord getDataRecord = this.getDataRecord(existingDataRecord.getId());
                Map dataRecordValues = getDataRecord.getDataRecordValues();
                dataRecordValues.putAll(dataRecord.getDataRecordValues());
                return dataRecordValues;
            });
        }
    }

    private BooleanFilter _getBooleanFilter(Long dataListViewId, DDLRecordSet ddlRecordSet) throws Exception {
        String[] fieldNames;
        BooleanFilter booleanFilter = new BooleanFilter();
        if (Validator.isNull((Long)dataListViewId)) {
            return booleanFilter;
        }
        DEDataListView deDataListView = this._deDataListViewLocalService.getDEDataListView(dataListViewId.longValue());
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)deDataListView.getAppliedFilters());
        for (String fieldName : fieldNames = JSONUtil.toStringArray((JSONArray)JSONFactoryUtil.createJSONArray((String)deDataListView.getFieldNames()))) {
            JSONArray jsonArray = (JSONArray)jsonObject.get(fieldName);
            if (jsonArray == null) continue;
            BooleanFilter fieldBooleanFilter = new BooleanFilter();
            for (String value : JSONUtil.toStringArray((JSONArray)jsonArray)) {
                DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
                String fieldType = ddmStructure.getFieldType(fieldName);
                if (fieldType.equals("select")) {
                    value = StringBundler.concat((String[])new String[]{"[", value, "]"});
                }
                fieldBooleanFilter.add((Filter)this._ddmIndexer.createFieldValueQueryFilter(ddmStructure, ddmStructure.getFieldProperty(fieldName, "fieldReference"), this.contextAcceptLanguage.getPreferredLocale(), (Serializable)((Object)value)), BooleanClauseOccur.SHOULD);
            }
            booleanFilter.add((Filter)fieldBooleanFilter, BooleanClauseOccur.MUST);
        }
        return booleanFilter;
    }

    private DataStorage _getDataStorage(String dataStorageType) {
        if (Validator.isNull((String)dataStorageType)) {
            throw new ValidationException("Data storage type is null");
        }
        DataStorage dataStorage = this._dataStorageTracker.getDataStorage(dataStorageType);
        if (dataStorage == null) {
            throw new ValidationException("Unsupported data storage type: " + dataStorageType);
        }
        return dataStorage;
    }

    private long _getDefaultDataRecordCollectionId(Long dataDefinitionId) throws Exception {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId.longValue());
        DDLRecordSet ddlRecordSet = this._ddlRecordSetLocalService.getRecordSet(ddmStructure.getGroupId(), ddmStructure.getStructureKey());
        return ddlRecordSet.getRecordSetId();
    }

    private com.liferay.portal.search.sort.Sort[] _getSearchSorts(DDMStructure ddmStructure, Sort[] sorts) throws PortalException {
        ArrayList<com.liferay.portal.search.sort.Sort> searchSorts = new ArrayList<com.liferay.portal.search.sort.Sort>();
        for (Sort sort : sorts) {
            SortOrder sortOrder = SortOrder.ASC;
            if (sort.isReverse()) {
                sortOrder = SortOrder.DESC;
            }
            com.liferay.portal.search.sort.Sort searchSort = this._ddmIndexer.createDDMStructureFieldSort(ddmStructure, sort.getFieldName(), this.contextAcceptLanguage.getPreferredLocale(), sortOrder);
            searchSorts.add(searchSort);
        }
        return (com.liferay.portal.search.sort.Sort[])searchSorts.toArray(new FieldSort[0]);
    }

    private DataRecord _toDataRecord(final DDLRecord ddlRecord) throws Exception {
        if (ddlRecord == null) {
            return null;
        }
        final DDLRecordSet ddlRecordSet = ddlRecord.getRecordSet();
        final DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
        final DataStorage dataStorage = this._getDataStorage(ddmStructure.getStorageType());
        return new DataRecord(){
            {
                this.dataRecordCollectionId = ddlRecordSet.getRecordSetId();
                this.dataRecordValues = dataStorage.get(ddmStructure.getStructureId(), ddlRecord.getDDMStorageId());
                this.id = ddlRecord.getRecordId();
                this.status = ddlRecord.getStatus();
            }
        };
    }
}

