/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.strategy;

import com.liferay.data.engine.rest.internal.strategy.MapToDDMFormValuesConverterStrategy;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class NestedFieldsSupportMapToDDMFormValuesConverterStrategy
implements MapToDDMFormValuesConverterStrategy {
    private static final NestedFieldsSupportMapToDDMFormValuesConverterStrategy _nestedFieldsSupportMapToDDMFormValuesConverterStrategy = new NestedFieldsSupportMapToDDMFormValuesConverterStrategy();

    public static NestedFieldsSupportMapToDDMFormValuesConverterStrategy getInstance() {
        return _nestedFieldsSupportMapToDDMFormValuesConverterStrategy;
    }

    @Override
    public void setDDMFormFieldValues(Map<String, Object> dataRecordValues, DDMForm ddmForm, DDMFormValues ddmFormValues, Locale locale) {
        Map ddmFormFields = ddmForm.getDDMFormFieldsMap(true);
        for (Map.Entry<String, Object> entry : dataRecordValues.entrySet()) {
            String[] parts = StringUtil.split((String)entry.getKey(), (String)"_INSTANCE_");
            ddmFormValues.addDDMFormFieldValue(this._createDDMFormFieldValue((DDMFormField)ddmFormFields.get(parts[0]), ddmFormFields, (Map)entry.getValue(), parts[1], locale));
        }
    }

    private NestedFieldsSupportMapToDDMFormValuesConverterStrategy() {
    }

    private void _addMissingValues(Map<String, DDMFormField> ddmFormFieldsMap, Locale locale, Map<String, Object> values) {
        for (Map.Entry<String, DDMFormField> entry : ddmFormFieldsMap.entrySet()) {
            Set<String> keys = values.keySet();
            Stream stream = keys.stream();
            if (stream.anyMatch(key -> StringUtil.startsWith((String)key, (String)((String)entry.getKey())))) continue;
            Object value = "";
            DDMFormField ddmFormField = entry.getValue();
            if (ddmFormField.isLocalizable()) {
                value = HashMapBuilder.put((Object)LocaleUtil.toLanguageId((Locale)locale), (Object)"").build();
            }
            values.put(StringBundler.concat((String[])new String[]{entry.getKey(), "_INSTANCE_", StringUtil.randomString()}), HashMapBuilder.put((Object)"value", (Object)value).build());
        }
    }

    private DDMFormFieldValue _createDDMFormFieldValue(final DDMFormField ddmFormField, Map<String, DDMFormField> ddmFormFields, Map<String, Object> fieldInstanceValue, final String instanceId, Locale locale) {
        DDMFormFieldValue ddmFormFieldValue = new DDMFormFieldValue(){
            {
                this.setName(ddmFormField.getName());
                this.setInstanceId(instanceId);
            }
        };
        Object value = fieldInstanceValue.get("value");
        if (!StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset") && Validator.isNotNull((Object)value)) {
            ddmFormFieldValue.setValue(this.createValue(ddmFormField, locale, value));
        }
        if (ListUtil.isNotEmpty((List)ddmFormField.getNestedDDMFormFields())) {
            Map nestedValues = (Map)GetterUtil.getObject((Object)fieldInstanceValue.get("nestedValues"), new HashMap());
            this._addMissingValues(ddmFormField.getNestedDDMFormFieldsMap(), locale, nestedValues);
            if (MapUtil.isEmpty((Map)nestedValues)) {
                return ddmFormFieldValue;
            }
            for (Map.Entry entry : nestedValues.entrySet()) {
                String[] parts = StringUtil.split((String)((String)entry.getKey()), (String)"_INSTANCE_");
                ddmFormFieldValue.addNestedDDMFormFieldValue(this._createDDMFormFieldValue(ddmFormFields.get(parts[0]), ddmFormFields, (Map)entry.getValue(), parts[1], locale));
            }
        }
        return ddmFormFieldValue;
    }
}

