/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.security.permission.resource;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeRegistry;
import com.liferay.data.engine.rest.internal.security.permission.resource.DataRecordCollectionModelResourcePermission;
import com.liferay.dynamic.data.lists.model.DDLRecord;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.Portal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.lists.model.DDLRecord"}, service={DataRecordModelResourcePermission.class})
public class DataRecordModelResourcePermission
implements ModelResourcePermission<DDLRecord> {
    @Reference
    private DataDefinitionContentTypeRegistry _dataDefinitionContentTypeRegistry;
    @Reference
    private DataRecordCollectionModelResourcePermission _dataRecordCollectionModelResourcePermission;
    @Reference
    private DDLRecordLocalService _ddlRecordLocalService;
    @Reference
    private Portal _portal;

    public void check(PermissionChecker permissionChecker, DDLRecord ddlRecord, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, ddlRecord, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, this._getModelResourceName(ddlRecord), ddlRecord.getRecordId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        this.check(permissionChecker, this._ddlRecordLocalService.getDDLRecord(primaryKey), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, DDLRecord ddlRecord, String actionId) throws PortalException {
        DDLRecordSet recordSet = ddlRecord.getRecordSet();
        boolean hasPermission = this._dataRecordCollectionModelResourcePermission.contains(permissionChecker, recordSet, actionId);
        if (hasPermission) {
            return true;
        }
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        DataDefinitionContentType dataDefinitionContentType = this._dataDefinitionContentTypeRegistry.getDataDefinitionContentType(ddmStructure.getClassNameId());
        if (dataDefinitionContentType == null) {
            return false;
        }
        return dataDefinitionContentType.hasPermission(permissionChecker, ddlRecord.getCompanyId(), ddlRecord.getGroupId(), this._getModelResourceName(ddlRecord), ddlRecord.getRecordId(), ddlRecord.getUserId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._ddlRecordLocalService.getDDLRecord(primaryKey), actionId);
    }

    public String getModelName() {
        return DDLRecord.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return null;
    }

    private String _getModelResourceName(DDLRecord ddlRecord) throws PortalException {
        DDLRecordSet recordSet = ddlRecord.getRecordSet();
        DDMStructure ddmStructure = recordSet.getDDMStructure();
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{this._portal.getClassName(ddmStructure.getClassNameId()), DDLRecord.class.getName()});
    }
}

