/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.storage;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.data.engine.rest.dto.v2_0.DataRecordCollection;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.DataRecordCollectionUtil;
import com.liferay.data.engine.rest.internal.dto.v2_0.util.MapToDDMFormValuesConverterUtil;
import com.liferay.data.engine.rest.internal.storage.util.DataStorageUtil;
import com.liferay.data.engine.storage.DataStorage;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMFieldLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"data.storage.type=default", "service.ranking:Integer=100"}, service={DataStorage.class})
public class DefaultDataStorage
implements DataStorage {
    @Reference
    private CounterLocalService _counterLocalService;
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private DDMFieldLocalService _ddmFieldLocalService;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;

    public long delete(long dataStorageId) {
        this._ddmFieldLocalService.deleteDDMFormValues(dataStorageId);
        return dataStorageId;
    }

    public Map<String, Object> get(long dataDefinitionId, long dataStorageId) throws PortalException {
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataDefinitionId);
        return DataStorageUtil.toDataRecordValues(this._ddmFieldLocalService.getDDMFormValues(ddmStructure.getFullHierarchyDDMForm(), dataStorageId), ddmStructure);
    }

    public long save(long dataRecordCollectionId, Map<String, Object> dataRecordValues, long siteId) throws PortalException {
        DataRecordCollection dataRecordCollection = DataRecordCollectionUtil.toDataRecordCollection(this._ddlRecordSetLocalService.getRecordSet(dataRecordCollectionId));
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dataRecordCollection.getDataDefinitionId().longValue());
        long primaryKey = this._counterLocalService.increment();
        this._ddmFieldLocalService.updateDDMFormValues(ddmStructure.getStructureId(), primaryKey, MapToDDMFormValuesConverterUtil.toDDMFormValues(dataRecordValues, ddmStructure.getFullHierarchyDDMForm(), null));
        return primaryKey;
    }
}

