/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.content.type;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.rest.resource.exception.DataDefinitionValidationException;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={DataDefinitionContentTypeRegistry.class})
public class DataDefinitionContentTypeRegistry {
    private ServiceTrackerMap<String, DataDefinitionContentType> _serviceTrackerMap;

    public Long getClassNameId(String contentType) throws Exception {
        DataDefinitionContentType dataDefinitionContentType = this.getDataDefinitionContentType(contentType);
        Long id = dataDefinitionContentType.getClassNameId();
        if (id == null) {
            throw new DataDefinitionValidationException.MustSetValidContentType(contentType);
        }
        return id;
    }

    public DataDefinitionContentType getDataDefinitionContentType(long classNameId) {
        for (DataDefinitionContentType dataDefinitionContentType : this._serviceTrackerMap.values()) {
            if (dataDefinitionContentType.getClassNameId() != classNameId) continue;
            return dataDefinitionContentType;
        }
        return null;
    }

    public DataDefinitionContentType getDataDefinitionContentType(String contentType) throws Exception {
        DataDefinitionContentType dataDefinitionContentType = (DataDefinitionContentType)this._serviceTrackerMap.getService((Object)contentType);
        if (dataDefinitionContentType == null) {
            throw new DataDefinitionValidationException.MustSetValidContentType(contentType);
        }
        return dataDefinitionContentType;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DataDefinitionContentType.class, (String)"content.type");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

