/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.security.permission.resource;

import com.liferay.data.engine.content.type.DataDefinitionContentType;
import com.liferay.data.engine.rest.internal.content.type.DataDefinitionContentTypeRegistry;
import com.liferay.dynamic.data.lists.model.DDLRecordSet;
import com.liferay.dynamic.data.lists.service.DDLRecordSetLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.Portal;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dynamic.data.lists.model.DDLRecordSet"}, service={DataRecordCollectionModelResourcePermission.class})
public class DataRecordCollectionModelResourcePermission
implements ModelResourcePermission<DDLRecordSet> {
    @Reference
    private DataDefinitionContentTypeRegistry _dataDefinitionContentTypeRegistry;
    @Reference
    private DDLRecordSetLocalService _ddlRecordSetLocalService;
    @Reference
    private Portal _portal;

    public void check(PermissionChecker permissionChecker, DDLRecordSet ddlRecordSet, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, ddlRecordSet, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, this._getModelResourceName(ddlRecordSet), ddlRecordSet.getRecordSetId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        this.check(permissionChecker, this._ddlRecordSetLocalService.getDDLRecordSet(primaryKey), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, DDLRecordSet ddlRecordSet, String actionId) throws PortalException {
        DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
        DataDefinitionContentType dataDefinitionContentType = this._dataDefinitionContentTypeRegistry.getDataDefinitionContentType(ddmStructure.getClassNameId());
        if (dataDefinitionContentType == null) {
            return false;
        }
        return dataDefinitionContentType.hasPermission(permissionChecker, ddlRecordSet.getCompanyId(), ddlRecordSet.getGroupId(), this._getModelResourceName(ddlRecordSet), ddlRecordSet.getRecordSetId(), ddlRecordSet.getUserId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._ddlRecordSetLocalService.getDDLRecordSet(primaryKey), actionId);
    }

    public String getModelName() {
        return DDLRecordSet.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return null;
    }

    private String _getModelResourceName(DDLRecordSet ddlRecordSet) throws PortalException {
        DDMStructure ddmStructure = ddlRecordSet.getDDMStructure();
        return ResourceActionsUtil.getCompositeModelName((String[])new String[]{this._portal.getClassName(ddmStructure.getClassNameId()), DDLRecordSet.class.getName()});
    }
}

