/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.rest.internal.strategy;

import com.liferay.data.engine.rest.internal.strategy.MapToDDMFormValuesConverterStrategy;
import com.liferay.data.engine.rest.strategy.util.DataRecordValueKeyUtil;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.UnlocalizedValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.util.DDMFormFieldParameterNameUtil;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;

public class DefaultMapToDDMFormValuesConverterStrategy
implements MapToDDMFormValuesConverterStrategy {
    private static final DefaultMapToDDMFormValuesConverterStrategy _defaultMapToDDMFormValuesConverterStrategy = new DefaultMapToDDMFormValuesConverterStrategy();

    public static DefaultMapToDDMFormValuesConverterStrategy getInstance() {
        return _defaultMapToDDMFormValuesConverterStrategy;
    }

    @Override
    public void setDDMFormFieldValues(Map<String, Object> dataRecordValues, DDMForm ddmForm, DDMFormValues ddmFormValues, Locale locale) {
        HashMap<String, DDMFormFieldValue> ddmFormFieldValues = new HashMap<String, DDMFormFieldValue>();
        this._createDDMFormFieldValues(dataRecordValues, ddmForm.getDDMFormFields(), ddmFormFieldValues, ddmForm.getDefaultLocale(), locale, "");
        ddmFormValues.setDDMFormFieldValues(DDMFormValuesFactoryUtil.getDDMFormFieldValues(ddmFormFieldValues, (List)ddmForm.getDDMFormFields()));
    }

    private DefaultMapToDDMFormValuesConverterStrategy() {
    }

    private void _createDDMFormFieldValues(Map<String, Object> dataRecordValues, final DDMFormField ddmFormField, Map<String, DDMFormFieldValue> ddmFormFieldValues, Locale defaultLocale, Locale locale, String parentDataRecordValueKey) {
        DDMFormFieldValue ddmFormFieldValue = null;
        boolean hasDataRecordValue = false;
        for (Map.Entry<String, Object> entry : dataRecordValues.entrySet()) {
            String dataRecordValueKey = entry.getKey();
            String[] dataRecordValueKeyParts = DDMFormFieldParameterNameUtil.getLastDDMFormFieldParameterNameParts((String)dataRecordValueKey);
            final String dataRecordValueFieldName = dataRecordValueKeyParts[0];
            if (!this._isDataRecordValueFromDDMFormField(dataRecordValueFieldName, dataRecordValueKey, ddmFormField.getName(), parentDataRecordValueKey)) continue;
            final String instanceId = dataRecordValueKeyParts[1];
            ddmFormFieldValue = new DDMFormFieldValue(){
                {
                    this.setInstanceId(instanceId);
                    this.setName(dataRecordValueFieldName);
                }
            };
            LocalizedValue value = null;
            if (entry.getValue() != null) {
                if (ddmFormField.isLocalizable() && !ddmFormField.isTransient()) {
                    value = new LocalizedValue();
                    Map localizedValues = (Map)entry.getValue();
                    if (locale == null) {
                        for (Map.Entry localizedValue : localizedValues.entrySet()) {
                            value.addString(LocaleUtil.fromLanguageId((String)((String)localizedValue.getKey())), Objects.toString(localizedValues.get(localizedValue.getKey()), null));
                        }
                    } else {
                        value.addString(locale, Objects.toString(GetterUtil.getObject(localizedValues.get(LocaleUtil.toLanguageId((Locale)locale)), localizedValues.get(LocaleUtil.toLanguageId((Locale)defaultLocale))), null));
                    }
                } else {
                    value = new UnlocalizedValue((String)entry.getValue());
                }
            }
            ddmFormFieldValue.setValue(value);
            ddmFormFieldValues.put(dataRecordValueKey, ddmFormFieldValue);
            if (ListUtil.isNotEmpty((List)ddmFormField.getNestedDDMFormFields())) {
                this._createDDMFormFieldValues(dataRecordValues, ddmFormField.getNestedDDMFormFields(), ddmFormFieldValues, defaultLocale, locale, dataRecordValueKey);
            }
            hasDataRecordValue = true;
        }
        if (!hasDataRecordValue) {
            ddmFormFieldValue = new DDMFormFieldValue(){
                {
                    this.setName(ddmFormField.getName());
                }
            };
            String dataRecordValueKey = DataRecordValueKeyUtil.createDataRecordValueKey((String)ddmFormField.getName(), (String)ddmFormFieldValue.getInstanceId(), (String)parentDataRecordValueKey, (int)0);
            ddmFormFieldValues.put(dataRecordValueKey, ddmFormFieldValue);
            if (ListUtil.isNotEmpty((List)ddmFormField.getNestedDDMFormFields())) {
                this._createDDMFormFieldValues(dataRecordValues, ddmFormField.getNestedDDMFormFields(), ddmFormFieldValues, defaultLocale, locale, dataRecordValueKey);
            }
        }
    }

    private void _createDDMFormFieldValues(Map<String, Object> dataRecordValues, List<DDMFormField> ddmFormFields, Map<String, DDMFormFieldValue> ddmFormFieldValues, Locale defaultLocale, Locale locale, String parentDataRecordValueKey) {
        for (DDMFormField ddmFormField : ddmFormFields) {
            this._createDDMFormFieldValues(dataRecordValues, ddmFormField, ddmFormFieldValues, defaultLocale, locale, parentDataRecordValueKey);
        }
    }

    private boolean _isDataRecordValueFromDDMFormField(String dataRecordValueFieldName, String dataRecordValueKey, String ddmFormFieldName, String parentDataRecordValueKey) {
        return StringUtil.equals((String)ddmFormFieldName, (String)dataRecordValueFieldName) && (Validator.isNull((String)parentDataRecordValueKey) || dataRecordValueKey.contains(parentDataRecordValueKey));
    }
}

