/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.internal.roles.admin.role.type.contributor;

import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.roles.admin.role.type.contributor.RoleTypeContributor;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=400"}, service={RoleTypeContributor.class})
public class DepotRoleTypeContributor
implements RoleTypeContributor {
    private static final String[] _EXCLUDED_ROLE_NAMES = new String[]{"Asset Library Owner"};
    @Reference
    private Language _language;

    public String[] getExcludedRoleNames() {
        return _EXCLUDED_ROLE_NAMES;
    }

    public String getIcon() {
        return "globe";
    }

    public String getName() {
        return "asset-library";
    }

    public String[] getSubtypes() {
        return new String[0];
    }

    public String getTabTitle(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)locale, DepotRoleTypeContributor.class);
        return this._language.get(resourceBundle, "asset-library-roles");
    }

    public String getTitle(Locale locale) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)locale, DepotRoleTypeContributor.class);
        return this._language.get(resourceBundle, "asset-library-role");
    }

    public int getType() {
        return 5;
    }

    public boolean isAllowAssignMembers(Role role) {
        return false;
    }

    public boolean isAllowDelete(Role role) {
        return role != null && !Objects.equals(role.getName(), "Asset Library Administrator") && !Objects.equals(role.getName(), "Asset Library Member") && !Objects.equals(role.getName(), "Asset Library Connected Site Member") && !Objects.equals(role.getName(), "Asset Library Owner");
    }

    public boolean isAutomaticallyAssigned(Role role) {
        return Objects.equals(role.getName(), "Asset Library Member") || Objects.equals(role.getName(), "Asset Library Connected Site Member");
    }
}

