/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.depot.service.DepotEntryLocalServiceUtil;
import com.liferay.depot.service.persistence.DepotEntryPersistence;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class DepotEntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
DepotEntryLocalService,
IdentifiableOSGiService {
    protected DepotEntryLocalService depotEntryLocalService;
    @Reference
    protected DepotEntryPersistence depotEntryPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected ResourceLocalService resourceLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public DepotEntry addDepotEntry(DepotEntry depotEntry) {
        depotEntry.setNew(true);
        return (DepotEntry)this.depotEntryPersistence.update((BaseModel)depotEntry);
    }

    @Transactional(enabled=false)
    public DepotEntry createDepotEntry(long depotEntryId) {
        return this.depotEntryPersistence.create(depotEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public DepotEntry deleteDepotEntry(long depotEntryId) throws PortalException {
        return this.depotEntryPersistence.remove(depotEntryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public DepotEntry deleteDepotEntry(DepotEntry depotEntry) {
        return (DepotEntry)this.depotEntryPersistence.remove((BaseModel)depotEntry);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.depotEntryPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(DepotEntry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.depotEntryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.depotEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.depotEntryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.depotEntryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.depotEntryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public DepotEntry fetchDepotEntry(long depotEntryId) {
        return this.depotEntryPersistence.fetchByPrimaryKey(depotEntryId);
    }

    public DepotEntry fetchDepotEntryByUuidAndGroupId(String uuid, long groupId) {
        return this.depotEntryPersistence.fetchByUUID_G(uuid, groupId);
    }

    public DepotEntry getDepotEntry(long depotEntryId) throws PortalException {
        return this.depotEntryPersistence.findByPrimaryKey(depotEntryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.depotEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(DepotEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("depotEntryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.depotEntryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(DepotEntry.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("depotEntryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.depotEntryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(DepotEntry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("depotEntryId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<DepotEntry>(){

            public void performAction(DepotEntry depotEntry) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)depotEntry);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)DepotEntry.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.depotEntryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.depotEntryLocalService.deleteDepotEntry((DepotEntry)persistedModel);
    }

    public BasePersistence<DepotEntry> getBasePersistence() {
        return this.depotEntryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.depotEntryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<DepotEntry> getDepotEntriesByUuidAndCompanyId(String uuid, long companyId) {
        return this.depotEntryPersistence.findByUuid_C(uuid, companyId);
    }

    public List<DepotEntry> getDepotEntriesByUuidAndCompanyId(String uuid, long companyId, int start, int end, OrderByComparator<DepotEntry> orderByComparator) {
        return this.depotEntryPersistence.findByUuid_C(uuid, companyId, start, end, orderByComparator);
    }

    public DepotEntry getDepotEntryByUuidAndGroupId(String uuid, long groupId) throws PortalException {
        return this.depotEntryPersistence.findByUUID_G(uuid, groupId);
    }

    public List<DepotEntry> getDepotEntries(int start, int end) {
        return this.depotEntryPersistence.findAll(start, end);
    }

    public int getDepotEntriesCount() {
        return this.depotEntryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public DepotEntry updateDepotEntry(DepotEntry depotEntry) {
        return (DepotEntry)this.depotEntryPersistence.update((BaseModel)depotEntry);
    }

    @Deactivate
    protected void deactivate() {
        this._setLocalServiceUtilService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{DepotEntryLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.depotEntryLocalService = (DepotEntryLocalService)aopProxy;
        this._setLocalServiceUtilService(this.depotEntryLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return DepotEntryLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return DepotEntry.class;
    }

    protected String getModelClassName() {
        return DepotEntry.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.depotEntryPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    private void _setLocalServiceUtilService(DepotEntryLocalService depotEntryLocalService) {
        try {
            Field field = DepotEntryLocalServiceUtil.class.getDeclaredField("_service");
            field.setAccessible(true);
            field.set(null, depotEntryLocalService);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }
}

