/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.digital.signature.internal.http;

import com.liferay.digital.signature.configuration.DigitalSignatureConfiguration;
import com.liferay.digital.signature.configuration.DigitalSignatureConfigurationUtil;
import com.liferay.digital.signature.internal.web.cache.DSAccessTokenWebCacheItem;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Http;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DSHttp.class})
public class DSHttp {
    @Reference
    private Http _http;
    @Reference
    private JSONFactory _jsonFactory;

    public JSONObject get(long companyId, long groupId, String location) {
        try {
            return this._invoke(companyId, groupId, location, Http.Method.GET, null);
        }
        catch (Exception exception) {
            return (JSONObject)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    public byte[] getAsBytes(long companyId, long groupId, String location) {
        try {
            return this._invokeAsBytes(companyId, groupId, location, Http.Method.GET, null);
        }
        catch (Exception exception) {
            return (byte[])ReflectionUtil.throwException((Throwable)exception);
        }
    }

    public JSONObject post(long companyId, long groupId, String location, JSONObject bodyJSONObject) {
        try {
            return this._invoke(companyId, groupId, location, Http.Method.POST, bodyJSONObject);
        }
        catch (Exception exception) {
            return (JSONObject)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    public JSONObject put(long companyId, long groupId, String location, JSONObject bodyJSONObject) {
        try {
            return this._invoke(companyId, groupId, location, Http.Method.PUT, bodyJSONObject);
        }
        catch (Exception exception) {
            return (JSONObject)ReflectionUtil.throwException((Throwable)exception);
        }
    }

    private String _getDocuSignAccessToken(DigitalSignatureConfiguration digitalSignatureConfiguration) throws Exception {
        JSONObject jsonObject = DSAccessTokenWebCacheItem.get(digitalSignatureConfiguration.apiUsername(), digitalSignatureConfiguration.integrationKey(), digitalSignatureConfiguration.rsaPrivateKey());
        return jsonObject.getString("access_token");
    }

    private JSONObject _invoke(long companyId, long groupId, String location, Http.Method method, JSONObject bodyJSONObject) throws Exception {
        byte[] bytes = this._invokeAsBytes(companyId, groupId, location, method, bodyJSONObject);
        if (bytes == null) {
            return this._jsonFactory.createJSONObject();
        }
        return this._jsonFactory.createJSONObject(new String(bytes));
    }

    private byte[] _invokeAsBytes(long companyId, long groupId, String location, Http.Method method, JSONObject bodyJSONObject) throws Exception {
        Http.Options options = new Http.Options();
        if (bodyJSONObject != null) {
            options.addHeader("Content-Type", "application/json");
        }
        DigitalSignatureConfiguration digitalSignatureConfiguration = DigitalSignatureConfigurationUtil.getDigitalSignatureConfiguration((long)companyId, (long)groupId);
        options.addHeader("Authorization", "Bearer " + this._getDocuSignAccessToken(digitalSignatureConfiguration));
        if (bodyJSONObject != null) {
            options.setBody(bodyJSONObject.toString(), "application/json", "UTF-8");
        }
        options.setLocation(StringBundler.concat((String[])new String[]{digitalSignatureConfiguration.accountBaseURI(), "/restapi/v2.1/accounts/", digitalSignatureConfiguration.apiAccountId(), "/", location}));
        options.setMethod(method);
        return this._http.URLtoByteArray(options);
    }
}

