/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.digital.signature.internal.manager;

import com.liferay.digital.signature.internal.http.DSHttp;
import com.liferay.digital.signature.manager.DSCustomFieldManager;
import com.liferay.digital.signature.manager.DSEnvelopeManager;
import com.liferay.digital.signature.model.DSCustomField;
import com.liferay.digital.signature.model.DSDocument;
import com.liferay.digital.signature.model.DSEnvelope;
import com.liferay.digital.signature.model.DSRecipient;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.vulcan.pagination.Page;
import com.liferay.portal.vulcan.pagination.Pagination;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DSEnvelopeManager.class})
public class DSEnvelopeManagerImpl
implements DSEnvelopeManager {
    private static final Log _log = LogFactoryUtil.getLog(DSEnvelopeManagerImpl.class);
    private static final Pattern _pattern = Pattern.compile("[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{12}");
    @Reference
    private DSCustomFieldManager _dsCustomFieldManager;
    @Reference
    private DSHttp _dsHttp;

    public DSEnvelope addDSEnvelope(long companyId, long groupId, DSEnvelope dsEnvelope) {
        final String dsEnvelopeName = dsEnvelope.getName();
        final String dsEnvelopeSenderEmailAddress = dsEnvelope.getSenderEmailAddress();
        dsEnvelope = this._toDSEnvelope(this._dsHttp.post(companyId, groupId, "envelopes", dsEnvelope.toJSONObject()));
        this._dsCustomFieldManager.addDSCustomFields(companyId, groupId, dsEnvelope.getDSEnvelopeId(), new DSCustomField[]{new DSCustomField(){
            {
                this.name = "envelopeName";
                this.show = true;
                this.value = dsEnvelopeName;
            }
        }, new DSCustomField(){
            {
                this.name = "envelopeSenderEmailAddress";
                this.show = true;
                this.value = dsEnvelopeSenderEmailAddress;
            }
        }});
        return this.getDSEnvelope(companyId, groupId, dsEnvelope.getDSEnvelopeId(), "custom_fields,recipients");
    }

    public void deleteDSEnvelopes(long companyId, long groupId, String ... dsEnvelopeIds) throws Exception {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        if (permissionChecker == null || !permissionChecker.isCompanyAdmin(companyId)) {
            throw new PrincipalException.MustBeCompanyAdmin(permissionChecker);
        }
        this._dsHttp.put(companyId, groupId, "folders/recyclebin", JSONUtil.put((String)"envelopeIds", (Object)JSONUtil.toJSONArray((Object[])dsEnvelopeIds, dsEnvelopeId -> dsEnvelopeId, (Log)_log)));
    }

    public DSEnvelope getDSEnvelope(long companyId, long groupId, String dsEnvelopeId) {
        return this.getDSEnvelope(companyId, groupId, dsEnvelopeId, "custom_fields,documents,recipients");
    }

    public DSEnvelope getDSEnvelope(long companyId, long groupId, String dsEnvelopeId, String include) {
        JSONObject jsonObject = this._dsHttp.get(companyId, groupId, StringBundler.concat((String[])new String[]{"envelopes/", dsEnvelopeId, "?include=", include}));
        return this._toDSEnvelope(jsonObject);
    }

    public Page<DSEnvelope> getDSEnvelopesPage(long companyId, long groupId, String fromDateString, String keywords, String order, Pagination pagination, String status) {
        Matcher matcher = _pattern.matcher(keywords);
        if (matcher.matches()) {
            DSEnvelope dsEnvelope = this.getDSEnvelope(companyId, groupId, keywords);
            if (Validator.isNull((String)dsEnvelope.getDSEnvelopeId())) {
                return Page.of(Collections.emptyList(), (Pagination)pagination, (long)0L);
            }
            return Page.of(Collections.singletonList(dsEnvelope), (Pagination)pagination, (long)1L);
        }
        String location = StringBundler.concat((Object[])new Object[]{"envelopes?count=", pagination.getPageSize(), "&from_date=", fromDateString, "&folder_types=sentitems&start_position=", pagination.getStartPosition(), "&include=custom_fields,documents,recipients&order=", order});
        if (!Validator.isBlank((String)keywords)) {
            location = location + "&search_text=" + keywords;
        }
        if (!Validator.isBlank((String)status)) {
            location = location + "&status=" + status;
        }
        JSONObject jsonObject = this._dsHttp.get(companyId, groupId, location);
        return Page.of((Collection)JSONUtil.toList((JSONArray)jsonObject.getJSONArray("envelopes"), envelopeJSONObject -> this._toDSEnvelope((JSONObject)envelopeJSONObject), (Log)_log), (Pagination)pagination, (long)jsonObject.getInt("totalSetSize"));
    }

    private List<DSDocument> _getDSDocuments(JSONArray jsonArray) {
        return JSONUtil.toList((JSONArray)jsonArray, jsonObject -> new DSDocument((JSONObject)jsonObject){
            final /* synthetic */ JSONObject val$jsonObject;
            {
                this.val$jsonObject = jSONObject;
                this.dsDocumentId = this.val$jsonObject.getString("documentId");
                this.fileExtension = this.val$jsonObject.getString("fileExtension");
                this.name = this.val$jsonObject.getString("name");
                this.uri = this.val$jsonObject.getString("uri");
            }
        }, (Log)_log);
    }

    private List<DSRecipient> _getDSRecipients(JSONObject jsonObject) {
        if (jsonObject == null) {
            return Collections.emptyList();
        }
        return JSONUtil.toList((JSONArray)jsonObject.getJSONArray("signers"), signerJSONObject -> new DSRecipient((JSONObject)signerJSONObject){
            final /* synthetic */ JSONObject val$signerJSONObject;
            {
                this.val$signerJSONObject = jSONObject;
                this.dsRecipientId = this.val$signerJSONObject.getString("recipientId");
                this.emailAddress = this.val$signerJSONObject.getString("email");
                this.name = this.val$signerJSONObject.getString("name");
                this.status = this.val$signerJSONObject.getString("status");
            }
        }, (Log)_log);
    }

    private void _setDSEnvelopeCustomField(DSEnvelope dsEnvelope, JSONObject jsonObject) {
        String name = jsonObject.getString("name");
        String value = jsonObject.getString("value");
        if (Objects.equals(name, "envelopeName")) {
            dsEnvelope.setName(value);
        } else if (Objects.equals(name, "envelopeSenderEmailAddress")) {
            dsEnvelope.setSenderEmailAddress(value);
        }
    }

    private void _setDSEnvelopeCustomFields(DSEnvelope dsEnvelope, JSONObject jsonObject) {
        if (jsonObject == null) {
            return;
        }
        JSONArray jsonArray = jsonObject.getJSONArray("textCustomFields");
        jsonArray.forEach(element -> this._setDSEnvelopeCustomField(dsEnvelope, (JSONObject)element));
    }

    private DSEnvelope _toDSEnvelope(final JSONObject jsonObject) {
        if (jsonObject == null) {
            return new DSEnvelope();
        }
        DSEnvelope dsEnvelope = new DSEnvelope(){
            {
                this.createdLocalDateTime = DSEnvelopeManagerImpl.this._toLocalDateTime(jsonObject.getString("createdDateTime"));
                this.dsDocuments = DSEnvelopeManagerImpl.this._getDSDocuments(jsonObject.getJSONArray("envelopeDocuments"));
                this.dsEnvelopeId = jsonObject.getString("envelopeId");
                this.dsRecipients = DSEnvelopeManagerImpl.this._getDSRecipients(jsonObject.getJSONObject("recipients"));
                this.emailBlurb = jsonObject.getString("emailBlurb");
                this.emailSubject = jsonObject.getString("emailSubject");
                this.status = jsonObject.getString("status");
            }
        };
        this._setDSEnvelopeCustomFields(dsEnvelope, jsonObject.getJSONObject("customFields"));
        return dsEnvelope;
    }

    private LocalDateTime _toLocalDateTime(String localDateTimeString) {
        try {
            return LocalDateTime.parse(localDateTimeString, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSSSSSX"));
        }
        catch (Exception exception) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Invalid local date time " + localDateTimeString));
            }
            return null;
        }
    }
}

