/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.digital.signature.internal.web.cache;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.webcache.WebCachePoolUtil;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.Base64;
import java.util.Map;
import net.oauth.signature.pem.PEMReader;
import net.oauth.signature.pem.PKCS1EncodedKeySpec;

public class DSAccessTokenWebCacheItem
implements WebCacheItem {
    private static final long _REFRESH_TIME = 2700000L;
    private static final Log _log = LogFactoryUtil.getLog(DSAccessTokenWebCacheItem.class);
    private final String _apiUsername;
    private final String _integrationKey;
    private final byte[] _rsaPrivateKeyBytes;

    public static JSONObject get(String apiUsername, String integrationKey, String rsaPrivateKey) {
        return (JSONObject)WebCachePoolUtil.get((String)StringBundler.concat((String[])new String[]{DSAccessTokenWebCacheItem.class.getName(), "#", apiUsername, "#", integrationKey, "#", rsaPrivateKey}), (WebCacheItem)new DSAccessTokenWebCacheItem(apiUsername, integrationKey, rsaPrivateKey));
    }

    public DSAccessTokenWebCacheItem(String apiUsername, String integrationKey, String rsaPrivateKey) {
        this._apiUsername = apiUsername;
        this._integrationKey = integrationKey;
        this._rsaPrivateKeyBytes = rsaPrivateKey != null ? rsaPrivateKey.getBytes() : new byte[0];
    }

    public JSONObject convert(String key) {
        try {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Get DocuSign access token for integration key " + this._integrationKey));
            }
            Http.Options options = new Http.Options();
            options.setParts((Map)HashMapBuilder.put((Object)"assertion", (Object)this._getJWT()).put((Object)"grant_type", (Object)"urn:ietf:params:oauth:grant-type:jwt-bearer").build());
            options.setLocation("https://account-d.docusign.com/oauth/token");
            options.setPost(true);
            return JSONFactoryUtil.createJSONObject((String)HttpUtil.URLtoString((Http.Options)options));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            return JSONFactoryUtil.createJSONObject();
        }
    }

    public long getRefreshTime() {
        return 2700000L;
    }

    private String _encode(byte[] bytes) {
        Base64.Encoder encoder = Base64.getUrlEncoder();
        return encoder.encodeToString(bytes);
    }

    private String _getJWT() throws Exception {
        Signature signature = Signature.getInstance("SHA256withRSA");
        signature.initSign(this._readPrivateKey());
        String headerJSON = JSONUtil.put((String)"alg", (Object)"RS256").put("typ", "JWT").toString();
        long unixTime = System.currentTimeMillis() / 1000L;
        String bodyJSON = JSONUtil.put((String)"aud", (Object)"account-d.docusign.com").put("exp", unixTime + 3600L).put("iat", unixTime).put("iss", this._integrationKey).put("scope", "signature").put("sub", this._apiUsername).toString();
        String token = this._encode(headerJSON.getBytes()) + "." + this._encode(bodyJSON.getBytes());
        signature.update(token.getBytes());
        return StringUtil.removeSubstring((String)(token + "." + this._encode(signature.sign())), (String)"=");
    }

    private PrivateKey _readPrivateKey() throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PEMReader pemReader = new PEMReader(this._rsaPrivateKeyBytes);
        PKCS1EncodedKeySpec pkcs1EncodedKeySpec = new PKCS1EncodedKeySpec(pemReader.getDerBytes());
        return keyFactory.generatePrivate(pkcs1EncodedKeySpec.getKeySpec());
    }
}

