/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.executor;

import com.liferay.portal.kernel.scheduler.StorageType;

public enum DispatchTaskClusterMode {
    ALL_NODES("all-nodes", 1, StorageType.MEMORY),
    NOT_APPLICABLE("not-applicable", 0, StorageType.PERSISTED),
    SINGLE_NODE_MEMORY_CLUSTERED("single-node-memory-clustered", 3, StorageType.MEMORY_CLUSTERED),
    SINGLE_NODE_PERSISTED("single-node-persisted", 2, StorageType.PERSISTED);

    private final String _label;
    private final int _mode;
    private final StorageType _storageType;

    public static DispatchTaskClusterMode valueOf(int mode) {
        for (DispatchTaskClusterMode dispatchTaskClusterMode : DispatchTaskClusterMode.values()) {
            if (mode != dispatchTaskClusterMode._mode) continue;
            return dispatchTaskClusterMode;
        }
        throw new IllegalArgumentException("Illegal task cluster mode " + mode);
    }

    public String getLabel() {
        return this._label;
    }

    public int getMode() {
        return this._mode;
    }

    public StorageType getStorageType() {
        return this._storageType;
    }

    private DispatchTaskClusterMode(String label, int mode, StorageType storageType) {
        this._label = label;
        this._mode = mode;
        this._storageType = storageType;
    }
}

