/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.internal.repository;

import com.liferay.dispatch.configuration.DispatchConfiguration;
import com.liferay.dispatch.repository.BaseDispatchFileValidator;
import com.liferay.dispatch.repository.DispatchFileValidator;
import com.liferay.dispatch.repository.exception.DispatchRepositoryException;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.util.FileUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(configurationPid={"com.liferay.dispatch.configuration.DispatchConfiguration"}, immediate=true, property={"dispatch.file.validator.type=default"}, service={DispatchFileValidator.class})
public class DefaultDispatchFileValidator
extends BaseDispatchFileValidator {
    private volatile DispatchConfiguration _dispatchConfiguration;

    public void validateExtension(String fileName) throws DispatchRepositoryException {
        if (this.isValidExtension("." + FileUtil.getExtension((String)fileName), this._dispatchConfiguration.fileExtensions())) {
            return;
        }
        throw new DispatchRepositoryException("Invalid file extension for " + fileName);
    }

    public void validateSize(long size) throws DispatchRepositoryException {
        if (this.isValidSize(size, this._dispatchConfiguration.fileMaxSize())) {
            return;
        }
        throw new DispatchRepositoryException(String.format("File size exceeds %d bytes limit", this._dispatchConfiguration.fileMaxSize()));
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._dispatchConfiguration = (DispatchConfiguration)ConfigurableUtil.createConfigurable(DispatchConfiguration.class, properties);
    }
}

