/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.dispatch.model.impl;

import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.DispatchTriggerLocalServiceUtil;

/**
 * The extended model base implementation for the DispatchTrigger service. Represents a row in the &quot;DispatchTrigger&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DispatchTriggerImpl}.
 * </p>
 *
 * @author Matija Petanjek
 * @see DispatchTriggerImpl
 * @see DispatchTrigger
 * @generated
 */
public abstract class DispatchTriggerBaseImpl
	extends DispatchTriggerModelImpl implements DispatchTrigger {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a dispatch trigger model instance should use the <code>DispatchTrigger</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DispatchTriggerLocalServiceUtil.addDispatchTrigger(this);
		}
		else {
			DispatchTriggerLocalServiceUtil.updateDispatchTrigger(this);
		}
	}

}