/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.service.impl;

import com.liferay.dispatch.exception.DispatchLogStartDateException;
import com.liferay.dispatch.exception.DispatchLogStatusException;
import com.liferay.dispatch.executor.DispatchTaskStatus;
import com.liferay.dispatch.model.DispatchLog;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.base.DispatchLogLocalServiceBaseImpl;
import com.liferay.dispatch.service.persistence.DispatchTriggerPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dispatch.model.DispatchLog"}, service={AopService.class})
public class DispatchLogLocalServiceImpl
extends DispatchLogLocalServiceBaseImpl {
    @Reference
    private DispatchTriggerPersistence _dispatchTriggerPersistence;
    @Reference
    private UserLocalService _userLocalService;

    public DispatchLog addDispatchLog(long userId, long dispatchTriggerId, Date endDate, String error, String output, Date startDate, DispatchTaskStatus dispatchTaskStatus) throws PortalException {
        this._checkDispatchLogPeriod(startDate, endDate);
        this._checkDispatchTaskStatus(dispatchTaskStatus);
        DispatchTrigger dispatchTrigger = this._dispatchTriggerPersistence.findByPrimaryKey(dispatchTriggerId);
        User user = this._userLocalService.getUser(userId);
        DispatchLog dispatchLog = this.dispatchLogPersistence.create(this.counterLocalService.increment());
        dispatchLog.setCompanyId(user.getCompanyId());
        dispatchLog.setUserId(user.getUserId());
        dispatchLog.setUserName(user.getFullName());
        dispatchLog.setDispatchTriggerId(dispatchTrigger.getDispatchTriggerId());
        dispatchLog.setEndDate(endDate);
        dispatchLog.setError(error);
        dispatchLog.setOutput(output);
        dispatchLog.setStartDate(startDate);
        dispatchLog.setStatus(dispatchTaskStatus.getStatus());
        return (DispatchLog)this.dispatchLogPersistence.update((BaseModel)dispatchLog);
    }

    @Override
    public DispatchLog deleteDispatchLog(long dispatchLogId) throws PortalException {
        DispatchLog dispatchLog = this.dispatchLogPersistence.findByPrimaryKey(dispatchLogId);
        if (DispatchTaskStatus.valueOf((int)dispatchLog.getStatus()) == DispatchTaskStatus.IN_PROGRESS) {
            throw new DispatchLogStatusException("Dispatch log cannot be deleted while task is in progress");
        }
        return this.dispatchLogPersistence.remove(dispatchLogId);
    }

    public void deleteDispatchLogs(long dispatchTriggerId) {
        this.dispatchLogPersistence.removeByDispatchTriggerId(dispatchTriggerId);
    }

    public DispatchLog fetchLatestDispatchLog(long dispatchTriggerId) {
        return this.dispatchLogPersistence.fetchByDispatchTriggerId_First(dispatchTriggerId, OrderByComparatorFactoryUtil.create((String)"DispatchLog", (Object[])new Object[]{"startDate", "false"}));
    }

    public DispatchLog fetchLatestDispatchLog(long dispatchTriggerId, DispatchTaskStatus dispatchTaskStatus) {
        return this.dispatchLogPersistence.fetchByDTI_S_First(dispatchTriggerId, dispatchTaskStatus.getStatus(), OrderByComparatorFactoryUtil.create((String)"DispatchLog", (Object[])new Object[]{"startDate", "false"}));
    }

    public List<DispatchLog> getDispatchLogs(long dispatchTriggerId, int start, int end) {
        return this.dispatchLogPersistence.findByDispatchTriggerId(dispatchTriggerId, start, end);
    }

    public List<DispatchLog> getDispatchLogs(long dispatchTriggerId, int start, int end, OrderByComparator<DispatchLog> orderByComparator) {
        return this.dispatchLogPersistence.findByDispatchTriggerId(dispatchTriggerId, start, end, orderByComparator);
    }

    public int getDispatchLogsCount(long dispatchTriggerId) {
        return this.dispatchLogPersistence.countByDispatchTriggerId(dispatchTriggerId);
    }

    public DispatchLog updateDispatchLog(long dispatchLogId, Date endDate, String error, String output, DispatchTaskStatus dispatchTaskStatus) throws PortalException {
        DispatchLog dispatchLog = this.dispatchLogPersistence.findByPrimaryKey(dispatchLogId);
        this._checkDispatchLogPeriod(dispatchLog.getStartDate(), endDate);
        this._checkDispatchTaskStatus(dispatchTaskStatus);
        dispatchLog.setEndDate(endDate);
        dispatchLog.setError(error);
        dispatchLog.setOutput(output);
        dispatchLog.setStatus(dispatchTaskStatus.getStatus());
        return (DispatchLog)this.dispatchLogPersistence.update((BaseModel)dispatchLog);
    }

    private void _checkDispatchLogPeriod(Date startDate, Date endDate) throws PortalException {
        if (startDate == null) {
            throw new DispatchLogStartDateException("Start date is required");
        }
        if (endDate == null) {
            return;
        }
        if (startDate.after(endDate)) {
            throw new DispatchLogStartDateException("Start date must precede end date");
        }
    }

    private void _checkDispatchTaskStatus(DispatchTaskStatus dispatchTaskStatus) throws PortalException {
        if (dispatchTaskStatus == null) {
            throw new DispatchLogStatusException("Dispatch task status is required");
        }
    }
}

