/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.talend.archive;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class TalendArchive {
    private final String _classPath;
    private final String _contextName;
    private final Properties _contextProperties;
    private final String _jobDirectory;
    private final String _jobJarParentDirectory;
    private final String _jobJarPath;
    private final String _jobMainClassFQN;
    private final String _jvmOptions;

    public String getClassPath() {
        return this._classPath;
    }

    public String getContextName() {
        return this._contextName;
    }

    public Properties getContextProperties() {
        return this._contextProperties;
    }

    public String getJobDirectory() {
        return this._jobDirectory;
    }

    public String getJobJarParentDirectory() {
        return this._jobJarParentDirectory;
    }

    public String getJobJarPath() {
        return this._jobJarPath;
    }

    public String getJobMainClassFQN() {
        return this._jobMainClassFQN;
    }

    public String getJVMOptions() {
        return this._jvmOptions;
    }

    public boolean hasJVMOptions() {
        return Validator.isNotNull((String)this._jvmOptions);
    }

    private TalendArchive(Builder builder) {
        this._classPath = builder._buildClassPath();
        this._contextName = builder._contextName;
        this._contextProperties = builder._contextProperties;
        this._jobDirectory = builder._jobDirectory;
        this._jobJarParentDirectory = builder._jobJarParentDirectory;
        this._jobJarPath = builder._jobJarPath;
        this._jobMainClassFQN = builder._jobMainClassFQN;
        this._jvmOptions = builder._buildJVMOptions();
    }

    public static class Builder {
        private List<String> _classPathEntries;
        private String _contextName;
        private Properties _contextProperties;
        private String _jobDirectory;
        private String _jobJarParentDirectory;
        private String _jobJarPath;
        private String _jobMainClassFQN;
        private List<String> _jvmOptionsList;

        public TalendArchive build() {
            return new TalendArchive(this);
        }

        public Builder classPathEntries(List<String> classPathEntries) {
            this._classPathEntries = classPathEntries;
            return this;
        }

        public Builder contextName(String contextName) {
            this._contextName = contextName;
            return this;
        }

        public Builder contextProperties(Properties contextProperties) {
            this._contextProperties = new Properties();
            for (String propertyName : contextProperties.stringPropertyNames()) {
                this._contextProperties.put(propertyName, contextProperties.getProperty(propertyName));
            }
            return this;
        }

        public Builder jobDirectory(String jobDirectory) {
            this._jobDirectory = jobDirectory;
            return this;
        }

        public Builder jobJarParentDirectory(String jobJarParentDirectory) {
            this._jobJarParentDirectory = jobJarParentDirectory;
            return this;
        }

        public Builder jobJarPath(String jobJarPath) {
            this._jobJarPath = jobJarPath;
            return this;
        }

        public Builder jobMainClassFQN(String jobMainClassFQN) {
            this._jobMainClassFQN = jobMainClassFQN;
            return this;
        }

        public Builder jvmOptionsList(List<String> jvmOptionsList) {
            this._jvmOptionsList = jvmOptionsList;
            return this;
        }

        private String _buildClassPath() {
            if (this._classPathEntries == null) {
                return "";
            }
            StringBundler sb = new StringBundler(this._classPathEntries.size() * 2 + 1);
            for (String classPathEntry : this._classPathEntries) {
                sb.append(classPathEntry);
                sb.append(File.pathSeparatorChar);
            }
            sb.append(this._jobJarPath);
            return sb.toString();
        }

        private String _buildJVMOptions() {
            if (this._jvmOptionsList == null || this._jvmOptionsList.isEmpty()) {
                return null;
            }
            StringBundler sb = new StringBundler(this._jvmOptionsList.size() * 2 - 1);
            Iterator<String> iterator = this._jvmOptionsList.iterator();
            while (iterator.hasNext()) {
                String jvmOption = iterator.next();
                sb.append(jvmOption);
                if (!iterator.hasNext()) continue;
                sb.append(" ");
            }
            return sb.toString();
        }
    }
}

