/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.document.library.content.model.impl;

import com.liferay.document.library.content.model.DLContent;
import com.liferay.document.library.content.service.DLContentLocalServiceUtil;

/**
 * The extended model base implementation for the DLContent service. Represents a row in the &quot;DLContent&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DLContentImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DLContentImpl
 * @see DLContent
 * @generated
 */
public abstract class DLContentBaseImpl
	extends DLContentModelImpl implements DLContent {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a document library content model instance should use the <code>DLContent</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DLContentLocalServiceUtil.addDLContent(this);
		}
		else {
			DLContentLocalServiceUtil.updateDLContent(this);
		}
	}

}