/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.document.conversion.internal.background.task;

import com.liferay.document.library.kernel.util.PDFProcessor;
import com.liferay.document.library.preview.background.task.BasePreviewBackgroundTaskExecutor;
import com.liferay.portal.kernel.backgroundtask.BackgroundTaskExecutor;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import java.util.ArrayList;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.configuration.DLFileEntryConfiguration"}, property={"background.task.executor.class.name=com.liferay.document.library.document.conversion.internal.background.task.OpenOfficeConversionPreviewBackgroundTaskExecutor"}, service={BackgroundTaskExecutor.class})
public class OpenOfficeConversionPreviewBackgroundTaskExecutor
extends BasePreviewBackgroundTaskExecutor {
    @Reference
    private PDFProcessor _pdfProcessor;

    protected void generatePreview(FileVersion fileVersion) throws Exception {
        this._pdfProcessor.generateImages(null, fileVersion);
    }

    protected String[] getMimeTypes() {
        return MimeTypesHolder.getMimeTypes();
    }

    private static class MimeTypesHolder {
        private static final List<String> _mimeTypeList = new ArrayList<String>();

        private MimeTypesHolder() {
        }

        public static String[] getMimeTypes() {
            return _mimeTypeList.toArray(new String[0]);
        }

        private static void _populateMimeTypeList(String documentFamily) {
            String[] sourceExtensions;
            Filter filter = new Filter(documentFamily);
            for (String sourceExtension : sourceExtensions = PropsUtil.getArray((String)"openoffice.conversion.source.extensions", (Filter)filter)) {
                String contentType = MimeTypesUtil.getExtensionContentType((String)sourceExtension);
                if (!Validator.isNotNull((String)contentType)) continue;
                _mimeTypeList.add(contentType);
            }
        }

        static {
            MimeTypesHolder._populateMimeTypeList("drawing");
            MimeTypesHolder._populateMimeTypeList("presentation");
            MimeTypesHolder._populateMimeTypeList("spreadsheet");
            MimeTypesHolder._populateMimeTypeList("text");
        }
    }
}

