/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.signatures;

import com.google.gson.JsonPrimitive;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.SignatureException;
import net.oauth.jsontoken.Clock;
import net.oauth.jsontoken.JsonToken;
import net.oauth.jsontoken.crypto.Signer;
import org.joda.time.Duration;

public class SignedJsonAssertionToken
extends JsonToken {
    public static final String JWT = "jwt";
    public static final String GRANT_TYPE = "grant_type";
    public static final String GRANT_TYPE_VALUE = "http://oauth.net/grant_type/jwt/1.0/bearer";
    public static final String SUBJECT = "subject";
    public static final String SCOPE = "scope";
    public static final String NONCE = "nonce";

    public SignedJsonAssertionToken(Signer signer, Clock clock) {
        super(signer, clock);
    }

    public SignedJsonAssertionToken(Signer signer) {
        super(signer);
    }

    public SignedJsonAssertionToken(JsonToken token) {
        super(token.getPayloadAsJsonObject());
    }

    public String getSubject() {
        JsonPrimitive subjectJson = this.getParamAsPrimitive(SUBJECT);
        return subjectJson == null ? null : subjectJson.getAsString();
    }

    public void setSubject(String m) {
        this.setParam(SUBJECT, m);
    }

    public String getScope() {
        JsonPrimitive scopeJson = this.getParamAsPrimitive(SCOPE);
        return scopeJson == null ? null : scopeJson.getAsString();
    }

    public void setScope(String scope) {
        this.setParam(SCOPE, scope);
    }

    public String getNonce() {
        JsonPrimitive nonceJson = this.getParamAsPrimitive(NONCE);
        return nonceJson == null ? null : nonceJson.getAsString();
    }

    public void setNonce(String n) {
        this.setParam(NONCE, n);
    }

    public String getJsonAssertionPostBody() throws SignatureException {
        StringBuffer buffer = new StringBuffer();
        buffer.append(GRANT_TYPE).append("=").append(GRANT_TYPE_VALUE);
        buffer.append("&");
        try {
            buffer.append(JWT).append("=").append(this.serializeAndSign());
            return URLEncoder.encode(buffer.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new SignatureException("unsupported encoding");
        }
    }

    @Override
    public String serializeAndSign() throws SignatureException {
        return super.serializeAndSign();
    }

    @Override
    protected String computeSignatureBaseString() {
        if (this.getIssuedAt() == null) {
            this.setIssuedAt(this.clock.now());
        }
        if (this.getExpiration() == null) {
            this.setExpiration(this.getIssuedAt().plus(Duration.standardMinutes(2L)));
        }
        return super.computeSignatureBaseString();
    }
}

