/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.apache.http.components;

import java.net.URI;
import java.net.URISyntaxException;

public class URIBuilder {
    public static URIBuilderWrapper create(String string) throws URISyntaxException {
        return new URIBuilderWrapper(new URI(string));
    }

    public static URIBuilderWrapper create(URI uri) {
        return new URIBuilderWrapper(uri);
    }

    @FunctionalInterface
    private static interface UnsafeSupplier<String, E extends Throwable> {
        public String get() throws E;
    }

    public static final class URIBuilderWrapper {
        private final org.apache.http.client.utils.URIBuilder _uriBuilder;

        public URIBuilderWrapper(URI uri) {
            this._uriBuilder = new org.apache.http.client.utils.URIBuilder(uri);
        }

        public URIBuilderWrapper addParameter(String name, String value) {
            if (value != null) {
                this._uriBuilder.addParameter(name, value);
            }
            return this;
        }

        public URIBuilderWrapper addParameter(String name, UnsafeSupplier<String, Exception> valueUnsafeSupplier) {
            if (valueUnsafeSupplier == null) {
                return this;
            }
            try {
                String value = valueUnsafeSupplier.get();
                if (value != null) {
                    this._uriBuilder.addParameter(name, value);
                }
                return this;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public URIBuilderWrapper addParameter(UnsafeSupplier<String, Exception> nameUnsafeSupplier, String value) {
            try {
                String name = nameUnsafeSupplier.get();
                if (name != null) {
                    this._uriBuilder.addParameter(name, value);
                }
                return this;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public URIBuilderWrapper addParameter(UnsafeSupplier<String, Exception> nameUnsafeSupplier, UnsafeSupplier<String, Exception> valueUnsafeSupplier) {
            try {
                if (nameUnsafeSupplier != null && valueUnsafeSupplier != null) {
                    String name = nameUnsafeSupplier.get();
                    String value = valueUnsafeSupplier.get();
                    if (name != null && value != null) {
                        this._uriBuilder.addParameter(name, value);
                    }
                }
                return this;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        public URI build() throws URISyntaxException {
            return this._uriBuilder.build();
        }
    }
}

