/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.google.docs.internal.helper;

import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.util.DefaultDDMStructureHelper;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class GoogleDocsDLFileEntryTypeHelper {
    private final Company _company;
    private final DDMStructureLocalService _ddmStructureLocalService;
    private final DefaultDDMStructureHelper _defaultDDMStructureHelper;
    private final long _dlFileEntryMetadataClassNameId;
    private final DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    private final UserLocalService _userLocalService;

    public GoogleDocsDLFileEntryTypeHelper(Company company, DefaultDDMStructureHelper defaultDDMStructureHelper, long dlFileEntryMetadataClassNameId, DDMStructureLocalService ddmStructureLocalService, DLFileEntryTypeLocalService dlFileEntryTypeLocalService, UserLocalService userLocalService) {
        this._company = company;
        this._defaultDDMStructureHelper = defaultDDMStructureHelper;
        this._dlFileEntryMetadataClassNameId = dlFileEntryMetadataClassNameId;
        this._ddmStructureLocalService = ddmStructureLocalService;
        this._dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
        this._userLocalService = userLocalService;
    }

    public void addGoogleDocsDLFileEntryType() throws Exception {
        DLFileEntryType dlFileEntryType;
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(this._company.getGroupId(), this._dlFileEntryMetadataClassNameId, "GOOGLE_DOCS");
        if (ddmStructure == null) {
            ddmStructure = this._addGoogleDocsDDMStructure();
        }
        if ((dlFileEntryType = this._dlFileEntryTypeLocalService.fetchDataDefinitionFileEntryType(this._company.getGroupId(), ddmStructure.getStructureId())) == null) {
            this._addGoogleDocsDLFileEntryType(ddmStructure.getStructureId());
        } else {
            this._updateDLFileEntryTypeNameMap(dlFileEntryType);
        }
    }

    private DDMStructure _addGoogleDocsDDMStructure() throws Exception {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(this._company.getGroupId());
        long defaultUserId = this._userLocalService.getDefaultUserId(this._company.getCompanyId());
        serviceContext.setUserId(defaultUserId);
        Class<?> clazz = this.getClass();
        this._defaultDDMStructureHelper.addDDMStructures(defaultUserId, this._company.getGroupId(), this._dlFileEntryMetadataClassNameId, clazz.getClassLoader(), "com/liferay/document/library/google/docs/internal/util/dependencies/google-docs-metadata-structure.xml", serviceContext);
        DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(this._company.getGroupId(), this._dlFileEntryMetadataClassNameId, "GOOGLE_DOCS");
        ddmStructure.setNameMap(this._updateNameMap(ddmStructure.getNameMap()));
        ddmStructure.setType(1);
        this._ddmStructureLocalService.updateDDMStructure(ddmStructure);
        return ddmStructure;
    }

    private void _addGoogleDocsDLFileEntryType(long ddmStructureId) throws Exception {
        long defaultUserId = this._userLocalService.getDefaultUserId(this._company.getCompanyId());
        HashMap descriptionMap = new HashMap();
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(this._company.getGroupId());
        serviceContext.setUserId(defaultUserId);
        this._dlFileEntryTypeLocalService.addFileEntryType(defaultUserId, this._company.getGroupId(), ddmStructureId, "GOOGLE_DOCS", this._getGoogleDriveShortcutNameMap(LanguageUtil.getAvailableLocales()), descriptionMap, 1, serviceContext);
    }

    private Map<Locale, String> _getGoogleDriveShortcutNameMap(Set<Locale> locales) {
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        for (Locale locale : locales) {
            nameMap.put(locale, LanguageUtil.get((Locale)locale, (String)"google-drive-shortcut"));
        }
        return nameMap;
    }

    private void _updateDLFileEntryTypeNameMap(DLFileEntryType dlFileEntryType) {
        Map nameMap = dlFileEntryType.getNameMap();
        Set availableLocales = LanguageUtil.getAvailableLocales();
        if (nameMap.size() >= availableLocales.size()) {
            return;
        }
        dlFileEntryType.setNameMap(this._getGoogleDriveShortcutNameMap(availableLocales));
        this._dlFileEntryTypeLocalService.updateDLFileEntryType(dlFileEntryType);
    }

    private Map<Locale, String> _updateNameMap(Map<Locale, String> nameMap) {
        HashMap<Locale, String> updatedNameMap = new HashMap<Locale, String>();
        for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
            updatedNameMap.put(entry.getKey(), LanguageUtil.get((Locale)entry.getKey(), (String)"google-docs-metadata"));
        }
        return updatedNameMap;
    }
}

