/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.google.docs.internal.upgrade.v1_0_0;

import com.liferay.document.library.google.drive.configuration.DLGoogleDriveCompanyConfiguration;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.Validator;
import java.util.Dictionary;
import javax.portlet.PortletPreferences;

public class PortletPreferencesUpgradeProcess
extends UpgradeProcess {
    private final ConfigurationProvider _configurationProvider;
    private final PrefsProps _prefsProps;

    public PortletPreferencesUpgradeProcess(ConfigurationProvider configurationProvider, PrefsProps prefsProps) {
        this._configurationProvider = configurationProvider;
        this._prefsProps = prefsProps;
    }

    protected void doUpgrade() throws Exception {
        CompanyLocalServiceUtil.forEachCompanyId(companyId -> {
            DLGoogleDriveCompanyConfiguration dlGoogleDriveCompanyConfiguration = (DLGoogleDriveCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(DLGoogleDriveCompanyConfiguration.class, companyId.longValue());
            PortletPreferences portletPreferences = this._prefsProps.getPreferences(companyId.longValue());
            String apiKey = portletPreferences.getValue("googleAppsAPIKey", "");
            String clientId = portletPreferences.getValue("googleClientId", "");
            if (Validator.isNotNull((String)apiKey) && Validator.isNotNull((String)clientId) && Validator.isNull((String)dlGoogleDriveCompanyConfiguration.clientId()) && Validator.isNull((String)dlGoogleDriveCompanyConfiguration.clientSecret())) {
                this._configurationProvider.saveCompanyConfiguration(DLGoogleDriveCompanyConfiguration.class, companyId.longValue(), (Dictionary)HashMapDictionaryBuilder.put((Object)"clientId", (Object)clientId).put((Object)"pickerAPIKey", (Object)apiKey).build());
            }
        });
    }
}

