/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.google.docs.internal.display.context;

import com.liferay.document.library.display.context.DLUIItemKeys;
import com.liferay.document.library.google.docs.internal.display.context.GoogleDocsUIItemKeys;
import com.liferay.document.library.google.docs.internal.helper.GoogleDocsMetadataHelper;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItemBuilder;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.SetUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;

public class GoogleDocsUIItemsProcessor {
    private final GoogleDocsMetadataHelper _googleDocsMetadataHelper;
    private final HttpServletRequest _httpServletRequest;

    public GoogleDocsUIItemsProcessor(HttpServletRequest httpServletRequest, GoogleDocsMetadataHelper googleDocsMetadataHelper) {
        this._httpServletRequest = httpServletRequest;
        this._googleDocsMetadataHelper = googleDocsMetadataHelper;
    }

    public void processDropdownItems(List<DropdownItem> dropdownItems) {
        this._removeUnsupportedDropdownItems(dropdownItems);
        this._insertEditInGoogleDropdownItem(dropdownItems);
    }

    private <T> int _getIndex(List<T> items, Predicate<T> predicate) {
        for (int i = 0; i < items.size(); ++i) {
            if (!predicate.test(items.get(i))) continue;
            return i;
        }
        return -1;
    }

    private void _insertEditInGoogleDropdownItem(List<DropdownItem> dropdownItems) {
        if (!this._googleDocsMetadataHelper.containsField("URL")) {
            return;
        }
        int index = this._getIndex(dropdownItems, dropdownItem -> Objects.equals(dropdownItem.get((Object)"key"), DLUIItemKeys.EDIT));
        if (index == -1) {
            index = 0;
        }
        dropdownItems.add(index, DropdownItemBuilder.setHref((Object)this._googleDocsMetadataHelper.getFieldValue("URL")).setKey(GoogleDocsUIItemKeys.EDIT_IN_GOOGLE).setLabel(() -> {
            ThemeDisplay themeDisplay = (ThemeDisplay)this._httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            return LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)"edit-in-google-drive");
        }).setTarget("_blank").build());
    }

    private <T> void _removeUIItems(List<T> items, Function<T, String> function, Set<String> keys) {
        Iterator<T> iterator = items.iterator();
        while (iterator.hasNext()) {
            T item = iterator.next();
            if (!keys.contains(function.apply(item))) continue;
            iterator.remove();
        }
    }

    private void _removeUnsupportedDropdownItems(List<DropdownItem> dropdownItems) {
        this._removeUIItems(dropdownItems, dropdownItem -> (String)dropdownItem.get((Object)"key"), SetUtil.fromArray((Object[])new String[]{DLUIItemKeys.CANCEL_CHECKOUT, DLUIItemKeys.CHECKIN, DLUIItemKeys.CHECKOUT, DLUIItemKeys.DOWNLOAD, DLUIItemKeys.OPEN_IN_MS_OFFICE, "#edit-in-google-drive"}));
    }
}

