/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.google.docs.internal.helper;

import com.liferay.counter.kernel.service.CounterLocalServiceUtil;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.document.library.util.DLFileEntryTypeUtil;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.DDMStorageEngineManager;
import com.liferay.dynamic.data.mapping.storage.Field;
import com.liferay.dynamic.data.mapping.storage.Fields;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.service.ServiceContext;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GoogleDocsMetadataHelper {
    private final DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    private final DDMStorageEngineManager _ddmStorageEngineManager;
    private final DDMStructure _ddmStructure;
    private final DDMStructureLocalService _ddmStructureLocalService;
    private DLFileEntryMetadata _dlFileEntryMetadata;
    private final DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;
    private DLFileVersion _dlFileVersion;
    private Fields _fields;
    private Map<String, Field> _fieldsMap;
    private final FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;

    public static DDMStructure getGoogleDocsDDMStructure(DLFileEntryType dlFileEntryType) {
        if (dlFileEntryType == null) {
            return null;
        }
        List ddmStructures = DLFileEntryTypeUtil.getDDMStructures((DLFileEntryType)dlFileEntryType);
        for (DDMStructure ddmStructure : ddmStructures) {
            String structureKey = ddmStructure.getStructureKey();
            if (!structureKey.equals("GOOGLE_DOCS")) continue;
            return ddmStructure;
        }
        return null;
    }

    public GoogleDocsMetadataHelper(DDMFormValuesToFieldsConverter ddmFormValuesToFieldsConverter, DDMStorageEngineManager ddmStorageEngineManager, DDMStructureLocalService ddmStructureLocalService, DLFileEntry dlFileEntry, DLFileEntryMetadataLocalService dlFileEntryMetadataLocalService, FieldsToDDMFormValuesConverter fieldsToDDMFormValuesConverter) {
        try {
            this._ddmFormValuesToFieldsConverter = ddmFormValuesToFieldsConverter;
            this._ddmStorageEngineManager = ddmStorageEngineManager;
            this._ddmStructureLocalService = ddmStructureLocalService;
            this._dlFileEntryMetadataLocalService = dlFileEntryMetadataLocalService;
            this._fieldsToDDMFormValuesConverter = fieldsToDDMFormValuesConverter;
            this._dlFileVersion = dlFileEntry.getFileVersion();
            this._ddmStructure = GoogleDocsMetadataHelper.getGoogleDocsDDMStructure(dlFileEntry.getDLFileEntryType());
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    public GoogleDocsMetadataHelper(DDMFormValuesToFieldsConverter ddmFormValuesToFieldsConverter, DDMStorageEngineManager ddmStorageEngineManager, DDMStructureLocalService ddmStructureLocalService, DLFileVersion dlFileVersion, DLFileEntryMetadataLocalService dlFileEntryMetadataLocalService, FieldsToDDMFormValuesConverter fieldsToDDMFormValuesConverter) {
        this._ddmFormValuesToFieldsConverter = ddmFormValuesToFieldsConverter;
        this._ddmStorageEngineManager = ddmStorageEngineManager;
        this._ddmStructureLocalService = ddmStructureLocalService;
        this._dlFileVersion = dlFileVersion;
        this._dlFileEntryMetadataLocalService = dlFileEntryMetadataLocalService;
        this._fieldsToDDMFormValuesConverter = fieldsToDDMFormValuesConverter;
        try {
            this._ddmStructure = GoogleDocsMetadataHelper.getGoogleDocsDDMStructure(dlFileVersion.getDLFileEntryType());
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
    }

    public boolean containsField(String fieldName) {
        this._initDLFileEntryMetadataAndFields();
        Field field = this._fieldsMap.get(fieldName);
        return field != null;
    }

    public String getFieldValue(String fieldName) {
        Field field = this._getField(fieldName);
        Serializable value = field.getValue();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public boolean isGoogleDocs() {
        return this._ddmStructure != null;
    }

    private void _addGoogleDocsDLFileEntryMetadata() {
        try {
            DLFileEntry dlFileEntry = this._dlFileVersion.getFileEntry();
            this._dlFileEntryMetadata = this._dlFileEntryMetadataLocalService.createDLFileEntryMetadata(CounterLocalServiceUtil.increment());
            long ddmStructureId = this._ddmStructure.getStructureId();
            Fields fields = new Fields();
            fields.put(new Field(ddmStructureId, "DESCRIPTION", (Serializable)((Object)"")));
            fields.put(new Field(ddmStructureId, "EMBEDDABLE_URL", (Serializable)((Object)"")));
            fields.put(new Field(ddmStructureId, "ICON_URL", (Serializable)((Object)"")));
            fields.put(new Field(ddmStructureId, "ID", (Serializable)((Object)"")));
            fields.put(new Field(ddmStructureId, "NAME", (Serializable)((Object)"")));
            fields.put(new Field(ddmStructureId, "URL", (Serializable)((Object)"")));
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAttribute("validateDDMFormValues", (Serializable)Boolean.FALSE);
            serviceContext.setScopeGroupId(this._dlFileVersion.getGroupId());
            serviceContext.setUserId(this._dlFileVersion.getUserId());
            DDMFormValues ddmFormValues = this._toDDMFormValues(fields);
            this._dlFileEntryMetadata.setDDMStorageId(this._ddmStorageEngineManager.create(this._dlFileVersion.getCompanyId(), ddmStructureId, ddmFormValues, serviceContext));
            this._dlFileEntryMetadata.setDDMStructureId(ddmStructureId);
            this._dlFileEntryMetadata.setFileEntryId(dlFileEntry.getFileEntryId());
            this._dlFileEntryMetadata.setFileVersionId(this._dlFileVersion.getFileVersionId());
            this._dlFileEntryMetadata = this._dlFileEntryMetadataLocalService.addDLFileEntryMetadata(this._dlFileEntryMetadata);
        }
        catch (PortalException portalException) {
            throw new SystemException("Unable to add DDM fields for file version " + this._dlFileVersion.getFileVersionId(), (Throwable)portalException);
        }
    }

    private Field _getField(String fieldName) {
        this._initDLFileEntryMetadataAndFields();
        Field field = this._fieldsMap.get(fieldName);
        if (field == null) {
            throw new IllegalArgumentException("Unknown field " + fieldName);
        }
        return field;
    }

    private void _initDLFileEntryMetadataAndFields() {
        if (this._fieldsMap != null || this._dlFileVersion == null) {
            return;
        }
        this._fieldsMap = new HashMap<String, Field>();
        this._dlFileEntryMetadata = this._dlFileEntryMetadataLocalService.fetchFileEntryMetadata(this._ddmStructure.getStructureId(), this._dlFileVersion.getFileVersionId());
        if (this._dlFileEntryMetadata == null) {
            this._addGoogleDocsDLFileEntryMetadata();
        }
        try {
            this._fields = this._ddmFormValuesToFieldsConverter.convert(this._ddmStructureLocalService.getDDMStructure(this._ddmStructure.getStructureId()), this._ddmStorageEngineManager.getDDMFormValues(this._dlFileEntryMetadata.getDDMStorageId()));
            for (Field field : this._fields) {
                this._fieldsMap.put(field.getName(), field);
            }
        }
        catch (PortalException portalException) {
            throw new SystemException("Unable to load DDM fields for file version " + this._dlFileVersion.getFileVersionId(), (Throwable)portalException);
        }
    }

    private DDMFormValues _toDDMFormValues(Fields fields) throws PortalException {
        return this._fieldsToDDMFormValuesConverter.convert(this._ddmStructureLocalService.getDDMStructure(this._ddmStructure.getStructureId()), fields);
    }
}

