/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.google.docs.internal.upgrade.v2_0_0;

import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;

public class DLFileEntryTypeUpgradeProcess
extends UpgradeProcess {
    private final ClassNameLocalService _classNameLocalService;
    private final DDMStructureLocalService _ddmStructureLocalService;
    private final DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;

    public DLFileEntryTypeUpgradeProcess(ClassNameLocalService classNameLocalService, DDMStructureLocalService ddmStructureLocalService, DLFileEntryTypeLocalService dlFileEntryTypeLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._ddmStructureLocalService = ddmStructureLocalService;
        this._dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
    }

    protected void doUpgrade() throws Exception {
        try {
            ActionableDynamicQuery actionableDynamicQuery = this._dlFileEntryTypeLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"fileEntryTypeKey", (Object)"GOOGLE_DOCS")));
            actionableDynamicQuery.setPerformActionMethod(dlFileEntryType -> {
                dlFileEntryType.setScope(1);
                this._dlFileEntryTypeLocalService.updateDLFileEntryType(dlFileEntryType);
                DDMStructure ddmStructure = this._ddmStructureLocalService.getStructure(dlFileEntryType.getGroupId(), this._classNameLocalService.getClassNameId(DLFileEntryMetadata.class), "GOOGLE_DOCS");
                ddmStructure.setType(1);
                this._ddmStructureLocalService.updateDDMStructure(ddmStructure);
            });
            actionableDynamicQuery.performActions();
        }
        catch (PortalException portalException) {
            throw new UpgradeException((Throwable)portalException);
        }
    }
}

