Liferay.Loader.define('document-library-preview-image$lodash-es@4.17.15/_shuffleSelf', ['module', 'exports', 'require'], function (module, exports, require) {
    var define = undefined;
    var global = window;
    {
        import baseRandom from './_baseRandom.js';

        /**
         * A specialized version of `_.shuffle` which mutates and sets the size of `array`.
         *
         * @private
         * @param {Array} array The array to shuffle.
         * @param {number} [size=array.length] The size of `array`.
         * @returns {Array} Returns `array`.
         */
        function shuffleSelf(array, size) {
            var index = -1,
                length = array.length;

            size = size === undefined ? length : size;
            while (++index < size) {
                var rand = baseRandom(index, length - 1),
                    value = array[rand];

                array[rand] = array[index];
                array[index] = value;
            }
            array.length = size;
            return array;
        }

        export default shuffleSelf;
    }
});
//# sourceMappingURL=_shuffleSelf.js.map