/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.cmis;

import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.repository.cmis.BaseCmisRepository;
import com.liferay.document.library.repository.cmis.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.BaseRepository;
import com.liferay.portal.kernel.repository.BaseRepositoryImpl;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.util.Date;
import java.util.List;
import java.util.Map;

public abstract class CMISRepositoryHandler
extends BaseRepositoryImpl
implements Capability {
    private BaseCmisRepository _baseCmisRepository;

    public FileEntry addFileEntry(String externalReferenceCode, long userId, long folderId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, InputStream inputStream, long size, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        return this._baseCmisRepository.addFileEntry(externalReferenceCode, userId, folderId, sourceFileName, mimeType, title, urlTitle, description, changeLog, inputStream, size, expirationDate, reviewDate, serviceContext);
    }

    public FileShortcut addFileShortcut(long userId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        return this._baseCmisRepository.addFileShortcut(userId, folderId, toFileEntryId, serviceContext);
    }

    public Folder addFolder(String externalReferenceCode, long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this._baseCmisRepository.addFolder(externalReferenceCode, userId, parentFolderId, name, description, serviceContext);
    }

    public FileVersion cancelCheckOut(long fileEntryId) throws PortalException {
        return this._baseCmisRepository.cancelCheckOut(fileEntryId);
    }

    public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
        this._baseCmisRepository.checkInFileEntry(userId, fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
    }

    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        this._baseCmisRepository.checkInFileEntry(userId, fileEntryId, lockUuid, serviceContext);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        return this._baseCmisRepository.checkOutFileEntry(fileEntryId, serviceContext);
    }

    public FileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        return this._baseCmisRepository.checkOutFileEntry(fileEntryId, owner, expirationTime, serviceContext);
    }

    public FileEntry copyFileEntry(long userId, long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        return this._baseCmisRepository.copyFileEntry(userId, groupId, fileEntryId, destFolderId, serviceContext);
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        this._baseCmisRepository.deleteFileEntry(fileEntryId);
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        this._baseCmisRepository.deleteFileShortcut(fileShortcutId);
    }

    public void deleteFileShortcuts(long toFileEntryId) throws PortalException {
        this._baseCmisRepository.deleteFileShortcuts(toFileEntryId);
    }

    public void deleteFolder(long folderId) throws PortalException {
        this._baseCmisRepository.deleteFolder(folderId);
    }

    public BaseRepository getCmisRepository() {
        return this._baseCmisRepository;
    }

    public List<FileEntry> getFileEntries(long folderId, int status, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return this._baseCmisRepository.getFileEntries(folderId, status, start, end, orderByComparator);
    }

    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return this._baseCmisRepository.getFileEntries(folderId, start, end, orderByComparator);
    }

    public List<FileEntry> getFileEntries(long folderId, long fileEntryTypeId, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return this._baseCmisRepository.getFileEntries(folderId, fileEntryTypeId, start, end, orderByComparator);
    }

    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int start, int end, OrderByComparator<FileEntry> orderByComparator) throws PortalException {
        return this._baseCmisRepository.getFileEntries(folderId, mimeTypes, start, end, orderByComparator);
    }

    public int getFileEntriesCount(long folderId) throws PortalException {
        return this._baseCmisRepository.getFileEntriesCount(folderId);
    }

    public int getFileEntriesCount(long folderId, int status) throws PortalException {
        return this._baseCmisRepository.getFileEntriesCount(folderId, status);
    }

    public int getFileEntriesCount(long folderId, long fileEntryTypeId) throws PortalException {
        return this._baseCmisRepository.getFileEntriesCount(folderId, fileEntryTypeId);
    }

    public int getFileEntriesCount(long folderId, String[] mimeTypes) throws PortalException {
        return this._baseCmisRepository.getFileEntriesCount(folderId, mimeTypes);
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        return this._baseCmisRepository.getFileEntry(fileEntryId);
    }

    public FileEntry getFileEntry(long folderId, String title) throws PortalException {
        return this._baseCmisRepository.getFileEntry(folderId, title);
    }

    public FileEntry getFileEntryByUuid(String uuid) throws PortalException {
        return this._baseCmisRepository.getFileEntryByUuid(uuid);
    }

    public FileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        return this._baseCmisRepository.getFileShortcut(fileShortcutId);
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        return this._baseCmisRepository.getFileVersion(fileVersionId);
    }

    public Folder getFolder(long folderId) throws PortalException {
        return this._baseCmisRepository.getFolder(folderId);
    }

    public Folder getFolder(long parentFolderId, String name) throws PortalException {
        return this._baseCmisRepository.getFolder(parentFolderId, name);
    }

    public List<Folder> getFolders(long parentFolderId, boolean includeMountfolders, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        return this._baseCmisRepository.getFolders(parentFolderId, includeMountfolders, start, end, orderByComparator);
    }

    public List<Object> getFoldersAndFileEntries(long folderId, int start, int end, OrderByComparator<?> orderByComparator) {
        return this._baseCmisRepository.getFoldersAndFileEntries(folderId, start, end, orderByComparator);
    }

    public List<Object> getFoldersAndFileEntries(long folderId, String[] mimeTypes, int start, int end, OrderByComparator<?> orderByComparator) throws PortalException {
        return this._baseCmisRepository.getFoldersAndFileEntries(folderId, mimeTypes, start, end, orderByComparator);
    }

    public int getFoldersAndFileEntriesCount(long folderId) {
        return this._baseCmisRepository.getFoldersAndFileEntriesCount(folderId);
    }

    public int getFoldersAndFileEntriesCount(long folderId, String[] mimeTypes) throws PortalException {
        return this._baseCmisRepository.getFoldersAndFileEntriesCount(folderId, mimeTypes);
    }

    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) throws PortalException {
        return this._baseCmisRepository.getFoldersCount(parentFolderId, includeMountfolders);
    }

    public int getFoldersFileEntriesCount(List<Long> folderIds, int status) throws PortalException {
        return this._baseCmisRepository.getFoldersFileEntriesCount(folderIds, status);
    }

    public String getLatestVersionId(String objectId) {
        return this._baseCmisRepository.getLatestVersionId(objectId);
    }

    public String getLogin() {
        String login = PrincipalThreadLocal.getName();
        if (Validator.isNull((String)login)) {
            return login;
        }
        try {
            Company company = this.companyLocalService.getCompany(this.getCompanyId());
            String authType = company.getAuthType();
            if (!authType.equals("userId")) {
                User user = this.userLocalService.getUser(GetterUtil.getLong((String)login));
                if (authType.equals("emailAddress")) {
                    login = user.getEmailAddress();
                } else if (authType.equals("screenName")) {
                    login = user.getScreenName();
                }
            }
        }
        catch (Exception exception) {
            throw new RepositoryException((Throwable)exception);
        }
        return login;
    }

    public List<Folder> getMountFolders(long parentFolderId, int start, int end, OrderByComparator<Folder> orderByComparator) throws PortalException {
        return this._baseCmisRepository.getMountFolders(parentFolderId, start, end, orderByComparator);
    }

    public int getMountFoldersCount(long parentFolderId) throws PortalException {
        return this._baseCmisRepository.getMountFoldersCount(parentFolderId);
    }

    public String getObjectName(String objectId) throws PortalException {
        return this._baseCmisRepository.getObjectName(objectId);
    }

    public List<String> getObjectPaths(String objectId) throws PortalException {
        return this._baseCmisRepository.getObjectPaths(objectId);
    }

    public abstract Session getSession() throws PortalException;

    public void getSubfolderIds(List<Long> folderIds, long folderId) throws PortalException {
        this._baseCmisRepository.getSubfolderIds(folderIds, folderId);
    }

    public List<Long> getSubfolderIds(long folderId, boolean recurse) throws PortalException {
        return this._baseCmisRepository.getSubfolderIds(folderId, recurse);
    }

    public void initRepository() throws PortalException {
        this._baseCmisRepository.initRepository();
    }

    public boolean isCancelCheckOutAllowable(String objectId) throws PortalException {
        return this._baseCmisRepository.isCancelCheckOutAllowable(objectId);
    }

    public boolean isCheckInAllowable(String objectId) throws PortalException {
        return this._baseCmisRepository.isCheckInAllowable(objectId);
    }

    public boolean isCheckOutAllowable(String objectId) throws PortalException {
        return this._baseCmisRepository.isCheckOutAllowable(objectId);
    }

    public boolean isDocumentRetrievableByVersionSeriesId() {
        return true;
    }

    public boolean isRefreshBeforePermissionCheck() {
        return false;
    }

    public boolean isSupportsMinorVersions(String productName) {
        return !(productName = StringUtil.toLowerCase((String)productName)).contains("filenet") || !productName.contains("p8");
    }

    public Lock lockFolder(long folderId) throws PortalException {
        return this._baseCmisRepository.lockFolder(folderId);
    }

    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException {
        return this._baseCmisRepository.lockFolder(folderId, owner, inheritable, expirationTime);
    }

    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        return this._baseCmisRepository.moveFileEntry(userId, fileEntryId, newFolderId, serviceContext);
    }

    public Folder moveFolder(long userId, long folderId, long newParentFolderId, ServiceContext serviceContext) throws PortalException {
        return this._baseCmisRepository.moveFolder(userId, folderId, newParentFolderId, serviceContext);
    }

    public Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        return this._baseCmisRepository.refreshFileEntryLock(lockUuid, companyId, expirationTime);
    }

    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        return this._baseCmisRepository.refreshFolderLock(lockUuid, companyId, expirationTime);
    }

    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        this._baseCmisRepository.revertFileEntry(userId, fileEntryId, version, serviceContext);
    }

    public Hits search(long creatorUserId, int status, int start, int end) throws PortalException {
        return this._baseCmisRepository.search(creatorUserId, status, start, end);
    }

    public Hits search(long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) throws PortalException {
        return this._baseCmisRepository.search(creatorUserId, folderId, mimeTypes, status, start, end);
    }

    public Hits search(SearchContext searchContext) throws SearchException {
        return this._baseCmisRepository.search(searchContext);
    }

    public Hits search(SearchContext searchContext, Query query) throws SearchException {
        return this._baseCmisRepository.search(searchContext, query);
    }

    public void setCmisRepository(BaseCmisRepository baseCmisRepository) {
        this._baseCmisRepository = baseCmisRepository;
    }

    public FileEntry toFileEntry(String objectId) throws PortalException {
        return this._baseCmisRepository.toFileEntry(objectId);
    }

    public Folder toFolder(String objectId) throws PortalException {
        return this._baseCmisRepository.toFolder(objectId);
    }

    public void unlockFolder(long folderId, String lockUuid) throws PortalException {
        this._baseCmisRepository.unlockFolder(folderId, lockUuid);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String urlTitle, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream inputStream, long size, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        return this._baseCmisRepository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, urlTitle, description, changeLog, dlVersionNumberIncrease, inputStream, size, expirationDate, reviewDate, serviceContext);
    }

    public FileEntry updateFileEntry(String objectId, String mimeType, Map<String, Object> properties, InputStream inputStream, String sourceFileName, long size, Date expirationDate, Date reviewDate, ServiceContext serviceContext) throws PortalException {
        return this._baseCmisRepository.updateFileEntry(objectId, mimeType, properties, inputStream, sourceFileName, size, expirationDate, reviewDate, serviceContext);
    }

    public FileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        return this._baseCmisRepository.updateFileShortcut(userId, fileShortcutId, folderId, toFileEntryId, serviceContext);
    }

    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) throws PortalException {
        this._baseCmisRepository.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
    }

    public Folder updateFolder(long folderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        return this._baseCmisRepository.updateFolder(folderId, name, description, serviceContext);
    }

    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) throws PortalException {
        return this._baseCmisRepository.verifyFileEntryCheckOut(fileEntryId, lockUuid);
    }

    public boolean verifyInheritableLock(long folderId, String lockUuid) throws PortalException {
        return this._baseCmisRepository.verifyInheritableLock(folderId, lockUuid);
    }
}

