/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.cmis.internal.model;

import com.liferay.document.library.repository.cmis.internal.CMISRepository;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.enums.Action;

public abstract class CMISModel {
    private static final Map<String, Action> _mappedActionKeys = HashMapBuilder.put((Object)"ACCESS", (Object)Action.CAN_GET_FOLDER_TREE).put((Object)"ADD_DISCUSSION", (Object)Action.CAN_GET_PROPERTIES).put((Object)"ADD_DOCUMENT", (Object)Action.CAN_CREATE_DOCUMENT).put((Object)"ADD_FOLDER", (Object)Action.CAN_CREATE_FOLDER).put((Object)"ADD_SUBFOLDER", (Object)Action.CAN_CREATE_FOLDER).put((Object)"DELETE", (Object)Action.CAN_DELETE_OBJECT).put((Object)"DELETE_DISCUSSION", (Object)Action.CAN_DELETE_OBJECT).put((Object)"UPDATE", (Object)Action.CAN_UPDATE_PROPERTIES).put((Object)"UPDATE_DISCUSSION", (Object)Action.CAN_UPDATE_PROPERTIES).put((Object)"VIEW", (Object)Action.CAN_GET_PROPERTIES).build();
    private static final Set<String> _unsupportedActionKeys = new HashSet<String>(Arrays.asList("ADD_SHORTCUT", "OVERRIDE_CHECKOUT", "PERMISSIONS", "SUBSCRIBE"));
    private Folder _parentFolder;

    public abstract long getCompanyId();

    public String getDescription() {
        return "";
    }

    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge((long)this.getCompanyId(), (String)this.getModelClassName(), (long)this.getPrimaryKey());
    }

    public abstract String getModelClassName();

    public abstract long getPrimaryKey();

    public void setParentFolder(Folder parentFolder) {
        this._parentFolder = parentFolder;
    }

    protected boolean containsPermission(CmisObject cmisObject, String actionId) throws RepositoryException {
        CMISRepository cmisRepository = this.getCmisRepository();
        if (cmisRepository.isRefreshBeforePermissionCheck()) {
            cmisObject.refresh();
        }
        if (_unsupportedActionKeys.contains(actionId)) {
            return false;
        }
        Action action = _mappedActionKeys.get(actionId);
        if (action == null) {
            throw new RepositoryException("Unexpected permission action " + actionId);
        }
        AllowableActions allowableActions = cmisObject.getAllowableActions();
        Set allowableActionsSet = allowableActions.getAllowableActions();
        return allowableActionsSet.contains(action);
    }

    protected abstract CMISRepository getCmisRepository();

    protected Folder getParentFolder() throws PortalException {
        return this._parentFolder;
    }

    protected User getUser(String createdBy) {
        User user = null;
        try {
            Company company = CompanyLocalServiceUtil.getCompany((long)this.getCompanyId());
            String authType = company.getAuthType();
            if (authType.equals("userId")) {
                user = UserLocalServiceUtil.getUser((long)GetterUtil.getLong((String)createdBy));
            } else if (authType.equals("emailAddress")) {
                user = UserLocalServiceUtil.getUserByEmailAddress((long)this.getCompanyId(), (String)createdBy);
            } else if (authType.equals("screenName")) {
                user = UserLocalServiceUtil.getUserByScreenName((long)this.getCompanyId(), (String)createdBy);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (user == null) {
            try {
                user = UserLocalServiceUtil.getDefaultUser((long)this.getCompanyId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return user;
    }
}

