/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.cmis.internal.model;

import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.repository.cmis.internal.CMISRepository;
import com.liferay.document.library.repository.cmis.internal.CMISRepositoryDetector;
import com.liferay.document.library.repository.cmis.internal.model.BaseCMISModel;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.ObjectType;
import org.apache.chemistry.opencmis.client.api.Session;

public class CMISFolder
extends BaseCMISModel
implements Folder {
    private static final Log _log = LogFactoryUtil.getLog(CMISFolder.class);
    private final org.apache.chemistry.opencmis.client.api.Folder _cmisFolder;
    private final CMISRepository _cmisRepository;
    private long _folderId;
    private final String _uuid;

    public CMISFolder(CMISRepository cmisRepository, String uuid, long folderId, org.apache.chemistry.opencmis.client.api.Folder cmisFolder) {
        this._cmisRepository = cmisRepository;
        this._uuid = uuid;
        this._folderId = folderId;
        this._cmisFolder = cmisFolder;
    }

    public Object clone() {
        CMISFolder cmisFolder;
        block2: {
            cmisFolder = new CMISFolder(this._cmisRepository, this._uuid, this._folderId, this._cmisFolder);
            cmisFolder.setCompanyId(this.getCompanyId());
            cmisFolder.setFolderId(this.getFolderId());
            cmisFolder.setGroupId(this.getGroupId());
            try {
                cmisFolder.setParentFolder(this.getParentFolder());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)exception);
            }
        }
        cmisFolder.setPrimaryKey(this.getPrimaryKey());
        return cmisFolder;
    }

    public boolean containsPermission(PermissionChecker permissionChecker, String actionId) {
        CMISRepositoryDetector cmisRepositoryDetector = this._cmisRepository.getCMISRepositoryDetector();
        ObjectType objectType = this._cmisFolder.getType();
        if (cmisRepositoryDetector.isNuxeo() && !Objects.equals(objectType.getId(), "Workspace") && Objects.equals("ADD_DOCUMENT", actionId)) {
            return false;
        }
        if (this._cmisFolder.isRootFolder() && (actionId.equals("DELETE") || actionId.equals("UPDATE"))) {
            try {
                Folder folder = DLAppLocalServiceUtil.getMountFolder((long)this.getRepositoryId());
                return folder.containsPermission(permissionChecker, actionId);
            }
            catch (PortalException portalException) {
                throw new SystemException((Throwable)portalException);
            }
        }
        return this.containsPermission((CmisObject)this._cmisFolder, actionId);
    }

    public void execute(RepositoryModelOperation repositoryModelOperation) throws PortalException {
        repositoryModelOperation.execute((Folder)this);
    }

    public List<Long> getAncestorFolderIds() throws PortalException {
        ArrayList<Long> folderIds = new ArrayList<Long>();
        CMISFolder folder = this;
        while (!folder.isRoot()) {
            folder = folder.getParentFolder();
            folderIds.add(folder.getFolderId());
        }
        return folderIds;
    }

    public List<Folder> getAncestors() throws PortalException {
        ArrayList<Folder> folders = new ArrayList<Folder>();
        CMISFolder folder = this;
        while (!folder.isRoot()) {
            folder = folder.getParentFolder();
            folders.add(folder);
        }
        return folders;
    }

    public Map<String, Serializable> getAttributes() {
        return new HashMap<String, Serializable>();
    }

    @Override
    public long getCompanyId() {
        return this._cmisRepository.getCompanyId();
    }

    public Date getCreateDate() {
        GregorianCalendar calendar = this._cmisFolder.getCreationDate();
        if (calendar != null) {
            return calendar.getTime();
        }
        return new Date();
    }

    public long getFolderId() {
        return this._folderId;
    }

    public long getGroupId() {
        return this._cmisRepository.getGroupId();
    }

    public Date getLastPostDate() {
        return this.getModifiedDate();
    }

    public Date getLastPublishDate() {
        return null;
    }

    public Object getModel() {
        return this._cmisFolder;
    }

    public Class<?> getModelClass() {
        return CMISFolder.class;
    }

    @Override
    public String getModelClassName() {
        return CMISFolder.class.getName();
    }

    public Date getModifiedDate() {
        GregorianCalendar calendar = this._cmisFolder.getLastModificationDate();
        if (calendar != null) {
            return calendar.getTime();
        }
        return new Date();
    }

    public String getName() {
        if (this._cmisFolder.isRootFolder()) {
            try {
                Folder folder = DLAppLocalServiceUtil.getMountFolder((long)this.getRepositoryId());
                return folder.getName();
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
        }
        return this._cmisFolder.getName();
    }

    @Override
    public Folder getParentFolder() throws PortalException {
        Folder parentFolder;
        block6: {
            parentFolder = null;
            try {
                parentFolder = super.getParentFolder();
                if (parentFolder != null) {
                    return parentFolder;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Throwable)exception);
            }
        }
        if (this._cmisFolder.isRootFolder()) {
            Folder folder = DLAppLocalServiceUtil.getMountFolder((long)this.getRepositoryId());
            parentFolder = folder.getParentFolder();
        } else {
            Session session = this._cmisRepository.getSession();
            String path = this._cmisFolder.getPath();
            if ((path = path.substring(0, path.lastIndexOf(47))).length() == 0) {
                path = "/";
            }
            CmisObject parentCmisFolder = session.getObjectByPath(path);
            parentFolder = this._cmisRepository.toFolder((org.apache.chemistry.opencmis.client.api.Folder)parentCmisFolder);
        }
        this.setParentFolder(parentFolder);
        return parentFolder;
    }

    public long getParentFolderId() {
        try {
            Folder parentFolder = this.getParentFolder();
            if (parentFolder != null) {
                return parentFolder.getFolderId();
            }
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return 0L;
    }

    @Override
    public long getPrimaryKey() {
        return this._folderId;
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    public <T extends Capability> T getRepositoryCapability(Class<T> capabilityClass) {
        Repository repository = this._getRepository();
        return (T)repository.getCapability(capabilityClass);
    }

    public long getRepositoryId() {
        return this._cmisRepository.getRepositoryId();
    }

    public StagedModelType getStagedModelType() {
        return new StagedModelType(DLFolderConstants.getClassName());
    }

    public long getUserId() {
        User user = this.getUser(this._cmisFolder.getCreatedBy());
        if (user == null) {
            return 0L;
        }
        return user.getUserId();
    }

    public String getUserName() {
        User user = this.getUser(this._cmisFolder.getCreatedBy());
        if (user == null) {
            return "";
        }
        return user.getFullName();
    }

    public String getUserUuid() {
        User user = this.getUser(this._cmisFolder.getCreatedBy());
        try {
            return user.getUserUuid();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return "";
        }
    }

    public String getUuid() {
        return this._uuid;
    }

    public boolean hasInheritableLock() {
        return false;
    }

    public boolean hasLock() {
        return false;
    }

    public boolean isDefaultRepository() {
        return false;
    }

    public boolean isEscapedModel() {
        return false;
    }

    public boolean isLocked() {
        return false;
    }

    public boolean isMountPoint() {
        return false;
    }

    public <T extends Capability> boolean isRepositoryCapabilityProvided(Class<T> capabilityClass) {
        Repository repository = this._getRepository();
        return repository.isCapabilityProvided(capabilityClass);
    }

    public boolean isRoot() {
        return this.getParentFolderId() == 0L;
    }

    public boolean isSupportsLocking() {
        return true;
    }

    public boolean isSupportsMetadata() {
        return false;
    }

    public boolean isSupportsMultipleUpload() {
        return false;
    }

    public boolean isSupportsShortcuts() {
        return false;
    }

    public boolean isSupportsSocial() {
        return false;
    }

    public boolean isSupportsSubscribing() {
        return false;
    }

    public void setCompanyId(long companyId) {
        this._cmisRepository.setCompanyId(companyId);
    }

    public void setCreateDate(Date createDate) {
    }

    public void setFolderId(long folderId) {
        this._folderId = folderId;
    }

    public void setGroupId(long groupId) {
        this._cmisRepository.setGroupId(groupId);
    }

    public void setLastPublishDate(Date lastPublishDate) {
    }

    public void setModifiedDate(Date modifiedDate) {
    }

    public void setPrimaryKey(long primaryKey) {
        this.setFolderId(primaryKey);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        Long primaryKeyLong = (Long)primaryKeyObj;
        this.setPrimaryKey(primaryKeyLong);
    }

    public void setUserId(long userId) {
    }

    public void setUserName(String userName) {
    }

    public void setUserUuid(String userUuid) {
    }

    public void setUuid(String uuid) {
    }

    public Folder toEscapedModel() {
        return this;
    }

    public Folder toUnescapedModel() {
        return this;
    }

    @Override
    protected CMISRepository getCmisRepository() {
        return this._cmisRepository;
    }

    private Repository _getRepository() {
        try {
            return RepositoryProviderUtil.getRepository((long)this.getRepositoryId());
        }
        catch (PortalException portalException) {
            throw new SystemException("Unable to get repository for folder " + this.getFolderId(), (Throwable)portalException);
        }
    }
}

