/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.external;

import com.liferay.document.library.repository.external.ExtRepositoryModel;
import com.liferay.document.library.repository.external.model.ExtRepositoryModelAdapter;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.HashMap;
import java.util.Map;

public class ExtRepositoryAdapterCache
implements Cloneable {
    private static final Log _log = LogFactoryUtil.getLog(ExtRepositoryAdapterCache.class);
    private static final ThreadLocal<ExtRepositoryAdapterCache> _extRepositoryAdapterThreadLocal = new CentralizedThreadLocal(ExtRepositoryAdapterCache.class.getName(), ExtRepositoryAdapterCache::new);
    private final Map<String, ExtRepositoryModelAdapter<?>> _extRepositoryAdapters = new HashMap();

    public static ExtRepositoryAdapterCache getInstance() {
        return _extRepositoryAdapterThreadLocal.get();
    }

    public void clear() {
        this._extRepositoryAdapters.clear();
    }

    public ExtRepositoryAdapterCache clone() {
        if (_log.isInfoEnabled()) {
            Thread currentThread = Thread.currentThread();
            _log.info((Object)("Create " + currentThread.getName()));
        }
        try {
            return (ExtRepositoryAdapterCache)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public <T extends ExtRepositoryModelAdapter<?>> T get(String extRepositoryModelKey) {
        ExtRepositoryModelAdapter<?> extRepositoryAdapter = this._extRepositoryAdapters.get(extRepositoryModelKey);
        if (extRepositoryAdapter != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Hit " + extRepositoryModelKey));
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Miss " + extRepositoryModelKey));
        }
        return (T)extRepositoryAdapter;
    }

    public void put(ExtRepositoryModelAdapter<?> extRepositoryModelAdapter) {
        ExtRepositoryModel extRepositoryModel = extRepositoryModelAdapter.getExtRepositoryModel();
        String extRepositoryModelKey = extRepositoryModel.getExtRepositoryModelKey();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Put " + extRepositoryModelKey));
        }
        this._extRepositoryAdapters.put(extRepositoryModelKey, extRepositoryModelAdapter);
    }

    public void remove(String extRepositoryModelKey) {
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Remove " + extRepositoryModelKey));
        }
        this._extRepositoryAdapters.remove(extRepositoryModelKey);
    }
}

