/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.external;

import com.liferay.document.library.repository.external.ExtRepositoryAdapter;
import com.liferay.document.library.repository.external.search.ExtRepositoryQueryMapper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;

public class ExtRepositoryQueryMapperImpl
implements ExtRepositoryQueryMapper {
    private static final String _INDEX_DATE_FORMAT_PATTERN = PropsUtil.get((String)"index.date.format.pattern");
    private final ExtRepositoryAdapter _extRepositoryAdapter;

    public ExtRepositoryQueryMapperImpl(ExtRepositoryAdapter extRepositoryAdapter) {
        this._extRepositoryAdapter = extRepositoryAdapter;
    }

    @Override
    public Date formatDateParameterValue(String fieldName, String fieldValue) throws SearchException {
        if (fieldName.equals("createDate") || fieldName.equals("modified")) {
            try {
                DateFormat searchSimpleDateFormat = DateFormatFactoryUtil.getSimpleDateFormat((String)_INDEX_DATE_FORMAT_PATTERN);
                return searchSimpleDateFormat.parse(fieldValue);
            }
            catch (ParseException parseException) {
                throw new SearchException(StringBundler.concat((String[])new String[]{"Unable to parse date ", fieldValue, " for field ", fieldName}), (Throwable)parseException);
            }
        }
        throw new SearchException("Field " + fieldName + " is not a date");
    }

    @Override
    public String formatParameterValue(String fieldName, String fieldValue) throws SearchException {
        if (fieldName.equals("createDate") || fieldName.equals("modified")) {
            throw new SearchException("Use the method formatDateParameterValue to format the date field " + fieldName);
        }
        if (fieldName.equals("folderId")) {
            try {
                long folderId = GetterUtil.getLong((String)fieldValue);
                return this._extRepositoryAdapter.getExtRepositoryObjectKey(folderId);
            }
            catch (PortalException portalException) {
                throw new SearchException("Unable to get folder folder " + fieldValue, (Throwable)portalException);
            }
            catch (SystemException systemException) {
                throw new SearchException("Unable to get folder folder " + fieldValue, (Throwable)systemException);
            }
        }
        if (fieldName.equals("userId")) {
            try {
                long userId = GetterUtil.getLong((String)fieldValue);
                User user = UserLocalServiceUtil.getUserById((long)userId);
                return user.getScreenName();
            }
            catch (Exception exception) {
                throw new SearchException("Unable to get user user " + fieldValue, (Throwable)exception);
            }
        }
        return fieldValue;
    }
}

