/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.atom;

import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.util.comparator.FolderNameComparator;
import com.liferay.portal.atom.AtomPager;
import com.liferay.portal.atom.AtomUtil;
import com.liferay.portal.kernel.atom.AtomCollectionAdapter;
import com.liferay.portal.kernel.atom.AtomEntryContent;
import com.liferay.portal.kernel.atom.AtomRequestContext;
import com.liferay.portal.kernel.atom.BaseAtomCollectionAdapter;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.portal.kernel.repository.model.Folder"}, service={AtomCollectionAdapter.class})
public class FolderAtomCollectionAdapter
extends BaseAtomCollectionAdapter<Folder> {
    private static final String _COLLECTION_NAME = "folders";
    private DLAppService _dlAppService;

    public String getCollectionName() {
        return _COLLECTION_NAME;
    }

    public List<String> getEntryAuthors(Folder folder) {
        return ListUtil.fromArray((Object[])new String[]{folder.getUserName()});
    }

    public AtomEntryContent getEntryContent(Folder folder, AtomRequestContext atomRequestContext) {
        AtomEntryContent atomEntryContent = new AtomEntryContent(AtomEntryContent.Type.XML);
        String srcLink = AtomUtil.createCollectionLink((AtomRequestContext)atomRequestContext, (String)"files");
        srcLink = srcLink + "?folderId=" + folder.getFolderId();
        atomEntryContent.setSrcLink(srcLink);
        return atomEntryContent;
    }

    public String getEntryId(Folder folder) {
        return String.valueOf(folder.getPrimaryKey());
    }

    public String getEntrySummary(Folder folder) {
        return folder.getDescription();
    }

    public String getEntryTitle(Folder folder) {
        return folder.getName();
    }

    public Date getEntryUpdated(Folder folder) {
        return folder.getModifiedDate();
    }

    public String getFeedTitle(AtomRequestContext atomRequestContext) {
        String portletId = PortletProviderUtil.getPortletId((String)Folder.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        String feedTitleFromPortletName = AtomUtil.createFeedTitleFromPortletName((AtomRequestContext)atomRequestContext, (String)portletId);
        return feedTitleFromPortletName + " folders";
    }

    protected void doDeleteEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long folderEntryId = GetterUtil.getLong((String)resourceName);
        this._dlAppService.deleteFolder(folderEntryId);
    }

    protected Folder doGetEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long folderEntryId = GetterUtil.getLong((String)resourceName);
        return this._dlAppService.getFolder(folderEntryId);
    }

    protected Iterable<Folder> doGetFeedEntries(AtomRequestContext atomRequestContext) throws Exception {
        long repositoryId = 0L;
        long parentFolderId = atomRequestContext.getLongParameter("parentFolderId");
        if (parentFolderId != 0L) {
            Folder parentFolder = this._dlAppService.getFolder(parentFolderId);
            repositoryId = parentFolder.getRepositoryId();
        } else {
            repositoryId = atomRequestContext.getLongParameter("repositoryId");
        }
        int count = this._dlAppService.getFoldersCount(repositoryId, parentFolderId);
        AtomPager atomPager = new AtomPager(atomRequestContext, count);
        AtomUtil.saveAtomPagerInRequest((AtomRequestContext)atomRequestContext, (AtomPager)atomPager);
        return this._dlAppService.getFolders(repositoryId, parentFolderId, atomPager.getStart(), atomPager.getEnd() + 1, (OrderByComparator)new FolderNameComparator());
    }

    protected Folder doPostEntry(String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        long repositoryId = 0L;
        long parentFolderId = atomRequestContext.getLongParameter("parentFolderId");
        if (parentFolderId != 0L) {
            Folder parentFolder = this._dlAppService.getFolder(parentFolderId);
            repositoryId = parentFolder.getRepositoryId();
        } else {
            repositoryId = atomRequestContext.getLongParameter("repositoryId");
        }
        return this._dlAppService.addFolder(repositoryId, parentFolderId, title, summary, new ServiceContext());
    }

    protected void doPutEntry(Folder folder, String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        this._dlAppService.updateFolder(folder.getFolderId(), title, summary, new ServiceContext());
    }

    @Reference(unbind="-")
    protected void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }
}

