/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.instance.lifecycle;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.kernel.util.RawMetadataProcessor;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializer;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeRequest;
import com.liferay.dynamic.data.mapping.io.DDMFormSerializerSerializeResponse;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.dynamic.data.mapping.util.DefaultDDMStructureHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPool;
import com.liferay.portal.kernel.metadata.RawMetadataProcessorUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, service={PortalInstanceLifecycleListener.class})
public class AddDefaultDocumentLibraryStructuresPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private DDM _ddm;
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DefaultDDMStructureHelper _defaultDDMStructureHelper;
    private volatile DLConfiguration _dlConfiguration;
    private GroupLocalService _groupLocalService;
    @Reference(target="(ddm.form.serializer.type=json)")
    private DDMFormSerializer _jsonDDMFormSerializer;
    @Reference
    private Portal _portal;
    private volatile PortalCache<DDMForm, String> _portalCache;
    @Reference
    private SingleVMPool _singleVMPool;
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) throws Exception {
        if (!this._dlConfiguration.addDefaultStructures()) {
            return;
        }
        this.addDLRawMetadataStructures(company.getCompanyId());
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        this._portalCache = this._singleVMPool.getPortalCache(clazz.getName());
    }

    protected void addDLRawMetadataStructures(long companyId) throws Exception {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Group group = this._groupLocalService.getCompanyGroup(companyId);
        serviceContext.setScopeGroupId(group.getGroupId());
        long defaultUserId = this._userLocalService.getDefaultUserId(companyId);
        serviceContext.setUserId(defaultUserId);
        Locale locale = this._portal.getSiteDefaultLocale(group.getGroupId());
        Map fields = RawMetadataProcessorUtil.getFields();
        for (Map.Entry entry : fields.entrySet()) {
            String name = (String)entry.getKey();
            DDMForm ddmForm = this._buildDDMForm((Field[])entry.getValue(), locale);
            DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(group.getGroupId(), this._portal.getClassNameId(RawMetadataProcessor.class), name);
            if (ddmStructure != null) {
                String definition = this._getDefinition(ddmForm);
                if (definition.equals(ddmStructure.getDefinition())) continue;
                ddmStructure.setDDMForm(ddmForm);
                this._ddmStructureLocalService.updateDDMStructure(ddmStructure);
                continue;
            }
            HashMap nameMap = HashMapBuilder.put((Object)locale, (Object)name).build();
            HashMap descriptionMap = HashMapBuilder.put((Object)locale, (Object)name).build();
            DDMFormLayout ddmFormLayout = this._ddm.getDefaultDDMFormLayout(ddmForm);
            this._ddmStructureLocalService.addStructure(defaultUserId, group.getGroupId(), 0L, this._portal.getClassNameId(RawMetadataProcessor.class), name, (Map)nameMap, (Map)descriptionMap, ddmForm, ddmFormLayout, StorageType.DEFAULT.toString(), 0, serviceContext);
        }
    }

    @Deactivate
    protected void deactivate() {
        this._singleVMPool.removePortalCache(this._portalCache.getPortalCacheName());
    }

    @Reference(unbind="-")
    protected void setDDM(DDM ddm) {
        this._ddm = ddm;
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setGroupLocalService(GroupLocalService groupLocalService) {
        this._groupLocalService = groupLocalService;
    }

    @Reference(target="(module.service.lifecycle=portal.initialized)", unbind="-")
    protected void setModuleServiceLifecycle(ModuleServiceLifecycle moduleServiceLifecycle) {
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    private DDMForm _buildDDMForm(Field[] fields, Locale locale) {
        DDMForm ddmForm = new DDMForm();
        ddmForm.setAvailableLocales(Collections.singleton(locale));
        ddmForm.setDefaultLocale(locale);
        ArrayList<DDMFormField> ddmFormFields = new ArrayList<DDMFormField>();
        for (Field field : fields) {
            Class<?> fieldClass = field.getDeclaringClass();
            DDMFormField ddmFormField = new DDMFormField(StringBundler.concat((String[])new String[]{fieldClass.getSimpleName(), "_", field.getName()}), "text");
            ddmFormField.setDataType("string");
            ddmFormField.setIndexType("text");
            ddmFormField.setLocalizable(false);
            ddmFormField.setMultiple(false);
            ddmFormField.setReadOnly(false);
            ddmFormField.setRepeatable(false);
            ddmFormField.setRequired(false);
            ddmFormField.setShowLabel(true);
            LocalizedValue label = ddmFormField.getLabel();
            label.addString(locale, StringBundler.concat((String[])new String[]{"metadata.", fieldClass.getSimpleName(), ".", field.getName()}));
            label.setDefaultLocale(locale);
            LocalizedValue predefinedValue = ddmFormField.getPredefinedValue();
            predefinedValue.addString(locale, "");
            predefinedValue.setDefaultLocale(locale);
            LocalizedValue style = ddmFormField.getStyle();
            style.setDefaultLocale(locale);
            LocalizedValue tip = ddmFormField.getTip();
            tip.setDefaultLocale(locale);
            DDMFormFieldOptions ddmFormFieldOptions = ddmFormField.getDDMFormFieldOptions();
            ddmFormFieldOptions.setDefaultLocale(locale);
            ddmFormFields.add(ddmFormField);
        }
        ddmForm.setDDMFormFields(ddmFormFields);
        return ddmForm;
    }

    private String _getDefinition(DDMForm ddmForm) {
        String definition = (String)this._portalCache.get((Serializable)ddmForm);
        if (Validator.isNull((String)definition)) {
            definition = this._serializeJSONDDMForm(ddmForm);
            this._portalCache.put((Serializable)ddmForm, (Object)definition);
        }
        return definition;
    }

    private String _serializeJSONDDMForm(DDMForm ddmForm) {
        DDMFormSerializerSerializeRequest.Builder builder = DDMFormSerializerSerializeRequest.Builder.newBuilder((DDMForm)ddmForm);
        DDMFormSerializerSerializeResponse ddmFormSerializerSerializeResponse = this._jsonDDMFormSerializer.serialize(builder.build());
        return ddmFormSerializerSerializeResponse.getContent();
    }
}

