/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.model.listener;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class DLFileVersionModelListener
extends BaseModelListener<DLFileVersion> {
    private static final Log _log = LogFactoryUtil.getLog(DLFileVersionModelListener.class);
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;

    public void onAfterRemove(DLFileVersion dlFileVersion) throws ModelListenerException {
        try {
            DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(dlFileVersion.getFileEntryId());
            if (dlFileEntry != null) {
                DLStoreUtil.deleteFile((long)dlFileEntry.getCompanyId(), (long)dlFileEntry.getDataRepositoryId(), (String)dlFileEntry.getName(), (String)dlFileVersion.getVersion());
            }
        }
        catch (PortalException portalException) {
            _log.error((Object)portalException, (Throwable)portalException);
        }
    }
}

