/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.osgi.commands;

import com.liferay.document.library.service.DLStorageQuotaLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"osgi.command.function=update", "osgi.command.scope=documentLibrary"}, service={DLStorageQuotaOSGiCommands.class})
public class DLStorageQuotaOSGiCommands {
    private static final Log _log = LogFactoryUtil.getLog(DLStorageQuotaOSGiCommands.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DLStorageQuotaLocalService _dlStorageQuotaLocalService;

    public void update(String ... companyIds) {
        for (String companyId : companyIds) {
            try {
                this._dlStorageQuotaLocalService.updateStorageSize(GetterUtil.getLong((String)companyId));
                System.out.printf("Successfully updated document library storage quota for company %s%n", companyId);
            }
            catch (Exception exception) {
                _log.error((Object)exception, (Throwable)exception);
                System.out.printf("Unable to update document library storage quota for company %s. See server log for more details.%n", companyId);
            }
        }
    }
}

