/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.repository.capabilities;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.capabilities.DynamicCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventAware;
import com.liferay.portal.kernel.repository.event.RepositoryEventListener;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import com.liferay.portal.repository.util.LocalRepositoryWrapper;
import com.liferay.portal.repository.util.RepositoryWrapper;
import com.liferay.portal.repository.util.RepositoryWrapperAware;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class LiferayDynamicCapability
implements DynamicCapability,
RepositoryEventAware,
RepositoryWrapperAware {
    private final Set<Capability> _capabilities = new HashSet<Capability>();
    private final Map<Capability, CapabilityRegistration> _capabilityRegistrations = new ConcurrentHashMap<Capability, CapabilityRegistration>();
    private LocalRepositoryWrapper _liferayDynamicCapabilityLocalRepositoryWrapper;
    private RepositoryWrapper _liferayDynamicCapabilityRepositoryWrapper;
    private LocalRepository _originalLocalRepository;
    private Repository _originalRepository;
    private volatile RepositoryEventRegistry _repositoryEventRegistry;
    private final ServiceTracker<Capability, Capability> _serviceTracker;

    public LiferayDynamicCapability(final BundleContext bundleContext, String repositoryClassName) {
        Filter filter = null;
        try {
            filter = bundleContext.createFilter(StringBundler.concat((String[])new String[]{"(&(objectClass=", Capability.class.getName(), ")(|(repository.class.name=", repositoryClassName, ")(repository.class.name=ALL)))"}));
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            ReflectionUtil.throwException((Throwable)invalidSyntaxException);
        }
        this._serviceTracker = new ServiceTracker(bundleContext, filter, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<Capability, Capability>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Capability addingService(ServiceReference<Capability> serviceReference) {
                Capability capability = (Capability)bundleContext.getService(serviceReference);
                LiferayDynamicCapability liferayDynamicCapability = LiferayDynamicCapability.this;
                synchronized (liferayDynamicCapability) {
                    if (capability instanceof RepositoryEventAware) {
                        LiferayDynamicCapability.this._registerRepositoryEventListeners((Capability)((RepositoryEventAware)((Capability)((RepositoryEventAware)capability))));
                    }
                    LiferayDynamicCapability.this._capabilities.add(capability);
                    LiferayDynamicCapability.this._updateRepositoryWrappers();
                }
                return capability;
            }

            public void modifiedService(ServiceReference<Capability> serviceReference, Capability capability) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void removedService(ServiceReference<Capability> serviceReference, Capability capability) {
                LiferayDynamicCapability liferayDynamicCapability = LiferayDynamicCapability.this;
                synchronized (liferayDynamicCapability) {
                    LiferayDynamicCapability.this._unregisterRepositoryEventListeners(capability);
                    LiferayDynamicCapability.this._capabilities.remove(capability);
                    LiferayDynamicCapability.this._updateRepositoryWrappers();
                }
            }
        });
        this._serviceTracker.open();
    }

    public void clear() {
        this._serviceTracker.close();
        this._capabilities.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRepositoryEventListeners(RepositoryEventRegistry repositoryEventRegistry) {
        this._repositoryEventRegistry = repositoryEventRegistry;
        for (Capability capability : this._capabilities) {
            LiferayDynamicCapability liferayDynamicCapability = this;
            synchronized (liferayDynamicCapability) {
                if (capability instanceof RepositoryEventAware) {
                    this._registerRepositoryEventListeners((RepositoryEventAware)((Capability)((RepositoryEventAware)capability)));
                }
            }
        }
    }

    public synchronized LocalRepository wrapLocalRepository(LocalRepository localRepository) {
        this._originalLocalRepository = localRepository;
        this._liferayDynamicCapabilityLocalRepositoryWrapper = new LocalRepositoryWrapper(this._wrapLocalRepository(localRepository));
        return this._liferayDynamicCapabilityLocalRepositoryWrapper;
    }

    public synchronized Repository wrapRepository(Repository repository) {
        this._originalRepository = repository;
        this._liferayDynamicCapabilityRepositoryWrapper = new RepositoryWrapper(this._wrapRepository(repository));
        return this._liferayDynamicCapabilityRepositoryWrapper;
    }

    private <T extends Capability & RepositoryEventAware> void _registerRepositoryEventListeners(T capability) {
        CapabilityRegistration capabilityRegistration = new CapabilityRegistration();
        this._capabilityRegistrations.put(capability, capabilityRegistration);
        if (this._repositoryEventRegistry != null) {
            ((RepositoryEventAware)capability).registerRepositoryEventListeners((RepositoryEventRegistry)new DynamicCapabilityRepositoryEventRegistryWrapper(capabilityRegistration, this._repositoryEventRegistry));
        }
    }

    private void _unregisterRepositoryEventListeners(Capability capability) {
        CapabilityRegistration capabilityRegistration = this._capabilityRegistrations.remove(capability);
        if (capabilityRegistration != null) {
            for (RepositoryEventListenerRegistration repositoryEventListenerRegistration : capabilityRegistration._repositoryEventListenerRegistrations) {
                this._repositoryEventRegistry.unregisterRepositoryEventListener(repositoryEventListenerRegistration.getRepositoryEventTypeClass(), repositoryEventListenerRegistration.getModelClass(), repositoryEventListenerRegistration.getRepositoryEventListener());
            }
        }
    }

    private void _updateRepositoryWrappers() {
        if (this._liferayDynamicCapabilityLocalRepositoryWrapper != null) {
            this._liferayDynamicCapabilityLocalRepositoryWrapper.setLocalRepository(this._wrapLocalRepository(this._originalLocalRepository));
        }
        if (this._liferayDynamicCapabilityRepositoryWrapper != null) {
            this._liferayDynamicCapabilityRepositoryWrapper.setRepository(this._wrapRepository(this._originalRepository));
        }
    }

    private LocalRepository _wrapLocalRepository(LocalRepository localRepository) {
        LocalRepository wrappedLocalRepository = localRepository;
        for (Capability capability : this._capabilities) {
            if (!(capability instanceof RepositoryWrapperAware)) continue;
            RepositoryWrapperAware repositoryWrapperAware = (RepositoryWrapperAware)capability;
            wrappedLocalRepository = repositoryWrapperAware.wrapLocalRepository(wrappedLocalRepository);
        }
        return wrappedLocalRepository;
    }

    private Repository _wrapRepository(Repository repository) {
        Repository wrappedRepository = repository;
        for (Capability capability : this._capabilities) {
            if (!(capability instanceof RepositoryWrapperAware)) continue;
            RepositoryWrapperAware repositoryWrapperAware = (RepositoryWrapperAware)capability;
            wrappedRepository = repositoryWrapperAware.wrapRepository(wrappedRepository);
        }
        return wrappedRepository;
    }

    private static class RepositoryEventListenerRegistration<S extends RepositoryEventType, T> {
        private final Class<T> _modelClass;
        private final RepositoryEventListener<S, T> _repositoryEventListener;
        private final Class<S> _repositoryEventTypeClass;

        public RepositoryEventListenerRegistration(Class<S> repositoryEventTypeClass, Class<T> modelClass, RepositoryEventListener<S, T> repositoryEventListener) {
            this._repositoryEventTypeClass = repositoryEventTypeClass;
            this._modelClass = modelClass;
            this._repositoryEventListener = repositoryEventListener;
        }

        public Class<T> getModelClass() {
            return this._modelClass;
        }

        public RepositoryEventListener<S, T> getRepositoryEventListener() {
            return this._repositoryEventListener;
        }

        public Class<S> getRepositoryEventTypeClass() {
            return this._repositoryEventTypeClass;
        }
    }

    private static class DynamicCapabilityRepositoryEventRegistryWrapper
    implements RepositoryEventRegistry {
        private final CapabilityRegistration _capabilityRegistration;
        private final RepositoryEventRegistry _repositoryEventRegistry;

        public DynamicCapabilityRepositoryEventRegistryWrapper(CapabilityRegistration capabilityRegistration, RepositoryEventRegistry repositoryEventRegistry) {
            this._capabilityRegistration = capabilityRegistration;
            this._repositoryEventRegistry = repositoryEventRegistry;
        }

        public <S extends RepositoryEventType, T> void registerRepositoryEventListener(Class<S> repositoryEventTypeClass, Class<T> modelClass, RepositoryEventListener<S, T> repositoryEventListeners) {
            this._capabilityRegistration.addRepositoryEventListenerRegistration(repositoryEventTypeClass, modelClass, repositoryEventListeners);
            this._repositoryEventRegistry.registerRepositoryEventListener(repositoryEventTypeClass, modelClass, repositoryEventListeners);
        }

        public <S extends RepositoryEventType, T> void unregisterRepositoryEventListener(Class<S> repositoryEventTypeClass, Class<T> modelClass, RepositoryEventListener<S, T> repositoryEventListener) {
        }
    }

    private static class CapabilityRegistration {
        private final List<RepositoryEventListenerRegistration> _repositoryEventListenerRegistrations = new ArrayList<RepositoryEventListenerRegistration>();

        private CapabilityRegistration() {
        }

        public <S extends RepositoryEventType, T> void addRepositoryEventListenerRegistration(Class<S> repositoryEventTypeClass, Class<T> modelClass, RepositoryEventListener<S, T> repositoryEventListeners) {
            this._repositoryEventListenerRegistrations.add(new RepositoryEventListenerRegistration<S, T>(repositoryEventTypeClass, modelClass, repositoryEventListeners));
        }
    }
}

