/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.repository.capabilities;

import com.liferay.document.library.sync.model.DLSyncEvent;
import com.liferay.document.library.sync.service.DLSyncEventLocalService;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.repository.capabilities.SyncCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventAware;
import com.liferay.portal.kernel.repository.event.RepositoryEventListener;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.event.TrashRepositoryEventType;
import com.liferay.portal.kernel.repository.event.WorkflowRepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.repository.capabilities.util.GroupServiceAdapter;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.repository.liferayrepository.model.LiferayFolder;
import java.util.Map;
import java.util.concurrent.Callable;

public class LiferaySyncCapability
implements RepositoryEventAware,
SyncCapability {
    private static final Log _log = LogFactoryUtil.getLog(LiferaySyncCapability.class);
    private final RepositoryEventListener<RepositoryEventType.Add, Folder> _addFolderEventListener = new SyncFolderRepositoryEventListener<RepositoryEventType.Add>("add");
    private final RepositoryEventListener<RepositoryEventType.Delete, FileEntry> _deleteFileEntryEventListener = new SyncFileEntryRepositoryEventListener<RepositoryEventType.Delete>("delete");
    private final RepositoryEventListener<RepositoryEventType.Delete, Folder> _deleteFolderEventListener = new SyncFolderRepositoryEventListener<RepositoryEventType.Delete>("delete");
    private final DLSyncEventLocalService _dlSyncEventLocalService;
    private final GroupServiceAdapter _groupServiceAdapter;
    private final MessageBus _messageBus;
    private final RepositoryEventListener<RepositoryEventType.Move, FileEntry> _moveFileEntryEventListener = new SyncFileEntryRepositoryEventListener<RepositoryEventType.Move>("move");
    private final RepositoryEventListener<RepositoryEventType.Move, Folder> _moveFolderEventListener = new SyncFolderRepositoryEventListener<RepositoryEventType.Move>("move");
    private final RepositoryEventListener<TrashRepositoryEventType.EntryRestored, FileEntry> _restoreFileEntryEventListener = new SyncFileEntryRepositoryEventListener<TrashRepositoryEventType.EntryRestored>("restore");
    private final RepositoryEventListener<TrashRepositoryEventType.EntryRestored, Folder> _restoreFolderEventListener = new SyncFolderRepositoryEventListener<TrashRepositoryEventType.EntryRestored>("restore");
    private final RepositoryEventListener<TrashRepositoryEventType.EntryTrashed, FileEntry> _trashFileEntryEventListener = new SyncFileEntryRepositoryEventListener<TrashRepositoryEventType.EntryTrashed>("trash");
    private final RepositoryEventListener<TrashRepositoryEventType.EntryTrashed, Folder> _trashFolderEventListener = new SyncFolderRepositoryEventListener<TrashRepositoryEventType.EntryTrashed>("trash");
    private final RepositoryEventListener<RepositoryEventType.Update, FileEntry> _updateFileEntryEventListener = new SyncFileEntryRepositoryEventListener<RepositoryEventType.Update>("update");
    private final RepositoryEventListener<RepositoryEventType.Update, Folder> _updateFolderEventListener = new SyncFolderRepositoryEventListener<RepositoryEventType.Update>("update");
    private final RepositoryEventListener<WorkflowRepositoryEventType.Add, FileEntry> _workflowAddFileEntryEventListener = new SyncFileEntryRepositoryEventListener<WorkflowRepositoryEventType.Add>("add");
    private final RepositoryEventListener<WorkflowRepositoryEventType.Update, FileEntry> _workflowUpdateFileEntryEventListener = new SyncFileEntryRepositoryEventListener<WorkflowRepositoryEventType.Update>("update");

    public LiferaySyncCapability(GroupServiceAdapter groupServiceAdapter, DLSyncEventLocalService dlSyncEventLocalService, MessageBus messageBus) {
        this._groupServiceAdapter = groupServiceAdapter;
        this._dlSyncEventLocalService = dlSyncEventLocalService;
        this._messageBus = messageBus;
    }

    public void registerRepositoryEventListeners(RepositoryEventRegistry repositoryEventRegistry) {
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Add.class, Folder.class, this._addFolderEventListener);
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, FileEntry.class, this._deleteFileEntryEventListener);
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, Folder.class, this._deleteFolderEventListener);
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Move.class, FileEntry.class, this._moveFileEntryEventListener);
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Move.class, Folder.class, this._moveFolderEventListener);
        repositoryEventRegistry.registerRepositoryEventListener(TrashRepositoryEventType.EntryRestored.class, FileEntry.class, this._restoreFileEntryEventListener);
        repositoryEventRegistry.registerRepositoryEventListener(TrashRepositoryEventType.EntryRestored.class, Folder.class, this._restoreFolderEventListener);
        repositoryEventRegistry.registerRepositoryEventListener(TrashRepositoryEventType.EntryTrashed.class, FileEntry.class, this._trashFileEntryEventListener);
        repositoryEventRegistry.registerRepositoryEventListener(TrashRepositoryEventType.EntryTrashed.class, Folder.class, this._trashFolderEventListener);
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Update.class, FileEntry.class, this._updateFileEntryEventListener);
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Update.class, Folder.class, this._updateFolderEventListener);
        repositoryEventRegistry.registerRepositoryEventListener(WorkflowRepositoryEventType.Add.class, FileEntry.class, this._workflowAddFileEntryEventListener);
        repositoryEventRegistry.registerRepositoryEventListener(WorkflowRepositoryEventType.Update.class, FileEntry.class, this._workflowUpdateFileEntryEventListener);
    }

    protected boolean isStagingGroup(long groupId) {
        try {
            Group group = this._groupServiceAdapter.getGroup(groupId);
            return group.isStagingGroup();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)exception, (Throwable)exception);
            }
            return false;
        }
    }

    protected void registerDLSyncEventCallback(String event, FileEntry fileEntry) {
        if (!CTCollectionThreadLocal.isProductionMode() || this.isStagingGroup(fileEntry.getGroupId()) || !(fileEntry instanceof LiferayFileEntry)) {
            return;
        }
        try {
            FileVersion fileVersion = fileEntry.getFileVersion();
            if (fileVersion.isPending()) {
                return;
            }
        }
        catch (Exception exception) {
            _log.error((Object)exception, (Throwable)exception);
        }
        this.registerDLSyncEventCallback(event, "file", fileEntry.getFileEntryId());
    }

    protected void registerDLSyncEventCallback(String event, Folder folder) {
        if (!CTCollectionThreadLocal.isProductionMode() || this.isStagingGroup(folder.getGroupId()) || !(folder instanceof LiferayFolder)) {
            return;
        }
        this.registerDLSyncEventCallback(event, "folder", folder.getFolderId());
    }

    protected void registerDLSyncEventCallback(final String event, final String type, final long typePK) {
        DLSyncEvent dlSyncEvent = this._dlSyncEventLocalService.addDLSyncEvent(event, type, typePK);
        final long modifiedTime = dlSyncEvent.getModifiedTime();
        TransactionCommitCallbackUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Message message = new Message();
                message.setValues((Map)HashMapBuilder.put((Object)"event", (Object)event).put((Object)"modifiedTime", (Object)modifiedTime).put((Object)"type", (Object)type).put((Object)"typePK", (Object)typePK).build());
                LiferaySyncCapability.this._messageBus.sendMessage("liferay/document_library_sync_event_processor", message);
                return null;
            }
        });
    }

    private class SyncFolderRepositoryEventListener<S extends RepositoryEventType>
    implements RepositoryEventListener<S, Folder> {
        private final String _syncEvent;

        public SyncFolderRepositoryEventListener(String syncEvent) {
            this._syncEvent = syncEvent;
        }

        public void execute(Folder folder) {
            LiferaySyncCapability.this.registerDLSyncEventCallback(this._syncEvent, folder);
        }
    }

    private class SyncFileEntryRepositoryEventListener<S extends RepositoryEventType>
    implements RepositoryEventListener<S, FileEntry> {
        private final String _syncEvent;

        public SyncFileEntryRepositoryEventListener(String syncEvent) {
            this._syncEvent = syncEvent;
        }

        public void execute(FileEntry fileEntry) {
            LiferaySyncCapability.this.registerDLSyncEventCallback(this._syncEvent, fileEntry);
        }
    }
}

