/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.repository.capabilities;

import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppHelperLocalServiceUtil;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.capabilities.BulkOperationCapability;
import com.liferay.portal.kernel.repository.capabilities.ConfigurationCapability;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesCapability;
import com.liferay.portal.kernel.repository.capabilities.TemporaryFileEntriesScope;
import com.liferay.portal.kernel.repository.model.BaseRepositoryModelOperation;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEventHierarchyEntryThreadLocal;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class TemporaryFileEntriesCapabilityImpl
implements TemporaryFileEntriesCapability {
    private static final String _FOLDER_NAME_TEMP = "temp";
    private static final String _PROPERTY_TEMPORARY_FILE_ENTRIES_TIMEOUT = "temporaryFilesTimeout";
    private static final long _TEMPORARY_FILE_ENTRIES_TIMEOUT_DEFAULT = 43200000L;
    private static final Log _log = LogFactoryUtil.getLog(TemporaryFileEntriesCapabilityImpl.class);
    private final DocumentRepository _documentRepository;

    public TemporaryFileEntriesCapabilityImpl(DocumentRepository documentRepository) {
        this._documentRepository = documentRepository;
    }

    public FileEntry addTemporaryFileEntry(TemporaryFileEntriesScope temporaryFileEntriesScope, String fileName, String mimeType, InputStream inputStream) throws PortalException {
        FileEntry fileEntry;
        Folder folder = this.addTempFolder(temporaryFileEntriesScope);
        File file = null;
        try {
            if (inputStream == null) {
                inputStream = new UnsyncByteArrayInputStream(new byte[0]);
            }
            file = FileUtil.createTempFile((InputStream)inputStream);
            ServiceContext serviceContext = new ServiceContext();
            serviceContext.setAddGroupPermissions(true);
            serviceContext.setAddGuestPermissions(true);
            fileEntry = this._documentRepository.addFileEntry(null, temporaryFileEntriesScope.getUserId(), folder.getFolderId(), fileName, mimeType, fileName, "", "", file, null, null, serviceContext);
        }
        catch (IOException ioException) {
            try {
                throw new SystemException("Unable to write temporary file", (Throwable)ioException);
            }
            catch (Throwable throwable) {
                FileUtil.delete(file);
                throw throwable;
            }
        }
        FileUtil.delete((File)file);
        return fileEntry;
    }

    public void deleteExpiredTemporaryFileEntries() throws PortalException {
        BulkOperationCapability bulkOperationCapability = (BulkOperationCapability)this._documentRepository.getCapability(BulkOperationCapability.class);
        BulkOperationCapability.Filter bulkFilter = new BulkOperationCapability.Filter(BulkOperationCapability.Field.CreateDate.class, BulkOperationCapability.Operator.LT, (Object)new Date(System.currentTimeMillis() - this.getTemporaryFileEntriesTimeout()));
        this._runWithoutSystemEvents((UnsafeSupplier<Void, PortalException>)((UnsafeSupplier)() -> {
            bulkOperationCapability.execute(bulkFilter, (RepositoryModelOperation)new DeleteExpiredTemporaryFilesRepositoryModelOperation());
            return null;
        }));
    }

    public void deleteTemporaryFileEntry(TemporaryFileEntriesScope temporaryFileEntriesScope, String fileName) throws PortalException {
        this._runWithoutSystemEvents((UnsafeSupplier<Void, PortalException>)((UnsafeSupplier)() -> {
            block2: {
                try {
                    FileEntry fileEntry = this.getTemporaryFileEntry(temporaryFileEntriesScope, fileName);
                    this._documentRepository.deleteFileEntry(fileEntry.getFileEntryId());
                }
                catch (NoSuchModelException noSuchModelException) {
                    if (!_log.isDebugEnabled()) break block2;
                    _log.debug((Object)noSuchModelException, (Throwable)noSuchModelException);
                }
            }
            return null;
        }));
    }

    public List<FileEntry> getTemporaryFileEntries(TemporaryFileEntriesScope temporaryFileEntriesScope) throws PortalException {
        try {
            Folder folder = this.addTempFolder(temporaryFileEntriesScope);
            return this._documentRepository.getRepositoryFileEntries(temporaryFileEntriesScope.getUserId(), folder.getFolderId(), -1, -1, null);
        }
        catch (NoSuchModelException noSuchModelException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)noSuchModelException, (Throwable)noSuchModelException);
            }
            return Collections.emptyList();
        }
    }

    public long getTemporaryFileEntriesTimeout() {
        ConfigurationCapability configurationCapability = (ConfigurationCapability)this._documentRepository.getCapability(ConfigurationCapability.class);
        String temporaryFileEntriesTimeout = configurationCapability.getProperty(this.getClass(), _PROPERTY_TEMPORARY_FILE_ENTRIES_TIMEOUT);
        if (temporaryFileEntriesTimeout == null) {
            return 43200000L;
        }
        return GetterUtil.getLong((String)temporaryFileEntriesTimeout);
    }

    public FileEntry getTemporaryFileEntry(TemporaryFileEntriesScope temporaryFileEntriesScope, String fileName) throws PortalException {
        Folder folder = this.getTempFolder(temporaryFileEntriesScope);
        return this._documentRepository.getFileEntry(folder.getFolderId(), fileName);
    }

    public void setTemporaryFileEntriesTimeout(long temporaryFileEntriesTimeout) {
        ConfigurationCapability configurationCapability = (ConfigurationCapability)this._documentRepository.getCapability(ConfigurationCapability.class);
        configurationCapability.setProperty(this.getClass(), _PROPERTY_TEMPORARY_FILE_ENTRIES_TIMEOUT, String.valueOf(temporaryFileEntriesTimeout));
    }

    protected Folder addFolder(long userId, long parentFolderId, String folderName, ServiceContext serviceContext) throws PortalException {
        try {
            return this._documentRepository.getFolder(parentFolderId, folderName);
        }
        catch (NoSuchFolderException noSuchFolderException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)noSuchFolderException, (Throwable)noSuchFolderException);
            }
            return this._documentRepository.addFolder(userId, parentFolderId, folderName, "", serviceContext);
        }
    }

    protected Folder addFolders(long userId, long folderId, String folderPath, ServiceContext serviceContext) throws PortalException {
        String[] folderNames;
        Folder folder = null;
        for (String folderName : folderNames = StringUtil.split((String)folderPath, (String)"/")) {
            folder = this.addFolder(userId, folderId, folderName, serviceContext);
            folderId = folder.getFolderId();
        }
        return folder;
    }

    protected Folder addTempFolder(TemporaryFileEntriesScope temporaryFileEntriesScope) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        return this.addFolders(temporaryFileEntriesScope.getUserId(), 0L, this._getFolderPath(temporaryFileEntriesScope), serviceContext);
    }

    protected Folder getDeepestFolder(long parentFolderId, String folderPath) throws PortalException {
        String[] folderNames;
        Folder folder = null;
        for (String folderName : folderNames = StringUtil.split((String)folderPath, (String)"/")) {
            folder = this._documentRepository.getFolder(parentFolderId, folderName);
            parentFolderId = folder.getFolderId();
        }
        return folder;
    }

    protected Folder getTempFolder(TemporaryFileEntriesScope temporaryFileEntriesScope) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        return this.getDeepestFolder(0L, this._getFolderPath(temporaryFileEntriesScope));
    }

    private String _getFolderPath(TemporaryFileEntriesScope temporaryFileEntriesScope) {
        StringBundler sb = new StringBundler(7);
        sb.append(_FOLDER_NAME_TEMP);
        sb.append("/");
        sb.append((Object)temporaryFileEntriesScope.getCallerUuid());
        sb.append("/");
        sb.append(temporaryFileEntriesScope.getUserId());
        sb.append("/");
        sb.append(temporaryFileEntriesScope.getFolderPath());
        return sb.toString();
    }

    private void _runWithoutSystemEvents(UnsafeSupplier<Void, PortalException> unsafeSupplier) throws PortalException {
        SystemEventHierarchyEntryThreadLocal.push(DLFileEntry.class);
        try {
            unsafeSupplier.get();
        }
        finally {
            SystemEventHierarchyEntryThreadLocal.pop(DLFileEntry.class);
        }
    }

    private class DeleteExpiredTemporaryFilesRepositoryModelOperation
    extends BaseRepositoryModelOperation {
        private DeleteExpiredTemporaryFilesRepositoryModelOperation() {
        }

        public void execute(FileEntry fileEntry) throws PortalException {
            DLAppHelperLocalServiceUtil.deleteFileEntry((FileEntry)fileEntry);
            TemporaryFileEntriesCapabilityImpl.this._documentRepository.deleteFileEntry(fileEntry.getFileEntryId());
            Folder folder = fileEntry.getFolder();
            Folder mountFolder = TemporaryFileEntriesCapabilityImpl.this._documentRepository.getFolder(0L);
            while (folder.getFolderId() != mountFolder.getFolderId()) {
                long folderId = folder.getFolderId();
                int count = TemporaryFileEntriesCapabilityImpl.this._documentRepository.getFileEntriesCount(folderId, -1);
                if (count != 0) break;
                DLAppHelperLocalServiceUtil.deleteFolder((Folder)folder);
                folder = folder.getParentFolder();
                TemporaryFileEntriesCapabilityImpl.this._documentRepository.deleteFolder(folderId);
            }
        }
    }
}

