/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.SearchResult;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.SummaryFactory;
import com.liferay.portal.kernel.search.result.SearchResultContributor;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={SearchResultContributor.class})
public class DLFileEntrySearchResultContributor
implements SearchResultContributor {
    private ClassNameLocalService _classNameLocalService;
    private DLAppLocalService _dlAppLocalService;
    private SummaryFactory _summaryFactory;

    public void addRelatedModel(SearchResult searchResult, Document document, Locale locale, PortletRequest portletRequest, PortletResponse portletResponse) throws PortalException {
        long entryClassPK = GetterUtil.getLong((String)document.get("entryClassPK"));
        FileEntry fileEntry = this._dlAppLocalService.getFileEntry(entryClassPK);
        if (fileEntry != null) {
            Summary summary = this._summaryFactory.getSummary(document, DLFileEntry.class.getName(), fileEntry.getFileEntryId(), locale, portletRequest, portletResponse);
            if (Validator.isNull((String)summary.getContent())) {
                summary.setContent(fileEntry.getTitle());
            }
            searchResult.addFileEntry(fileEntry, summary);
        } else {
            long classNameId = GetterUtil.getLong((String)document.get("classNameId"));
            ClassName className = this._classNameLocalService.getClassName(classNameId);
            long classPK = GetterUtil.getLong((String)document.get("classPK"));
            Summary summary = this._summaryFactory.getSummary(document, className.getClassName(), classPK, locale, portletRequest, portletResponse);
            searchResult.setSummary(summary);
        }
    }

    public String getEntryClassName() {
        return DLFileEntryConstants.getClassName();
    }

    @Reference(unbind="-")
    public void setClassNameLocalService(ClassNameLocalService classNameLocalService) {
        this._classNameLocalService = classNameLocalService;
    }

    @Reference(unbind="-")
    public void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }

    @Reference(unbind="-")
    public void setSummaryFactory(SummaryFactory summaryFactory) {
        this._summaryFactory = summaryFactory;
    }
}

