/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search.spi.model.query.contributor;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.ParseException;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.generic.BooleanQueryImpl;
import com.liferay.portal.kernel.search.generic.MatchQuery;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.query.QueryHelper;
import com.liferay.portal.search.spi.model.query.contributor.KeywordQueryContributor;
import com.liferay.portal.search.spi.model.query.contributor.helper.KeywordQueryContributorHelper;
import org.apache.commons.lang.StringUtils;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={KeywordQueryContributor.class})
public class DLFileEntryKeywordQueryContributor
implements KeywordQueryContributor {
    @Reference
    protected QueryHelper queryHelper;

    public void contribute(String keywords, BooleanQuery booleanQuery, KeywordQueryContributorHelper keywordQueryContributorHelper) {
        SearchContext searchContext = keywordQueryContributorHelper.getSearchContext();
        if (Validator.isNull((String)keywords)) {
            this.queryHelper.addSearchTerm(booleanQuery, searchContext, "description", false);
            this.queryHelper.addSearchTerm(booleanQuery, searchContext, "userName", false);
        }
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "ddmContent", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "extension", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "fileEntryTypeId", false);
        this.queryHelper.addSearchLocalizedTerm(booleanQuery, searchContext, "content", false);
        this.queryHelper.addSearchTerm(booleanQuery, searchContext, "title", false);
        if (Validator.isNotNull((String)keywords)) {
            try {
                BooleanQueryImpl fileNameBooleanQuery = new BooleanQueryImpl();
                String exactMatch = StringUtils.substringBetween((String)keywords, (String)"\"");
                if (Validator.isNotNull((String)exactMatch)) {
                    String notExactKeyword = keywords.replaceFirst("\"" + exactMatch + "\"", "");
                    fileNameBooleanQuery.add((Query)this._getMatchQuery("fileName", exactMatch, MatchQuery.Type.PHRASE), BooleanClauseOccur.MUST);
                    if (Validator.isNotNull((String)notExactKeyword)) {
                        fileNameBooleanQuery.add((Query)this._getShouldBooleanQuery(notExactKeyword), BooleanClauseOccur.MUST);
                    }
                } else {
                    fileNameBooleanQuery.add((Query)this._getShouldBooleanQuery(keywords), BooleanClauseOccur.MUST);
                }
                booleanQuery.add((Query)this._getMatchQuery("fileExtension", keywords, MatchQuery.Type.PHRASE_PREFIX), BooleanClauseOccur.SHOULD);
                fileNameBooleanQuery.add((Query)this._getMatchQuery("fileName", keywords, MatchQuery.Type.PHRASE), BooleanClauseOccur.SHOULD);
                booleanQuery.add((Query)fileNameBooleanQuery, BooleanClauseOccur.SHOULD);
            }
            catch (ParseException parseException) {
                throw new SystemException((Throwable)parseException);
            }
        }
    }

    private MatchQuery _getMatchQuery(String field, String keywords, MatchQuery.Type phrase) {
        MatchQuery matchPhraseQuery = new MatchQuery(field, keywords);
        matchPhraseQuery.setType(phrase);
        return matchPhraseQuery;
    }

    private BooleanQuery _getShouldBooleanQuery(String keyword) throws ParseException {
        BooleanQueryImpl booleanQuery = new BooleanQueryImpl();
        booleanQuery.add((Query)new MatchQuery("fileName", keyword), BooleanClauseOccur.SHOULD);
        booleanQuery.add((Query)this._getMatchQuery("fileName", keyword, MatchQuery.Type.PHRASE_PREFIX), BooleanClauseOccur.SHOULD);
        return booleanQuery;
    }
}

