/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.service;

import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLAppLocalServiceWrapper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.service.ServiceWrapper;
import com.liferay.subscription.service.SubscriptionLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ServiceWrapper.class})
public class SubscriptionDLAppLocalServiceWrapper
extends DLAppLocalServiceWrapper {
    @Reference
    private SubscriptionLocalService _subscriptionLocalService;

    public SubscriptionDLAppLocalServiceWrapper() {
        super(null);
    }

    public SubscriptionDLAppLocalServiceWrapper(DLAppLocalService dlAppLocalService) {
        super(dlAppLocalService);
    }

    public void subscribeFileEntryType(long userId, long groupId, long fileEntryTypeId) throws PortalException {
        super.subscribeFileEntryType(userId, groupId, fileEntryTypeId);
        if (fileEntryTypeId == 0L) {
            fileEntryTypeId = groupId;
        }
        this._subscriptionLocalService.addSubscription(userId, groupId, DLFileEntryType.class.getName(), fileEntryTypeId);
    }

    public void subscribeFolder(long userId, long groupId, long folderId) throws PortalException {
        super.subscribeFolder(userId, groupId, folderId);
        if (folderId == 0L) {
            folderId = groupId;
        }
        this._subscriptionLocalService.addSubscription(userId, groupId, DLFolder.class.getName(), folderId);
    }

    public void unsubscribeFileEntryType(long userId, long groupId, long fileEntryTypeId) throws PortalException {
        super.unsubscribeFileEntryType(userId, groupId, fileEntryTypeId);
        if (fileEntryTypeId == 0L) {
            fileEntryTypeId = groupId;
        }
        this._subscriptionLocalService.deleteSubscription(userId, DLFileEntryType.class.getName(), fileEntryTypeId);
    }

    public void unsubscribeFolder(long userId, long groupId, long folderId) throws PortalException {
        super.unsubscribeFolder(userId, groupId, folderId);
        if (folderId == 0L) {
            folderId = groupId;
        }
        this._subscriptionLocalService.deleteSubscription(userId, DLFolder.class.getName(), folderId);
    }
}

