/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.versioning;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.kernel.versioning.VersioningStrategy;
import com.liferay.document.library.versioning.VersioningPolicy;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import java.util.Map;
import java.util.Optional;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.document.library.configuration.DLConfiguration"}, service={VersioningStrategy.class})
public class VersioningPolicyVersioningStrategy
implements VersioningStrategy {
    private volatile DLConfiguration _dlConfiguration;
    private volatile ServiceTrackerList<VersioningPolicy, VersioningPolicy> _serviceTrackerList;

    public DLVersionNumberIncrease computeDLVersionNumberIncrease(DLFileVersion previousDLFileVersion, DLFileVersion nextDLFileVersion) {
        for (VersioningPolicy versioningPolicy : this._serviceTrackerList) {
            Optional dlVersionNumberIncreaseOptional = versioningPolicy.computeDLVersionNumberIncrease(previousDLFileVersion, nextDLFileVersion);
            if (!dlVersionNumberIncreaseOptional.isPresent()) continue;
            return (DLVersionNumberIncrease)dlVersionNumberIncreaseOptional.get();
        }
        return DLVersionNumberIncrease.NONE;
    }

    public boolean isOverridable() {
        return this._dlConfiguration.versioningStrategyOverridable();
    }

    @Activate
    @Modified
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._dlConfiguration = (DLConfiguration)ConfigurableUtil.createConfigurable(DLConfiguration.class, properties);
        this._serviceTrackerList = ServiceTrackerListFactory.open((BundleContext)bundleContext, VersioningPolicy.class);
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerList.close();
    }
}

