/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.service.persistence.impl;

import com.liferay.document.library.exception.NoSuchFileVersionPreviewException;
import com.liferay.document.library.model.DLFileVersionPreview;
import com.liferay.document.library.model.DLFileVersionPreviewTable;
import com.liferay.document.library.model.impl.DLFileVersionPreviewImpl;
import com.liferay.document.library.model.impl.DLFileVersionPreviewModelImpl;
import com.liferay.document.library.service.persistence.DLFileVersionPreviewPersistence;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLFileVersionPreviewPersistence.class, BasePersistence.class})
public class DLFileVersionPreviewPersistenceImpl
extends BasePersistenceImpl<DLFileVersionPreview>
implements DLFileVersionPreviewPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DLFileVersionPreviewImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByFileEntryId;
    private FinderPath _finderPathWithoutPaginationFindByFileEntryId;
    private FinderPath _finderPathCountByFileEntryId;
    private static final String _FINDER_COLUMN_FILEENTRYID_FILEENTRYID_2 = "dlFileVersionPreview.fileEntryId = ?";
    private FinderPath _finderPathWithPaginationFindByFileVersionId;
    private FinderPath _finderPathWithoutPaginationFindByFileVersionId;
    private FinderPath _finderPathCountByFileVersionId;
    private static final String _FINDER_COLUMN_FILEVERSIONID_FILEVERSIONID_2 = "dlFileVersionPreview.fileVersionId = ?";
    private FinderPath _finderPathFetchByF_F;
    private FinderPath _finderPathCountByF_F;
    private static final String _FINDER_COLUMN_F_F_FILEENTRYID_2 = "dlFileVersionPreview.fileEntryId = ? AND ";
    private static final String _FINDER_COLUMN_F_F_FILEVERSIONID_2 = "dlFileVersionPreview.fileVersionId = ?";
    private FinderPath _finderPathFetchByF_F_P;
    private FinderPath _finderPathCountByF_F_P;
    private static final String _FINDER_COLUMN_F_F_P_FILEENTRYID_2 = "dlFileVersionPreview.fileEntryId = ? AND ";
    private static final String _FINDER_COLUMN_F_F_P_FILEVERSIONID_2 = "dlFileVersionPreview.fileVersionId = ? AND ";
    private static final String _FINDER_COLUMN_F_F_P_PREVIEWSTATUS_2 = "dlFileVersionPreview.previewStatus = ?";
    private static final Map<CTColumnResolutionType, Set<String>> _ctColumnNamesMap = new EnumMap<CTColumnResolutionType, Set<String>>(CTColumnResolutionType.class);
    private static final List<String> _mappingTableNames = new ArrayList<String>();
    private static final List<String[]> _uniqueIndexColumnNames = new ArrayList<String[]>();
    private BundleContext _bundleContext;
    @Reference
    protected CTPersistenceHelper ctPersistenceHelper;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_DLFILEVERSIONPREVIEW = "SELECT dlFileVersionPreview FROM DLFileVersionPreview dlFileVersionPreview";
    private static final String _SQL_SELECT_DLFILEVERSIONPREVIEW_WHERE = "SELECT dlFileVersionPreview FROM DLFileVersionPreview dlFileVersionPreview WHERE ";
    private static final String _SQL_COUNT_DLFILEVERSIONPREVIEW = "SELECT COUNT(dlFileVersionPreview) FROM DLFileVersionPreview dlFileVersionPreview";
    private static final String _SQL_COUNT_DLFILEVERSIONPREVIEW_WHERE = "SELECT COUNT(dlFileVersionPreview) FROM DLFileVersionPreview dlFileVersionPreview WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "dlFileVersionPreview.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DLFileVersionPreview exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DLFileVersionPreview exists with the key {";
    private static final Log _log;
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<DLFileVersionPreview> findByFileEntryId(long fileEntryId) {
        return this.findByFileEntryId(fileEntryId, -1, -1, null);
    }

    public List<DLFileVersionPreview> findByFileEntryId(long fileEntryId, int start, int end) {
        return this.findByFileEntryId(fileEntryId, start, end, null);
    }

    public List<DLFileVersionPreview> findByFileEntryId(long fileEntryId, int start, int end, OrderByComparator<DLFileVersionPreview> orderByComparator) {
        return this.findByFileEntryId(fileEntryId, start, end, orderByComparator, true);
    }

    public List<DLFileVersionPreview> findByFileEntryId(long fileEntryId, int start, int end, OrderByComparator<DLFileVersionPreview> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLFileVersionPreview.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByFileEntryId;
                finderArgs = new Object[]{fileEntryId};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByFileEntryId;
            finderArgs = new Object[]{fileEntryId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (DLFileVersionPreview dlFileVersionPreview : list) {
                if (fileEntryId == dlFileVersionPreview.getFileEntryId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_DLFILEVERSIONPREVIEW_WHERE);
            sb.append(_FINDER_COLUMN_FILEENTRYID_FILEENTRYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY dlFileVersionPreview.dlFileVersionPreviewId DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(fileEntryId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DLFileVersionPreview findByFileEntryId_First(long fileEntryId, OrderByComparator<DLFileVersionPreview> orderByComparator) throws NoSuchFileVersionPreviewException {
        DLFileVersionPreview dlFileVersionPreview = this.fetchByFileEntryId_First(fileEntryId, orderByComparator);
        if (dlFileVersionPreview != null) {
            return dlFileVersionPreview;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("fileEntryId=");
        sb.append(fileEntryId);
        sb.append("}");
        throw new NoSuchFileVersionPreviewException(sb.toString());
    }

    public DLFileVersionPreview fetchByFileEntryId_First(long fileEntryId, OrderByComparator<DLFileVersionPreview> orderByComparator) {
        List<DLFileVersionPreview> list = this.findByFileEntryId(fileEntryId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLFileVersionPreview findByFileEntryId_Last(long fileEntryId, OrderByComparator<DLFileVersionPreview> orderByComparator) throws NoSuchFileVersionPreviewException {
        DLFileVersionPreview dlFileVersionPreview = this.fetchByFileEntryId_Last(fileEntryId, orderByComparator);
        if (dlFileVersionPreview != null) {
            return dlFileVersionPreview;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("fileEntryId=");
        sb.append(fileEntryId);
        sb.append("}");
        throw new NoSuchFileVersionPreviewException(sb.toString());
    }

    public DLFileVersionPreview fetchByFileEntryId_Last(long fileEntryId, OrderByComparator<DLFileVersionPreview> orderByComparator) {
        int count = this.countByFileEntryId(fileEntryId);
        if (count == 0) {
            return null;
        }
        List<DLFileVersionPreview> list = this.findByFileEntryId(fileEntryId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLFileVersionPreview[] findByFileEntryId_PrevAndNext(long dlFileVersionPreviewId, long fileEntryId, OrderByComparator<DLFileVersionPreview> orderByComparator) throws NoSuchFileVersionPreviewException {
        DLFileVersionPreview dlFileVersionPreview = this.findByPrimaryKey(dlFileVersionPreviewId);
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersionPreview[] array = new DLFileVersionPreviewImpl[]{this.getByFileEntryId_PrevAndNext(session, dlFileVersionPreview, fileEntryId, orderByComparator, true), dlFileVersionPreview, this.getByFileEntryId_PrevAndNext(session, dlFileVersionPreview, fileEntryId, orderByComparator, false)};
            DLFileVersionPreview[] dLFileVersionPreviewArray = array;
            return dLFileVersionPreviewArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLFileVersionPreview getByFileEntryId_PrevAndNext(Session session, DLFileVersionPreview dlFileVersionPreview, long fileEntryId, OrderByComparator<DLFileVersionPreview> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_DLFILEVERSIONPREVIEW_WHERE);
        sb.append(_FINDER_COLUMN_FILEENTRYID_FILEENTRYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY dlFileVersionPreview.dlFileVersionPreviewId DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(fileEntryId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)dlFileVersionPreview)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DLFileVersionPreview)list.get(1);
        }
        return null;
    }

    public void removeByFileEntryId(long fileEntryId) {
        for (DLFileVersionPreview dlFileVersionPreview : this.findByFileEntryId(fileEntryId, -1, -1, null)) {
            this.remove((BaseModel)dlFileVersionPreview);
        }
    }

    public int countByFileEntryId(long fileEntryId) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLFileVersionPreview.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByFileEntryId;
            finderArgs = new Object[]{fileEntryId};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_DLFILEVERSIONPREVIEW_WHERE);
            sb.append(_FINDER_COLUMN_FILEENTRYID_FILEENTRYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(fileEntryId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DLFileVersionPreview> findByFileVersionId(long fileVersionId) {
        return this.findByFileVersionId(fileVersionId, -1, -1, null);
    }

    public List<DLFileVersionPreview> findByFileVersionId(long fileVersionId, int start, int end) {
        return this.findByFileVersionId(fileVersionId, start, end, null);
    }

    public List<DLFileVersionPreview> findByFileVersionId(long fileVersionId, int start, int end, OrderByComparator<DLFileVersionPreview> orderByComparator) {
        return this.findByFileVersionId(fileVersionId, start, end, orderByComparator, true);
    }

    public List<DLFileVersionPreview> findByFileVersionId(long fileVersionId, int start, int end, OrderByComparator<DLFileVersionPreview> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLFileVersionPreview.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindByFileVersionId;
                finderArgs = new Object[]{fileVersionId};
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindByFileVersionId;
            finderArgs = new Object[]{fileVersionId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (DLFileVersionPreview dlFileVersionPreview : list) {
                if (fileVersionId == dlFileVersionPreview.getFileVersionId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_DLFILEVERSIONPREVIEW_WHERE);
            sb.append("dlFileVersionPreview.fileVersionId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY dlFileVersionPreview.dlFileVersionPreviewId DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(fileVersionId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DLFileVersionPreview findByFileVersionId_First(long fileVersionId, OrderByComparator<DLFileVersionPreview> orderByComparator) throws NoSuchFileVersionPreviewException {
        DLFileVersionPreview dlFileVersionPreview = this.fetchByFileVersionId_First(fileVersionId, orderByComparator);
        if (dlFileVersionPreview != null) {
            return dlFileVersionPreview;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("fileVersionId=");
        sb.append(fileVersionId);
        sb.append("}");
        throw new NoSuchFileVersionPreviewException(sb.toString());
    }

    public DLFileVersionPreview fetchByFileVersionId_First(long fileVersionId, OrderByComparator<DLFileVersionPreview> orderByComparator) {
        List<DLFileVersionPreview> list = this.findByFileVersionId(fileVersionId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLFileVersionPreview findByFileVersionId_Last(long fileVersionId, OrderByComparator<DLFileVersionPreview> orderByComparator) throws NoSuchFileVersionPreviewException {
        DLFileVersionPreview dlFileVersionPreview = this.fetchByFileVersionId_Last(fileVersionId, orderByComparator);
        if (dlFileVersionPreview != null) {
            return dlFileVersionPreview;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("fileVersionId=");
        sb.append(fileVersionId);
        sb.append("}");
        throw new NoSuchFileVersionPreviewException(sb.toString());
    }

    public DLFileVersionPreview fetchByFileVersionId_Last(long fileVersionId, OrderByComparator<DLFileVersionPreview> orderByComparator) {
        int count = this.countByFileVersionId(fileVersionId);
        if (count == 0) {
            return null;
        }
        List<DLFileVersionPreview> list = this.findByFileVersionId(fileVersionId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLFileVersionPreview[] findByFileVersionId_PrevAndNext(long dlFileVersionPreviewId, long fileVersionId, OrderByComparator<DLFileVersionPreview> orderByComparator) throws NoSuchFileVersionPreviewException {
        DLFileVersionPreview dlFileVersionPreview = this.findByPrimaryKey(dlFileVersionPreviewId);
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersionPreview[] array = new DLFileVersionPreviewImpl[]{this.getByFileVersionId_PrevAndNext(session, dlFileVersionPreview, fileVersionId, orderByComparator, true), dlFileVersionPreview, this.getByFileVersionId_PrevAndNext(session, dlFileVersionPreview, fileVersionId, orderByComparator, false)};
            DLFileVersionPreview[] dLFileVersionPreviewArray = array;
            return dLFileVersionPreviewArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLFileVersionPreview getByFileVersionId_PrevAndNext(Session session, DLFileVersionPreview dlFileVersionPreview, long fileVersionId, OrderByComparator<DLFileVersionPreview> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_DLFILEVERSIONPREVIEW_WHERE);
        sb.append("dlFileVersionPreview.fileVersionId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY dlFileVersionPreview.dlFileVersionPreviewId DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(fileVersionId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)dlFileVersionPreview)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DLFileVersionPreview)list.get(1);
        }
        return null;
    }

    public void removeByFileVersionId(long fileVersionId) {
        for (DLFileVersionPreview dlFileVersionPreview : this.findByFileVersionId(fileVersionId, -1, -1, null)) {
            this.remove((BaseModel)dlFileVersionPreview);
        }
    }

    public int countByFileVersionId(long fileVersionId) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLFileVersionPreview.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByFileVersionId;
            finderArgs = new Object[]{fileVersionId};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_DLFILEVERSIONPREVIEW_WHERE);
            sb.append("dlFileVersionPreview.fileVersionId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(fileVersionId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DLFileVersionPreview findByF_F(long fileEntryId, long fileVersionId) throws NoSuchFileVersionPreviewException {
        DLFileVersionPreview dlFileVersionPreview = this.fetchByF_F(fileEntryId, fileVersionId);
        if (dlFileVersionPreview == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("fileEntryId=");
            sb.append(fileEntryId);
            sb.append(", fileVersionId=");
            sb.append(fileVersionId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchFileVersionPreviewException(sb.toString());
        }
        return dlFileVersionPreview;
    }

    public DLFileVersionPreview fetchByF_F(long fileEntryId, long fileVersionId) {
        return this.fetchByF_F(fileEntryId, fileVersionId, true);
    }

    public DLFileVersionPreview fetchByF_F(long fileEntryId, long fileVersionId, boolean useFinderCache) {
        DLFileVersionPreview dlFileVersionPreview;
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLFileVersionPreview.class);
        Object[] finderArgs = null;
        if (useFinderCache && productionMode) {
            finderArgs = new Object[]{fileEntryId, fileVersionId};
        }
        Object result = null;
        if (useFinderCache && productionMode) {
            result = this.finderCache.getResult(this._finderPathFetchByF_F, finderArgs);
        }
        if (result instanceof DLFileVersionPreview && (fileEntryId != (dlFileVersionPreview = (DLFileVersionPreview)result).getFileEntryId() || fileVersionId != dlFileVersionPreview.getFileVersionId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_DLFILEVERSIONPREVIEW_WHERE);
            sb.append("dlFileVersionPreview.fileEntryId = ? AND ");
            sb.append("dlFileVersionPreview.fileVersionId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(fileEntryId);
                queryPos.add(fileVersionId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache && productionMode) {
                        this.finderCache.putResult(this._finderPathFetchByF_F, finderArgs, (Object)list);
                    }
                } else {
                    DLFileVersionPreview dlFileVersionPreview2 = (DLFileVersionPreview)list.get(0);
                    result = dlFileVersionPreview2;
                    this.cacheResult(dlFileVersionPreview2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DLFileVersionPreview)result;
    }

    public DLFileVersionPreview removeByF_F(long fileEntryId, long fileVersionId) throws NoSuchFileVersionPreviewException {
        DLFileVersionPreview dlFileVersionPreview = this.findByF_F(fileEntryId, fileVersionId);
        return (DLFileVersionPreview)this.remove((BaseModel)dlFileVersionPreview);
    }

    public int countByF_F(long fileEntryId, long fileVersionId) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLFileVersionPreview.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByF_F;
            finderArgs = new Object[]{fileEntryId, fileVersionId};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_DLFILEVERSIONPREVIEW_WHERE);
            sb.append("dlFileVersionPreview.fileEntryId = ? AND ");
            sb.append("dlFileVersionPreview.fileVersionId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(fileEntryId);
                queryPos.add(fileVersionId);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DLFileVersionPreview findByF_F_P(long fileEntryId, long fileVersionId, int previewStatus) throws NoSuchFileVersionPreviewException {
        DLFileVersionPreview dlFileVersionPreview = this.fetchByF_F_P(fileEntryId, fileVersionId, previewStatus);
        if (dlFileVersionPreview == null) {
            StringBundler sb = new StringBundler(8);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("fileEntryId=");
            sb.append(fileEntryId);
            sb.append(", fileVersionId=");
            sb.append(fileVersionId);
            sb.append(", previewStatus=");
            sb.append(previewStatus);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchFileVersionPreviewException(sb.toString());
        }
        return dlFileVersionPreview;
    }

    public DLFileVersionPreview fetchByF_F_P(long fileEntryId, long fileVersionId, int previewStatus) {
        return this.fetchByF_F_P(fileEntryId, fileVersionId, previewStatus, true);
    }

    public DLFileVersionPreview fetchByF_F_P(long fileEntryId, long fileVersionId, int previewStatus, boolean useFinderCache) {
        DLFileVersionPreview dlFileVersionPreview;
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLFileVersionPreview.class);
        Object[] finderArgs = null;
        if (useFinderCache && productionMode) {
            finderArgs = new Object[]{fileEntryId, fileVersionId, previewStatus};
        }
        Object result = null;
        if (useFinderCache && productionMode) {
            result = this.finderCache.getResult(this._finderPathFetchByF_F_P, finderArgs);
        }
        if (result instanceof DLFileVersionPreview && (fileEntryId != (dlFileVersionPreview = (DLFileVersionPreview)result).getFileEntryId() || fileVersionId != dlFileVersionPreview.getFileVersionId() || previewStatus != dlFileVersionPreview.getPreviewStatus())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(5);
            sb.append(_SQL_SELECT_DLFILEVERSIONPREVIEW_WHERE);
            sb.append("dlFileVersionPreview.fileEntryId = ? AND ");
            sb.append(_FINDER_COLUMN_F_F_P_FILEVERSIONID_2);
            sb.append(_FINDER_COLUMN_F_F_P_PREVIEWSTATUS_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(fileEntryId);
                queryPos.add(fileVersionId);
                queryPos.add(previewStatus);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache && productionMode) {
                        this.finderCache.putResult(this._finderPathFetchByF_F_P, finderArgs, (Object)list);
                    }
                } else {
                    DLFileVersionPreview dlFileVersionPreview2 = (DLFileVersionPreview)list.get(0);
                    result = dlFileVersionPreview2;
                    this.cacheResult(dlFileVersionPreview2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DLFileVersionPreview)result;
    }

    public DLFileVersionPreview removeByF_F_P(long fileEntryId, long fileVersionId, int previewStatus) throws NoSuchFileVersionPreviewException {
        DLFileVersionPreview dlFileVersionPreview = this.findByF_F_P(fileEntryId, fileVersionId, previewStatus);
        return (DLFileVersionPreview)this.remove((BaseModel)dlFileVersionPreview);
    }

    public int countByF_F_P(long fileEntryId, long fileVersionId, int previewStatus) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLFileVersionPreview.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        Long count = null;
        if (productionMode) {
            finderPath = this._finderPathCountByF_F_P;
            finderArgs = new Object[]{fileEntryId, fileVersionId, previewStatus};
            count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_DLFILEVERSIONPREVIEW_WHERE);
            sb.append("dlFileVersionPreview.fileEntryId = ? AND ");
            sb.append(_FINDER_COLUMN_F_F_P_FILEVERSIONID_2);
            sb.append(_FINDER_COLUMN_F_F_P_PREVIEWSTATUS_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(fileEntryId);
                queryPos.add(fileVersionId);
                queryPos.add(previewStatus);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DLFileVersionPreviewPersistenceImpl() {
        this.setModelClass(DLFileVersionPreview.class);
        this.setModelImplClass(DLFileVersionPreviewImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)DLFileVersionPreviewTable.INSTANCE);
    }

    public void cacheResult(DLFileVersionPreview dlFileVersionPreview) {
        if (dlFileVersionPreview.getCtCollectionId() != 0L) {
            return;
        }
        this.entityCache.putResult(DLFileVersionPreviewImpl.class, (Serializable)Long.valueOf(dlFileVersionPreview.getPrimaryKey()), (Serializable)dlFileVersionPreview);
        this.finderCache.putResult(this._finderPathFetchByF_F, new Object[]{dlFileVersionPreview.getFileEntryId(), dlFileVersionPreview.getFileVersionId()}, (Object)dlFileVersionPreview);
        this.finderCache.putResult(this._finderPathFetchByF_F_P, new Object[]{dlFileVersionPreview.getFileEntryId(), dlFileVersionPreview.getFileVersionId(), dlFileVersionPreview.getPreviewStatus()}, (Object)dlFileVersionPreview);
    }

    public void cacheResult(List<DLFileVersionPreview> dlFileVersionPreviews) {
        for (DLFileVersionPreview dlFileVersionPreview : dlFileVersionPreviews) {
            if (dlFileVersionPreview.getCtCollectionId() != 0L || this.entityCache.getResult(DLFileVersionPreviewImpl.class, (Serializable)Long.valueOf(dlFileVersionPreview.getPrimaryKey())) != null) continue;
            this.cacheResult(dlFileVersionPreview);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(DLFileVersionPreviewImpl.class);
        this.finderCache.clearCache(DLFileVersionPreviewImpl.class);
    }

    public void clearCache(DLFileVersionPreview dlFileVersionPreview) {
        this.entityCache.removeResult(DLFileVersionPreviewImpl.class, (BaseModel)dlFileVersionPreview);
    }

    public void clearCache(List<DLFileVersionPreview> dlFileVersionPreviews) {
        for (DLFileVersionPreview dlFileVersionPreview : dlFileVersionPreviews) {
            this.entityCache.removeResult(DLFileVersionPreviewImpl.class, (BaseModel)dlFileVersionPreview);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(DLFileVersionPreviewImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(DLFileVersionPreviewImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(DLFileVersionPreviewModelImpl dlFileVersionPreviewModelImpl) {
        Object[] args = new Object[]{dlFileVersionPreviewModelImpl.getFileEntryId(), dlFileVersionPreviewModelImpl.getFileVersionId()};
        this.finderCache.putResult(this._finderPathCountByF_F, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByF_F, args, (Object)dlFileVersionPreviewModelImpl);
        args = new Object[]{dlFileVersionPreviewModelImpl.getFileEntryId(), dlFileVersionPreviewModelImpl.getFileVersionId(), dlFileVersionPreviewModelImpl.getPreviewStatus()};
        this.finderCache.putResult(this._finderPathCountByF_F_P, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByF_F_P, args, (Object)dlFileVersionPreviewModelImpl);
    }

    public DLFileVersionPreview create(long dlFileVersionPreviewId) {
        DLFileVersionPreviewImpl dlFileVersionPreview = new DLFileVersionPreviewImpl();
        dlFileVersionPreview.setNew(true);
        dlFileVersionPreview.setPrimaryKey(dlFileVersionPreviewId);
        dlFileVersionPreview.setCompanyId(CompanyThreadLocal.getCompanyId());
        return dlFileVersionPreview;
    }

    public DLFileVersionPreview remove(long dlFileVersionPreviewId) throws NoSuchFileVersionPreviewException {
        return this.remove(Long.valueOf(dlFileVersionPreviewId));
    }

    public DLFileVersionPreview remove(Serializable primaryKey) throws NoSuchFileVersionPreviewException {
        Session session = null;
        try {
            session = this.openSession();
            DLFileVersionPreview dlFileVersionPreview = (DLFileVersionPreview)session.get(DLFileVersionPreviewImpl.class, primaryKey);
            if (dlFileVersionPreview == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchFileVersionPreviewException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            DLFileVersionPreview dLFileVersionPreview = (DLFileVersionPreview)this.remove((BaseModel)dlFileVersionPreview);
            return dLFileVersionPreview;
        }
        catch (NoSuchFileVersionPreviewException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLFileVersionPreview removeImpl(DLFileVersionPreview dlFileVersionPreview) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)dlFileVersionPreview)) {
                dlFileVersionPreview = (DLFileVersionPreview)session.get(DLFileVersionPreviewImpl.class, dlFileVersionPreview.getPrimaryKeyObj());
            }
            if (dlFileVersionPreview != null && this.ctPersistenceHelper.isRemove((CTModel)dlFileVersionPreview)) {
                session.delete((Object)dlFileVersionPreview);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (dlFileVersionPreview != null) {
            this.clearCache(dlFileVersionPreview);
        }
        return dlFileVersionPreview;
    }

    public DLFileVersionPreview updateImpl(DLFileVersionPreview dlFileVersionPreview) {
        boolean isNew = dlFileVersionPreview.isNew();
        if (!(dlFileVersionPreview instanceof DLFileVersionPreviewModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(dlFileVersionPreview.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)dlFileVersionPreview);
                throw new IllegalArgumentException("Implement ModelWrapper in dlFileVersionPreview proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom DLFileVersionPreview implementation " + dlFileVersionPreview.getClass());
        }
        DLFileVersionPreviewModelImpl dlFileVersionPreviewModelImpl = (DLFileVersionPreviewModelImpl)dlFileVersionPreview;
        Session session = null;
        try {
            session = this.openSession();
            if (this.ctPersistenceHelper.isInsert((CTModel)dlFileVersionPreview)) {
                if (!isNew) {
                    session.evict(DLFileVersionPreviewImpl.class, dlFileVersionPreview.getPrimaryKeyObj());
                }
                session.save((Object)dlFileVersionPreview);
            } else {
                dlFileVersionPreview = (DLFileVersionPreview)session.merge((Object)dlFileVersionPreview);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (dlFileVersionPreview.getCtCollectionId() != 0L) {
            if (isNew) {
                dlFileVersionPreview.setNew(false);
            }
            dlFileVersionPreview.resetOriginalValues();
            return dlFileVersionPreview;
        }
        this.entityCache.putResult(DLFileVersionPreviewImpl.class, (BaseModel)dlFileVersionPreviewModelImpl, false, true);
        this.cacheUniqueFindersCache(dlFileVersionPreviewModelImpl);
        if (isNew) {
            dlFileVersionPreview.setNew(false);
        }
        dlFileVersionPreview.resetOriginalValues();
        return dlFileVersionPreview;
    }

    public DLFileVersionPreview findByPrimaryKey(Serializable primaryKey) throws NoSuchFileVersionPreviewException {
        DLFileVersionPreview dlFileVersionPreview = this.fetchByPrimaryKey(primaryKey);
        if (dlFileVersionPreview == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchFileVersionPreviewException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return dlFileVersionPreview;
    }

    public DLFileVersionPreview findByPrimaryKey(long dlFileVersionPreviewId) throws NoSuchFileVersionPreviewException {
        return this.findByPrimaryKey(Long.valueOf(dlFileVersionPreviewId));
    }

    public DLFileVersionPreview fetchByPrimaryKey(Serializable primaryKey) {
        if (this.ctPersistenceHelper.isProductionMode(DLFileVersionPreview.class)) {
            return (DLFileVersionPreview)super.fetchByPrimaryKey(primaryKey);
        }
        DLFileVersionPreview dlFileVersionPreview = null;
        Session session = null;
        try {
            session = this.openSession();
            dlFileVersionPreview = (DLFileVersionPreview)session.get(DLFileVersionPreviewImpl.class, primaryKey);
            if (dlFileVersionPreview != null) {
                this.cacheResult(dlFileVersionPreview);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return dlFileVersionPreview;
    }

    public DLFileVersionPreview fetchByPrimaryKey(long dlFileVersionPreviewId) {
        return this.fetchByPrimaryKey(Long.valueOf(dlFileVersionPreviewId));
    }

    public Map<Serializable, DLFileVersionPreview> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (this.ctPersistenceHelper.isProductionMode(DLFileVersionPreview.class)) {
            return super.fetchByPrimaryKeys(primaryKeys);
        }
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, DLFileVersionPreview> map = new HashMap<Serializable, DLFileVersionPreview>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            DLFileVersionPreview dlFileVersionPreview = this.fetchByPrimaryKey(primaryKey);
            if (dlFileVersionPreview != null) {
                map.put(primaryKey, dlFileVersionPreview);
            }
            return map;
        }
        StringBundler sb = new StringBundler(primaryKeys.size() * 2 + 1);
        sb.append(this.getSelectSQL());
        sb.append(" WHERE ");
        sb.append(this.getPKDBName());
        sb.append(" IN (");
        for (Serializable primaryKey : primaryKeys) {
            sb.append(((Long)primaryKey).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String sql = sb.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(sql);
            for (DLFileVersionPreview dlFileVersionPreview : query.list()) {
                map.put(dlFileVersionPreview.getPrimaryKeyObj(), dlFileVersionPreview);
                this.cacheResult(dlFileVersionPreview);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<DLFileVersionPreview> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<DLFileVersionPreview> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<DLFileVersionPreview> findAll(int start, int end, OrderByComparator<DLFileVersionPreview> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<DLFileVersionPreview> findAll(int start, int end, OrderByComparator<DLFileVersionPreview> orderByComparator, boolean useFinderCache) {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLFileVersionPreview.class);
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache && productionMode) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache && productionMode) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && productionMode) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_DLFILEVERSIONPREVIEW);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_DLFILEVERSIONPREVIEW;
                sql = sql.concat(" ORDER BY dlFileVersionPreview.dlFileVersionPreviewId DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache && productionMode) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (DLFileVersionPreview dlFileVersionPreview : this.findAll()) {
            this.remove((BaseModel)dlFileVersionPreview);
        }
    }

    public int countAll() {
        boolean productionMode = this.ctPersistenceHelper.isProductionMode(DLFileVersionPreview.class);
        Long count = null;
        if (productionMode) {
            count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        }
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_DLFILEVERSIONPREVIEW);
                count = (Long)query.uniqueResult();
                if (productionMode) {
                    this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "dlFileVersionPreviewId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_DLFILEVERSIONPREVIEW;
    }

    public Set<String> getCTColumnNames(CTColumnResolutionType ctColumnResolutionType) {
        return _ctColumnNamesMap.getOrDefault(ctColumnResolutionType, Collections.emptySet());
    }

    public List<String> getMappingTableNames() {
        return _mappingTableNames;
    }

    public Map<String, Integer> getTableColumnsMap() {
        return DLFileVersionPreviewModelImpl.TABLE_COLUMNS_MAP;
    }

    public String getTableName() {
        return "DLFileVersionPreview";
    }

    public List<String[]> getUniqueIndexColumnNames() {
        return _uniqueIndexColumnNames;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new DLFileVersionPreviewModelArgumentsResolver(), (Dictionary)new HashMapDictionary());
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByFileEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByFileEntryId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"fileEntryId"}, true);
        this._finderPathWithoutPaginationFindByFileEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByFileEntryId", new String[]{Long.class.getName()}, new String[]{"fileEntryId"}, true);
        this._finderPathCountByFileEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByFileEntryId", new String[]{Long.class.getName()}, new String[]{"fileEntryId"}, false);
        this._finderPathWithPaginationFindByFileVersionId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByFileVersionId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"fileVersionId"}, true);
        this._finderPathWithoutPaginationFindByFileVersionId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByFileVersionId", new String[]{Long.class.getName()}, new String[]{"fileVersionId"}, true);
        this._finderPathCountByFileVersionId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByFileVersionId", new String[]{Long.class.getName()}, new String[]{"fileVersionId"}, false);
        this._finderPathFetchByF_F = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByF_F", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"fileEntryId", "fileVersionId"}, true);
        this._finderPathCountByF_F = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByF_F", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"fileEntryId", "fileVersionId"}, false);
        this._finderPathFetchByF_F_P = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByF_F_P", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName()}, new String[]{"fileEntryId", "fileVersionId", "previewStatus"}, true);
        this._finderPathCountByF_F_P = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByF_F_P", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName()}, new String[]{"fileEntryId", "fileVersionId", "previewStatus"}, false);
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(DLFileVersionPreviewImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.document.library.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.document.library.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.document.library.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    static {
        HashSet<String> ctControlColumnNames = new HashSet<String>();
        HashSet<String> ctStrictColumnNames = new HashSet<String>();
        ctControlColumnNames.add("mvccVersion");
        ctControlColumnNames.add("ctCollectionId");
        ctStrictColumnNames.add("groupId");
        ctStrictColumnNames.add("companyId");
        ctStrictColumnNames.add("fileEntryId");
        ctStrictColumnNames.add("fileVersionId");
        ctStrictColumnNames.add("previewStatus");
        _ctColumnNamesMap.put(CTColumnResolutionType.CONTROL, ctControlColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.PK, Collections.singleton("dlFileVersionPreviewId"));
        _ctColumnNamesMap.put(CTColumnResolutionType.STRICT, ctStrictColumnNames);
        _uniqueIndexColumnNames.add(new String[]{"fileEntryId", "fileVersionId"});
        _uniqueIndexColumnNames.add(new String[]{"fileEntryId", "fileVersionId", "previewStatus"});
        _log = LogFactoryUtil.getLog(DLFileVersionPreviewPersistenceImpl.class);
    }

    private static class DLFileVersionPreviewModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache;
        private static final long _ORDER_BY_COLUMNS_BITMASK;

        private DLFileVersionPreviewModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return FINDER_ARGS_EMPTY;
                }
                return null;
            }
            DLFileVersionPreviewModelImpl dlFileVersionPreviewModelImpl = (DLFileVersionPreviewModelImpl)baseModel;
            long columnBitmask = dlFileVersionPreviewModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return DLFileVersionPreviewModelArgumentsResolver._getValue(dlFileVersionPreviewModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | DLFileVersionPreviewModelImpl.getColumnBitmask(columnName);
                }
                if (finderPath.isBaseModelResult() && FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION == finderPath.getCacheName()) {
                    finderPathColumnBitmask = finderPathColumnBitmask | _ORDER_BY_COLUMNS_BITMASK;
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return DLFileVersionPreviewModelArgumentsResolver._getValue(dlFileVersionPreviewModelImpl, columnNames, original);
            }
            return null;
        }

        public String getClassName() {
            return DLFileVersionPreviewImpl.class.getName();
        }

        public String getTableName() {
            return DLFileVersionPreviewTable.INSTANCE.getTableName();
        }

        private static Object[] _getValue(DLFileVersionPreviewModelImpl dlFileVersionPreviewModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? dlFileVersionPreviewModelImpl.getColumnOriginalValue(columnName) : dlFileVersionPreviewModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }

        static {
            long orderByColumnsBitmask;
            _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();
            _ORDER_BY_COLUMNS_BITMASK = orderByColumnsBitmask = 0L;
        }
    }
}

