/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.sync.internal.change.tracking.spi.listener;

import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.spi.listener.CTEventListener;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.sync.model.DLSyncEvent;
import com.liferay.document.library.sync.service.DLSyncEventLocalService;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageBus;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTEventListener.class})
public class SyncCTEventListener
implements CTEventListener {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private DLSyncEventLocalService _dlSyncEventLocalService;
    @Reference
    private MessageBus _messageBus;

    public void onAfterPublish(long ctCollectionId) {
        this._processPublish(ctCollectionId, this._classNameLocalService.getClassNameId(DLFolder.class), "folder");
        this._processPublish(ctCollectionId, this._classNameLocalService.getClassNameId(DLFileEntry.class), "file");
    }

    private String _getEvent(CTEntry ctEntry) {
        if (ctEntry.getChangeType() == 0) {
            return "add";
        }
        if (ctEntry.getChangeType() == 1) {
            return "delete";
        }
        return "update";
    }

    private void _processPublish(long ctCollectionId, long classNameId, String type) {
        for (CTEntry ctEntry : this._ctEntryLocalService.getCTEntries(ctCollectionId, classNameId)) {
            String event = this._getEvent(ctEntry);
            DLSyncEvent dlSyncEvent = this._dlSyncEventLocalService.addDLSyncEvent(event, type, ctEntry.getModelClassPK());
            TransactionCommitCallbackUtil.registerCallback(() -> {
                Message message = new Message();
                message.setValues((Map)HashMapBuilder.put((Object)"event", (Object)event).put((Object)"modifiedTime", (Object)dlSyncEvent.getModifiedTime()).put((Object)"type", (Object)type).put((Object)"typePK", (Object)dlSyncEvent.getTypePK()).build());
                this._messageBus.sendMessage("liferay/document_library_sync_event_processor", message);
                return null;
            });
        }
    }
}

